/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.LushCaveType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class LushVolcanicCaveType
extends BasicCaveType {
    public LushVolcanicCaveType(String domain, String path) {
        super(domain, path);
        this.floorCh = 5.0f;
        this.ceilCh = 15.0f;
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < -0.55) {
                this.replaceBlock(world, pos, Blocks.field_196814_hQ.func_176223_P());
            } else if (d < -0.2) {
                this.modifyBlock(world, pos, SubWildLookups.MOLTEN);
            } else if (d > 0.4) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            } else if (d > 0.2) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            if (this.getNoise(noise, pos, 0.2) > 0.4) {
                this.genBlock(world, pos, (BlockState)LushCaveType.LEAVES[(int)(this.getClampedNoise(noise, pos, 0.015625) * (double)LushCaveType.LEAVES.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(true)));
            }
            if (this.getNoise(noise, pos, 0.16) > 0.5) {
                this.genBlock(world, pos, LushCaveType.PLANTS[(int)(this.getClampedNoise(noise, pos, 0.03125) * (double)LushCaveType.PLANTS.length)].func_176223_P());
            }
            if (rand.nextInt(10) == 0) {
                this.genBlock(world, pos, LushCaveType.SAPLINGS[rand.nextInt(LushCaveType.SAPLINGS.length)].func_176223_P());
            } else if (rand.nextInt(45) == 0) {
                world.func_180501_a(pos, LushCaveType.MUSHROOMS[rand.nextInt(LushCaveType.MUSHROOMS.length)].func_176223_P(), 2);
            }
        }
        super.genFloorExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.1);
            if (d < -0.4) {
                this.modifyBlock(world, pos, SubWildLookups.MOLTEN);
            } else if (d > 0.2) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeilExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && this.getNoise(noise, pos, 0.125) < 0.1) {
            this.genVines(world, pos, Direction.UP, 1);
        }
        super.genCeilExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < -0.5) {
                this.modifyBlock(world, pos, SubWildLookups.MOLTEN);
            } else if (d > 0.4) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1) {
            int len = 3 + rand.nextInt(2);
            float ch = 0.2f;
            if (world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                ch += 0.35f;
                len += rand.nextInt(8);
            }
            if (rand.nextFloat() < ch) {
                this.genVines(world, pos, wallDir, len);
            }
        }
        super.genWallExtra(world, noise, pos, wallDir, depth, pass, rand);
    }
}

