/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.block;

import java.util.Random;
import melonslise.subwild.common.init.SubWildProperties;
import melonslise.subwild.common.init.SubWildTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpeleothemBlock
extends FallingBlock {
    public static final VoxelShape SMALL_STALAGMITE_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    public static final VoxelShape SMALL_STALACTITE_SHAPE = Block.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape MEDIUM_STALAGMITE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    public static final VoxelShape MEDIUM_STALACTITE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));
    public static final VoxelShape LARGE_STALAGMITE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    public static final VoxelShape LARGE_STALACTITE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0));
    public static final VoxelShape COLUMN_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SpeleothemBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208150_C, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)Direction.UP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208149_B}).func_206894_a(new Property[]{BlockStateProperties.field_208150_C}).func_206894_a(new Property[]{SubWildProperties.VERTICAL_FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        boolean stalagmite;
        boolean up = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B);
        boolean down = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208150_C);
        boolean bl = stalagmite = state.func_177229_b((Property)SubWildProperties.VERTICAL_FACING) == Direction.UP;
        if (!up && down && stalagmite) {
            return SMALL_STALAGMITE_SHAPE;
        }
        if (up && !down && !stalagmite) {
            return SMALL_STALACTITE_SHAPE;
        }
        if (!up && !down && stalagmite) {
            return MEDIUM_STALAGMITE_SHAPE;
        }
        if (!(up || down || stalagmite)) {
            return MEDIUM_STALACTITE_SHAPE;
        }
        if (up && !down && stalagmite) {
            return LARGE_STALAGMITE_SHAPE;
        }
        if (!up && down && !stalagmite) {
            return LARGE_STALACTITE_SHAPE;
        }
        return COLUMN_SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            this.startFalling((World)world, pos, state);
        }
    }

    public boolean canConnect(IWorldReader world, BlockPos pos, BlockState state, BlockPos toPos, BlockState toState) {
        return toState.func_235714_a_(SubWildTags.SPELEOTHEMS) && state.func_185909_g((IBlockReader)world, pos) == toState.func_185909_g((IBlockReader)world, toPos);
    }

    public boolean canSupport(IWorldReader world, BlockPos pos, BlockState state, BlockPos supPos, BlockState supState) {
        return this.canConnect(world, pos, state, supPos, supState) || supState.func_224755_d((IBlockReader)world, supPos, (Direction)state.func_177229_b((Property)SubWildProperties.VERTICAL_FACING));
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState adjState, IWorld world, BlockPos pos, BlockPos adjPos) {
        if (side.func_176740_k().func_200128_b() && this.canConnect((IWorldReader)world, pos, state, adjPos, adjState)) {
            state = (BlockState)state.func_206870_a((Property)SubWildProperties.FACING_LOOKUP.get(side), (Comparable)Boolean.valueOf(true));
        }
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            this.startFalling((World)world, pos, state);
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = this.func_176223_P();
        Direction face = ctx.func_196000_l();
        if (face.func_176740_k().func_200128_b()) {
            state = (BlockState)state.func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)face);
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            BlockPos adjPos = pos.func_177972_a(dir);
            BlockState adjState = world.func_180495_p(adjPos);
            if (!this.canSupport((IWorldReader)world, pos, state = (BlockState)state.func_206870_a((Property)SubWildProperties.FACING_LOOKUP.get(dir), (Comparable)Boolean.valueOf(this.canConnect((IWorldReader)world, pos, state, adjPos, adjState))), adjPos, adjState)) continue;
            state = (BlockState)state.func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)dir.func_176734_d());
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos supPos = pos.func_177972_a(((Direction)state.func_177229_b((Property)SubWildProperties.VERTICAL_FACING)).func_176734_d());
        return this.canSupport(world, pos, state, supPos, world.func_180495_p(supPos));
    }

    public void startFalling(World world, BlockPos pos, BlockState state) {
        if (!this.falling()) {
            return;
        }
        FallingBlockEntity falling = new FallingBlockEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
        falling.field_145808_f = true;
        this.func_149829_a(falling);
        world.func_217376_c((Entity)falling);
    }

    public boolean falling() {
        return true;
    }

    protected void func_149829_a(FallingBlockEntity falling) {
        falling.func_145806_a(true);
    }

    public void func_190974_b(World world, BlockPos pos, FallingBlockEntity entity) {
        world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)this.func_176223_P()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
    }
}

