/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class SubWildConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue EXPENSIVE_SCAN;
    public static final ForgeConfigSpec.IntValue SLOPE_THRESHOLD;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_WHITELIST;

    public static boolean isAllowed(World world) {
        String name = world.func_234923_W_().func_240901_a_().toString();
        for (String key : (List)DIMENSION_WHITELIST.get()) {
            if (!key.equals(name)) continue;
            return true;
        }
        return false;
    }

    static {
        ForgeConfigSpec.Builder cfg = new ForgeConfigSpec.Builder();
        EXPENSIVE_SCAN = cfg.comment("Enables the mod to decorate underground structures and allows for more compatibility with other terrain gen mods at the expense of slower performance. Note that caves in worlds with the same seed may be populated differently depending on this setting").define("Expensive Scan", true);
        SLOPE_THRESHOLD = cfg.comment("The amount of non-solid blocks in front of a cave wall at which stairs and slabs spawn at a reduced rate to avoid high density narrow caves").defineInRange("Slope Threshold", 2, 0, 16);
        DIMENSION_WHITELIST = cfg.comment("The dimensions in which cave biomes will generate in").defineList("Dimension Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:overworld"}), e -> e instanceof String);
        SPEC = cfg.build();
    }
}

