/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraftforge.common.Tags;

public class CoralCaveType
extends BasicCaveType {
    public static final Block[] CORAL_BLOCKS = new Block[]{Blocks.field_203964_jF, Blocks.field_203965_jG, Blocks.field_203966_jH, Blocks.field_203967_jI, Blocks.field_203963_jE};
    public static final Block[] CORAL = new Block[]{Blocks.field_204279_jK, Blocks.field_204744_jS, Blocks.field_204280_jL, Blocks.field_204745_jT, Blocks.field_204281_jM, Blocks.field_204746_jU, Blocks.field_204282_jN, Blocks.field_204747_jV, Blocks.field_204278_jJ, Blocks.field_204743_jR};
    public static final Block[] WALL_CORAL = new Block[]{Blocks.field_211892_jZ, Blocks.field_211893_ka, Blocks.field_211894_kb, Blocks.field_211895_kc, Blocks.field_211891_jY};

    public CoralCaveType(String domain, String path) {
        super(domain, path);
        this.defStairs = () -> Blocks.field_203210_he;
        this.defSlab = () -> Blocks.field_203200_bP;
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < 0.2) {
                this.replaceBlock(world, pos, CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.03125) * (double)CORAL_BLOCKS.length)].func_176223_P());
            } else if (d > 0.5) {
                this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            double d;
            if (this.getNoise(noise, pos, 0.15) > 0.1 || rand.nextInt(14) == 0) {
                this.genBlock(world, pos, CORAL[rand.nextInt(CORAL.length)].func_176223_P());
            }
            if ((d = this.getNoise(noise, pos, 0.12)) > 0.5 || rand.nextInt(18) == 0) {
                this.genKelp(world, pos, 1 + rand.nextInt(10));
            } else if (d > -0.2 || rand.nextInt(12) == 0) {
                if (this.getNoise(noise, pos, 0.13) > 0.0) {
                    this.genBlock(world, pos, Blocks.field_203198_aQ.func_176223_P());
                } else {
                    this.genBlock(world, pos, Blocks.field_203199_aR.func_176223_P());
                    this.genBlock(world, pos.func_177984_a(), (BlockState)Blocks.field_203199_aR.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.UPPER));
                }
            }
        }
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < -0.2) {
                this.replaceBlock(world, pos, CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.03125) * (double)CORAL_BLOCKS.length)].func_176223_P());
            } else if (d > 0.3) {
                this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeilExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < 0.2) {
                this.replaceBlock(world, pos, CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.03125) * (double)CORAL_BLOCKS.length)].func_176223_P());
            } else if (d > 0.4) {
                this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1 && (this.getNoise(noise, pos, 0.15) > 0.1 || rand.nextInt(18) == 0)) {
            this.genBlock(world, pos, (BlockState)WALL_CORAL[rand.nextInt(WALL_CORAL.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)wallDir.func_176734_d()));
        }
        super.genWallExtra(world, noise, pos, wallDir, depth, pass, rand);
    }

    @Override
    public void genFill(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public boolean canGenExtra(ISeedReader world, BlockPos pos, BlockState state, BlockPos sidePos, BlockState sideState, float depth, int pass, Direction dir) {
        return pass == 1 && state.func_177230_c() == Blocks.field_150355_j && (sideState.func_235714_a_((ITag)Tags.Blocks.ORES) || this.isNatural(world, sidePos, sideState));
    }

    @Override
    public boolean canGenFill(ISeedReader world, BlockPos pos, BlockState state, float depth, int pass) {
        return pass == 1 && state.func_177230_c() == Blocks.field_150355_j;
    }
}

