/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class DeadCoralCaveType
extends BasicCaveType {
    public static final Block[] DEAD_CORAL_BLOCKS = new Block[]{Blocks.field_204405_jF, Blocks.field_204406_jG, Blocks.field_204407_jH, Blocks.field_204408_jI, Blocks.field_204404_jE};
    public static final Block[] DEAD_CORAL = new Block[]{Blocks.field_212586_jZ, Blocks.field_211902_kq, Blocks.field_212587_ka, Blocks.field_211903_kr, Blocks.field_212588_kb, Blocks.field_211904_ks, Blocks.field_212589_kc, Blocks.field_211905_kt, Blocks.field_212585_jY, Blocks.field_211901_kp};
    public static final Block[] DEAD_WALL_CORAL = new Block[]{Blocks.field_211897_kl, Blocks.field_211898_km, Blocks.field_211899_kn, Blocks.field_211900_ko, Blocks.field_211896_kk};

    public DeadCoralCaveType(String domain, String path) {
        super(domain, path);
        this.defStairs = () -> Blocks.field_203210_he;
        this.defSlab = () -> Blocks.field_203200_bP;
        this.ceilCh = 4.0f;
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < -0.2) {
                this.replaceBlock(world, pos, DEAD_CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.015625) * (double)DEAD_CORAL_BLOCKS.length)].func_176223_P());
            } else if (d > 0.6) {
                this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            if (this.getNoise(noise, pos, 0.125) < 0.4) {
                this.genBlock(world, pos, ((Block)SubWildBlocks.WATER_PUDDLE.get()).func_176223_P());
            }
            if (this.getNoise(noise, pos, 0.15) > 0.6) {
                this.genBlock(world, pos, (BlockState)DEAD_CORAL[rand.nextInt(DEAD_CORAL.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
            }
        }
        super.genFloorExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            if (rand.nextDouble() < 0.2) {
                this.modifyBlock(world, pos, SubWildLookups.WET);
            } else {
                double d = this.getNoise(noise, pos, 0.125);
                if (d < -0.4) {
                    this.replaceBlock(world, pos, DEAD_CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.015625) * (double)DEAD_CORAL_BLOCKS.length)].func_176223_P());
                } else if (d > 0.2) {
                    this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
                }
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d < -0.2) {
                this.replaceBlock(world, pos, DEAD_CORAL_BLOCKS[(int)(this.getClampedNoise(noise, pos, 0.015625) * (double)DEAD_CORAL_BLOCKS.length)].func_176223_P());
            } else if (d > 0.4) {
                this.replaceBlock(world, pos, Blocks.field_180397_cI.func_176223_P());
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1 && this.getNoise(noise, pos, 0.15) > 0.5) {
            this.genBlock(world, pos, (BlockState)((BlockState)DEAD_WALL_CORAL[rand.nextInt(DEAD_WALL_CORAL.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)wallDir.func_176734_d()));
        }
        super.genWallExtra(world, noise, pos, wallDir, depth, pass, rand);
    }
}

