/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class LushCaveType
extends BasicCaveType {
    public static final Block[] LEAVES = new Block[]{Blocks.field_196574_ab, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196642_W};
    public static final Block[] SAPLINGS = new Block[]{Blocks.field_196680_y, Blocks.field_196675_u, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196674_t, Blocks.field_196676_v};
    public static final Block[] PLANTS = new Block[]{Blocks.field_196554_aH, Blocks.field_150349_c};
    public static final Block[] MUSHROOMS = new Block[]{Blocks.field_150337_Q, Blocks.field_150338_P};

    public LushCaveType(String domain, String path) {
        super(domain, path);
        this.floorCh = 5.0f;
        this.ceilCh = 15.0f;
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (-0.2 < d && d < 0.4) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            }
            if (this.getNoise(noise, pos, 0.25) < 0.2) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            BlockPos up;
            double d = this.getNoise(noise, pos, 0.1);
            if (d < -0.4) {
                this.genLayer(world, pos, ((Block)SubWildBlocks.MOSSY_DIRT_PATCH.get()).func_176223_P(), d, -1.0, -0.4, 3);
            } else if (d > 0.1) {
                this.genBlock(world, pos, ((Block)SubWildBlocks.WATER_PUDDLE.get()).func_176223_P());
            }
            if (this.getNoise(noise, pos, 0.125) > 0.0) {
                this.genBlock(world, pos, PLANTS[(int)(this.getClampedNoise(noise, pos, 0.03125) * (double)PLANTS.length)].func_176223_P());
            }
            if (rand.nextInt(10) == 0) {
                this.genBlock(world, pos, SAPLINGS[rand.nextInt(SAPLINGS.length)].func_176223_P());
            } else if (rand.nextInt(34) == 0) {
                world.func_180501_a(pos, MUSHROOMS[rand.nextInt(MUSHROOMS.length)].func_176223_P(), 2);
            }
            if (this.getNoise(noise, pos, 0.1) > -0.2) {
                this.genBlock(world, pos, (BlockState)LEAVES[(int)(this.getClampedNoise(noise, pos, 0.015625) * (double)LEAVES.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(true)));
            }
            if (this.getNoise(noise, up = pos.func_177984_a(), 0.1) > 0.4 && world.func_180495_p(up).func_196958_f()) {
                this.genBlock(world, up, (BlockState)LEAVES[(int)(this.getClampedNoise(noise, up, 0.015625) * (double)LEAVES.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(true)));
            }
            BlockPos upup = up.func_177984_a();
            if (this.getNoise(noise, up, 0.1) > 0.7 && world.func_180495_p(upup).func_196958_f()) {
                this.genBlock(world, upup, (BlockState)LEAVES[(int)(this.getClampedNoise(noise, upup, 0.015625) * (double)LEAVES.length)].func_176223_P().func_206870_a((Property)BlockStateProperties.field_208515_s, (Comparable)Boolean.valueOf(true)));
            }
        }
        super.genFloorExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            if (this.getNoise(noise, pos, 0.125) < -0.4) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            }
            if (this.getNoise(noise, pos, 0.25) < 0.1) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeilExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && this.getNoise(noise, pos, 0.125) < 0.1) {
            this.genVines(world, pos, Direction.UP, 1);
        }
        super.genCeilExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            if (this.getNoise(noise, pos, 0.125) < -0.4) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            }
            if (this.getNoise(noise, pos, 0.25) < 0.1) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1) {
            int len = 3 + rand.nextInt(3);
            float ch = 0.2f;
            if (world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                ch += 0.35f;
                len += rand.nextInt(14);
            }
            if (rand.nextFloat() < ch) {
                this.genVines(world, pos, wallDir, len);
            }
        }
        super.genWallExtra(world, noise, pos, wallDir, depth, pass, rand);
    }

    @Override
    public void genFill(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && rand.nextInt(12) == 0 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
            this.genBlock(world, pos, Blocks.field_196651_dG.func_176223_P());
        }
    }
}

