/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.LushCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.RockyCaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class MossyRockyCaveType
extends BasicCaveType {
    public MossyRockyCaveType(String domain, String path) {
        super(domain, path);
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (-0.4 < d && d < 0.7) {
                this.replaceBlock(world, pos, RockyCaveType.STONE[(int)(this.getClampedNoise(noise, pos, 0.1) * (double)RockyCaveType.STONE.length)].func_176223_P());
            } else if (d < -0.4) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
            if (-0.7 < d && d < 0.3) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            if (this.getNoise(noise, pos, 0.125) < -0.2) {
                this.genBlock(world, pos, ((Block)SubWildBlocks.WATER_PUDDLE.get()).func_176223_P());
            } else if (rand.nextInt(36) == 0) {
                world.func_180501_a(pos, LushCaveType.MUSHROOMS[rand.nextInt(LushCaveType.MUSHROOMS.length)].func_176223_P(), 2);
            }
            double d = this.getNoise(noise, pos, 0.1);
            if (-0.1 < d && d < 0.4) {
                this.genLayer(world, pos, ((Block)SubWildBlocks.GRAVEL_PATCH.get()).func_176223_P(), d, -0.1, 0.4, 5);
            }
            if (rand.nextInt(14) == 0) {
                this.genBlock(world, pos, (BlockState)((BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208158_K, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(rand)));
            }
        }
        super.genFloorExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (-0.4 < d && d < 0.7) {
                this.replaceBlock(world, pos, RockyCaveType.STONE[(int)(this.getClampedNoise(noise, pos, 0.1) * (double)RockyCaveType.STONE.length)].func_176223_P());
            } else if (d < -0.4) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
            if (-0.7 < d && d < 0.3) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
            if ((double)rand.nextFloat() < 0.15) {
                this.modifyBlock(world, pos, SubWildLookups.WET);
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeilExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && this.getNoise(noise, pos, 0.125) < (double)(-depth)) {
            this.genVines(world, pos, Direction.UP, 1);
        }
        super.genCeilExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (-0.4 < d && d < 0.7) {
                this.replaceBlock(world, pos, RockyCaveType.STONE[(int)(this.getClampedNoise(noise, pos, 0.1) * (double)RockyCaveType.STONE.length)].func_176223_P());
            } else if (d < -0.4) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
            if (-0.7 < d && d < 0.3) {
                this.modifyBlock(world, pos, SubWildLookups.MOSSY);
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1) {
            double ch = (1.0f - depth) * 0.3f;
            if (world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                ch *= 2.0;
            }
            if ((double)rand.nextFloat() < ch) {
                this.genVines(world, pos, wallDir, 1 + rand.nextInt((int)(7.0f - depth * 7.0f) + 1) + rand.nextInt(2));
            }
        }
        super.genWallExtra(world, noise, pos, wallDir, depth, pass, rand);
    }

    @Override
    public void genFill(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && rand.nextInt(12) == 0 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j) {
            this.genBlock(world, pos, Blocks.field_196651_dG.func_176223_P());
        }
    }
}

