/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class SandyRockyCaveType
extends BasicCaveType {
    public final boolean red;

    public SandyRockyCaveType(String domain, String path, boolean red) {
        super(domain, path);
        this.red = red;
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > 0.7) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_196582_bJ : Blocks.field_196580_bH).func_176223_P());
            } else if (d > 0.5) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_180395_cM : Blocks.field_150322_A).func_176223_P());
            } else if (d > 0.2) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_196611_F : Blocks.field_150354_m).func_176223_P());
            } else if (d > -0.2) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            double d = this.getNoise(noise, pos, 0.1);
            if (0.1 < d && d < 0.6) {
                this.genLayer(world, pos, ((Block)(this.red ? SubWildBlocks.RED_SAND_PATCH : SubWildBlocks.SAND_PATCH).get()).func_176223_P(), d, 0.1, 0.6, 5);
            }
            if (-0.3 < d && d < 0.1) {
                this.genLayer(world, pos, ((Block)SubWildBlocks.GRAVEL_PATCH.get()).func_176223_P(), d, -0.3, 0.1, 5);
            }
            if (rand.nextInt(42) == 0) {
                this.genBlock(world, pos, Blocks.field_196555_aI.func_176223_P());
            } else if (rand.nextInt(14) == 0) {
                this.genBlock(world, pos, (BlockState)((BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208158_K, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(rand)));
            }
        }
        super.genFloorExtra(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > 0.6) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_196582_bJ : Blocks.field_196580_bH).func_176223_P());
            } else if (d > 0.3) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_180395_cM : Blocks.field_150322_A).func_176223_P());
            } else if (d > -0.1) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > 0.4) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_196582_bJ : Blocks.field_196580_bH).func_176223_P());
            } else if (d > 0.0) {
                this.replaceBlock(world, pos, (this.red ? Blocks.field_180395_cM : Blocks.field_150322_A).func_176223_P());
            } else if (d > -0.2) {
                this.replaceBlock(world, pos, Blocks.field_150351_n.func_176223_P());
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }
}

