/*
 * Decompiled with CFR 0.152.
 */
package pajojeku.terrariamaterials.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pajojeku.terrariamaterials.init.ModItems;
import pajojeku.terrariamaterials.util.TermatConfig;

public class AutoSmeltEvent {
    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.HarvestDropsEvent event) {
        if (TermatConfig.HellstoneItems.enable_autosmelt) {
            ItemStack drop;
            ItemStack smelted;
            ArrayList newDrops;
            if (event.getHarvester() == null) {
                return;
            }
            Item mainHandItem = event.getHarvester().func_184614_ca().func_77973_b();
            boolean isSneaking = event.getHarvester().func_70093_af();
            boolean isWood = event.getState().func_177230_c().isWood((IBlockAccess)event.getWorld(), event.getPos());
            if (mainHandItem == ModItems.HELLSTONE_PICKAXE && isSneaking && !isWood) {
                newDrops = Lists.newArrayList();
                for (ItemStack mined : event.getDrops()) {
                    smelted = FurnaceRecipes.func_77602_a().func_151395_a(mined);
                    if (smelted.func_190926_b() || AutoSmeltEvent.isFood(smelted) || smelted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w)) continue;
                    event.getHarvester().func_184614_ca().func_77972_a(1, (EntityLivingBase)event.getHarvester());
                    drop = smelted.func_77946_l();
                    drop.func_190920_e(event.getDrops().size());
                    newDrops.add(drop);
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                    AutoSmeltEvent.spawnParticleAndSound(event.getPos(), event.getWorld());
                    AutoSmeltEvent.spawnExpOrbs(event.getHarvester(), event.getWorld(), event.getPos(), smelted);
                }
            }
            if (mainHandItem == ModItems.HELLSTONE_AXE && isSneaking && isWood) {
                newDrops = Lists.newArrayList();
                for (ItemStack chopped : event.getDrops()) {
                    smelted = FurnaceRecipes.func_77602_a().func_151395_a(chopped);
                    if (smelted.func_190926_b() || AutoSmeltEvent.isFood(smelted) || smelted.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w)) continue;
                    event.getHarvester().func_184614_ca().func_77972_a(1, (EntityLivingBase)event.getHarvester());
                    drop = smelted.func_77946_l();
                    drop.func_190920_e(event.getDrops().size());
                    newDrops.add(drop);
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                    AutoSmeltEvent.spawnParticleAndSound(event.getPos(), event.getWorld());
                    AutoSmeltEvent.spawnExpOrbs(event.getHarvester(), event.getWorld(), event.getPos(), smelted);
                }
            }
            if (mainHandItem == ModItems.HELLSTONE_SHOVEL && isSneaking && !isWood) {
                newDrops = Lists.newArrayList();
                for (ItemStack excavated : event.getDrops()) {
                    smelted = FurnaceRecipes.func_77602_a().func_151395_a(excavated);
                    if (smelted.func_190926_b() || smelted.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150359_w) || AutoSmeltEvent.isFood(smelted)) continue;
                    event.getHarvester().func_184614_ca().func_77972_a(1, (EntityLivingBase)event.getHarvester());
                    drop = smelted.func_77946_l();
                    drop.func_190920_e(event.getDrops().size());
                    newDrops.add(drop);
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                    AutoSmeltEvent.spawnParticleAndSound(event.getPos(), event.getWorld());
                    AutoSmeltEvent.spawnExpOrbs(event.getHarvester(), event.getWorld(), event.getPos(), smelted);
                }
            }
            if (mainHandItem == ModItems.HELLSTONE_HOE && isSneaking) {
                newDrops = Lists.newArrayList();
                for (ItemStack excavated : event.getDrops()) {
                    smelted = FurnaceRecipes.func_77602_a().func_151395_a(excavated);
                    if (smelted.func_190926_b() || !AutoSmeltEvent.isFood(smelted)) continue;
                    event.getHarvester().func_184614_ca().func_77972_a(1, (EntityLivingBase)event.getHarvester());
                    drop = smelted.func_77946_l();
                    drop.func_190920_e(event.getDrops().size());
                    newDrops.add(drop);
                    event.getDrops().clear();
                    event.getDrops().addAll(newDrops);
                    AutoSmeltEvent.spawnParticleAndSound(event.getPos(), event.getWorld());
                    AutoSmeltEvent.spawnExpOrbs(event.getHarvester(), event.getWorld(), event.getPos(), smelted);
                }
            }
        }
    }

    public static void spawnParticleAndSound(BlockPos pos, World worldIn) {
        worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K && worldIn instanceof WorldServer) {
            ((WorldServer)worldIn).func_180505_a(EnumParticleTypes.FLAME, false, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75, (double)pos.func_177952_p() + 0.5, 7, 0.0, 0.0, 0.0, (double)0.02f, new int[0]);
        }
    }

    public static void spawnExpOrbs(EntityPlayer playerIn, World worldIn, BlockPos pos, ItemStack smelted) {
        ItemStack furnaceStack = smelted.func_77946_l();
        if (!(playerIn instanceof FakePlayer)) {
            int xp = furnaceStack.func_190916_E();
            float f = FurnaceRecipes.func_77602_a().func_151398_b(furnaceStack);
            if (f == 0.0f) {
                xp = 0;
            } else if (f < 1.0f) {
                int j = MathHelper.func_76141_d((float)((float)xp * f));
                if (j < MathHelper.func_76123_f((float)((float)xp * f)) && (float)Math.random() < (float)xp * f - (float)j) {
                    ++j;
                }
                xp = j;
            }
            while (xp > 0) {
                int k = EntityXPOrb.func_70527_a((int)xp);
                xp -= k;
                worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), k));
            }
        }
    }

    public static boolean isFood(ItemStack stackIn) {
        return stackIn.func_77975_n() == EnumAction.EAT;
    }
}

