/*
 * Decompiled with CFR 0.152.
 */
package pajojeku.terrariamaterials.event;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pajojeku.terrariamaterials.init.ModItems;
import pajojeku.terrariamaterials.init.PotionInit;
import pajojeku.terrariamaterials.objects.items.potions.TrueInvisibilityEffect;
import pajojeku.terrariamaterials.util.TermatConfig;

public class TrueInvisibilityEvent {
    public static int tickExisted;
    public static final AttributeModifier CRYSTALLIZE_POTION_MODIFIER;
    public static int dur;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void turnInvisible(RenderLivingEvent.Pre event) {
        boolean hasPotion;
        EntityLivingBase living = event.getEntity();
        boolean bl = hasPotion = living.func_110148_a(TrueInvisibilityEffect.CRYSTALLIZE_EFFECT) != null ? living.func_110148_a(TrueInvisibilityEffect.CRYSTALLIZE_EFFECT).func_180374_a(CRYSTALLIZE_POTION_MODIFIER) : false;
        if (hasPotion) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityLivingBase living;
        if (event.getEntity() instanceof EntityLivingBase && (living = (EntityLivingBase)event.getEntity()).func_110140_aT().func_111151_a(TrueInvisibilityEffect.CRYSTALLIZE_EFFECT) == null) {
            living.func_110140_aT().func_111150_b(TrueInvisibilityEffect.CRYSTALLIZE_EFFECT);
        }
    }

    @SubscribeEvent
    public void trueInvisibilityStuff(TickEvent.PlayerTickEvent event) {
        EntityPlayer living = event.player;
        if (living != null) {
            if (living.func_70644_a(PotionInit.TRUE_INVISIBILITY_EFFECT)) {
                living.func_184596_c(MobEffects.field_76441_p);
                dur = living.func_70660_b(PotionInit.TRUE_INVISIBILITY_EFFECT).func_76459_b();
                living.func_70690_d(new PotionEffect(MobEffects.field_76441_p, dur, 0, false, false));
            }
            if (dur <= 5 && dur != 0 && !living.func_82150_aj()) {
                this.soundAndParticleEffect(living.field_70170_p, living);
                dur = 0;
            }
        }
    }

    @SubscribeEvent
    public void playerHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && TermatConfig.DemoniteItems.enable_stealth) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            World world = player.func_130014_f_();
            Random rand = new Random();
            int chance = rand.nextInt(6);
            if (!player.func_70644_a(PotionInit.TRUE_INVISIBILITY_EFFECT) && chance == 1 && this.demoniteEquiped(player)) {
                int dur = 75;
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, dur * 0, 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 1, false, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, dur - 10, 0, false, false));
                player.func_70690_d(new PotionEffect(PotionInit.TRUE_INVISIBILITY_EFFECT, dur, 0, false, false));
                this.soundAndParticleEffect(world, player);
            }
        }
    }

    public void soundAndParticleEffect(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ((WorldServer)world).func_184133_a(null, player.func_180425_c(), SoundEvents.field_187853_gC, SoundCategory.PLAYERS, 0.2f, 0.5f);
            ((WorldServer)world).func_180505_a(EnumParticleTypes.CLOUD, false, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 20, 1.0, 1.0, 1.0, 0.0, new int[0]);
        }
    }

    public boolean demoniteEquiped(EntityPlayer player) {
        boolean head = player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ModItems.DEMONITE_HELMET;
        boolean chest = player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == ModItems.DEMONITE_CHESTPLATE;
        boolean legs = player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == ModItems.DEMONITE_LEGGINS;
        boolean feet = player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == ModItems.DEMONITE_BOOTS;
        return head && chest && legs && feet;
    }

    static {
        CRYSTALLIZE_POTION_MODIFIER = new AttributeModifier(UUID.fromString("0B0BC123-E263-4EF8-9108-4B6503129C14"), "termat.trueinvisiblity", 0.0, 0);
    }
}

