/*
 * Decompiled with CFR 0.152.
 */
package pajojeku.terrariamaterials.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import pajojeku.terrariamaterials.util.BagBindingUtils;

public class InventoryPiggy
implements IInventory {
    protected NonNullList<ItemStack> inventory;
    private String special_tag;
    private String NBT_ITEMS;

    public InventoryPiggy(EntityPlayer player, String tag, String nbt, int size) {
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.special_tag = tag;
        this.NBT_ITEMS = nbt;
        this.readFromNBT(BagBindingUtils.getInventoryTagOfPlayer(player, this.special_tag));
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.save(entityPlayer);
    }

    public void save(EntityPlayer player) {
        NBTTagCompound tag = BagBindingUtils.getInventoryTagOfPlayer(player, this.special_tag);
        this.writeToNBT(tag);
        BagBindingUtils.setInventoryTagOfPlayer(player, this.special_tag, tag);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int slotIndex) {
        return (ItemStack)this.inventory.get(slotIndex);
    }

    @Nonnull
    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack.func_190916_E() <= decrementAmount) {
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        } else if ((itemStack = itemStack.func_77979_a(decrementAmount)).func_190916_E() == 0) {
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    @Nonnull
    public ItemStack func_70304_b(int slotIndex) {
        ItemStack stack = (ItemStack)this.inventory.get(slotIndex);
        this.inventory.remove((Object)stack);
        return stack;
    }

    public void func_70299_a(int slotIndex, @Nonnull ItemStack itemStack) {
        this.inventory.set(slotIndex, (Object)itemStack);
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_191420_l() {
        return this.inventory == null;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityPlayer) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slotIndex, @Nonnull ItemStack itemStack) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b(this.NBT_ITEMS) && nbtTagCompound.func_74764_b(this.NBT_ITEMS)) {
            NBTTagList tagList = nbtTagCompound.func_150295_c(this.NBT_ITEMS, 10);
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slotIndex = tagCompound.func_74771_c("Slot");
                if (slotIndex < 0 || slotIndex >= this.inventory.size()) continue;
                this.inventory.set((int)slotIndex, (Object)new ItemStack(tagCompound));
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a(this.NBT_ITEMS, (NBTBase)tagList);
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(keyName);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("");
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

