/*
 * Decompiled with CFR 0.152.
 */
package pajojeku.terrariamaterials.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import pajojeku.terrariamaterials.init.ModBlocks;
import pajojeku.terrariamaterials.util.TermatConfig;
import pajojeku.terrariamaterials.world.FlowerWorldGen;

public class ModWorldGen
implements IWorldGenerator {
    private FlowerWorldGen FlowerGen = new FlowerWorldGen();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos chunkCenter = new BlockPos(chunkX * 16 + 8, world.func_189649_b(chunkX * 16 + 8, chunkZ * 16 + 8), chunkZ * 16 + 8);
        if (world.field_73011_w.getDimension() == 0) {
            this.FlowerGen.func_180709_b(world, random, chunkCenter);
            this.generateChlorophyte(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        if (world.field_73011_w.getDimension() == -1) {
            this.generateHellstone(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private void generateChlorophyte(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int chance = TermatConfig.ChlorophyteItems.chlorophyte_ore_chance;
        int maxclustersize = 9;
        int minclustersize = 5;
        int minheight = 12;
        int maxheight = 30;
        int X = chunkX * 16;
        int Z = chunkZ * 16;
        BlockPos pos = new BlockPos(X, 64, Z);
        if (!TermatConfig.ChlorophyteItems.chlorophyte_ore_anywhere) {
            if (world.field_72995_K) {
                String s = world.getBiomeForCoordsBody(pos).func_185359_l();
                if (s.startsWith("Jungle") && TermatConfig.ChlorophyteItems.enable_chlorophyte_items) {
                    this.generateOre(ModBlocks.CHLOROPHYTE_ORE.func_176223_P(), world, random, X, Z, minheight, maxheight, random.nextInt(maxclustersize) + minclustersize, chance, Blocks.field_150348_b);
                }
            } else {
                Biome b = world.getBiomeForCoordsBody(pos);
                if (b == Biomes.field_76782_w || b == Biomes.field_150574_L || b == Biomes.field_76792_x || b == Biomes.field_185446_X || b == Biomes.field_185447_Y && TermatConfig.ChlorophyteItems.enable_chlorophyte_items) {
                    this.generateOre(ModBlocks.CHLOROPHYTE_ORE.func_176223_P(), world, random, X, Z, minheight, maxheight, random.nextInt(maxclustersize) + minclustersize, chance, Blocks.field_150348_b);
                }
            }
        } else {
            this.generateOre(ModBlocks.CHLOROPHYTE_ORE.func_176223_P(), world, random, X, Z, minheight, maxheight, random.nextInt(maxclustersize) + minclustersize, chance, Blocks.field_150348_b);
        }
    }

    private void generateHellstone(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int chance = 3;
        int maxclustersize = 9;
        int minclustersize = 5;
        int minheight = 0;
        int maxheight = 125;
        int X = chunkX * 16;
        int Z = chunkZ * 16;
        BlockPos pos = new BlockPos(X, 64, Z);
        this.generateOre(ModBlocks.HELLSTONE_ORE.func_176223_P(), world, random, X, Z, minheight, maxheight, random.nextInt(maxclustersize) + minclustersize, chance, Blocks.field_150424_aL);
    }

    private void generateOre(IBlockState ore, World world, Random random, int x, int z, int minY, int maxY, int size, int chances, Block block) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            WorldGenMinable generator = new WorldGenMinable(ore, size, (Predicate)BlockMatcher.func_177642_a((Block)block));
            generator.func_180709_b(world, random, pos);
        }
    }
}

