/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraheads.client;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import shetiphian.terraheads.BlockMobHead;
import shetiphian.terraheads.TileEntityMobHead;
import shetiphian.terraheads.client.ModelVillagerHead;
import shetiphian.terraheads.client.ModelWitchHead;

@OnlyIn(value=Dist.CLIENT)
public class RenderMobHead
extends TileEntityRenderer<TileEntityMobHead>
implements ISelectiveResourceReloadListener {
    public static RenderMobHead INSTANCE;
    public static ItemStack ENTITY_EQUIPPED;
    private static final Table<String, String, ResourceLocation> TEXTURE_CACHE;
    private static final Map<ResourceLocation, VillagerMetadataSection.HatType> HAT_CACHE;
    private static final ModelVillagerHead MODEL_VILLAGER;
    private static final ModelWitchHead MODEL_WITCH;

    public void func_147497_a(TileEntityRendererDispatcher dispatcher) {
        super.func_147497_a(dispatcher);
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)INSTANCE);
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.MODELS) || predicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            TEXTURE_CACHE.clear();
            HAT_CACHE.clear();
        }
    }

    public void render(TileEntityMobHead tile, double x, double y, double z, float partialTicks, int destroyStage) {
        float animation = 0.0f;
        BlockState blockstate = tile.func_195044_w();
        boolean isWall = blockstate.func_177230_c() instanceof WallSkullBlock;
        Direction direction = isWall ? (Direction)blockstate.func_177229_b((IProperty)WallSkullBlock.field_196302_a) : null;
        float rotation = 22.5f * (float)(isWall ? (2 + direction.func_176736_b()) * 4 : (Integer)blockstate.func_177229_b((IProperty)SkullBlock.field_196294_a));
        this.render((float)x, (float)y, (float)z, direction, rotation, ((BlockMobHead.MobHead)blockstate.func_177230_c()).getType(), destroyStage, animation, tile.getData1(), tile.getData2());
    }

    public void render(float x, float y, float z, Direction facing, float rotation, BlockMobHead.Type type, int destroyStage, float animation, String data1, String data2) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        AxisAlignedBB aabb = type.getShapeGround().func_197752_a();
        GlStateManager.translated((double)((double)x + (aabb.field_72336_d - aabb.field_72340_a)), (double)y, (double)((double)z + (aabb.field_72334_f - aabb.field_72339_c)));
        if (facing != null) {
            double height = (1.0 - (aabb.field_72337_e - aabb.field_72338_b)) / 2.0;
            switch (facing) {
                case NORTH: {
                    GlStateManager.translated((double)0.0, (double)height, (double)aabb.field_72339_c);
                    break;
                }
                case SOUTH: {
                    GlStateManager.translated((double)0.0, (double)height, (double)(-aabb.field_72339_c));
                    break;
                }
                case WEST: {
                    GlStateManager.translated((double)aabb.field_72340_a, (double)height, (double)0.0);
                    break;
                }
                default: {
                    GlStateManager.translated((double)(-aabb.field_72340_a), (double)height, (double)0.0);
                }
            }
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.enableAlphaTest();
        switch (type) {
            case VILLAGER: {
                this.renderVillagerHead(rotation, destroyStage >= 0, "villager", data1, data2);
                break;
            }
            case ZOMBIE_VILLAGER: {
                this.renderVillagerHead(rotation, destroyStage >= 0, "zombie_villager", data1, data2);
                break;
            }
            case ILLAGER: {
                this.renderVillagerHead(rotation, destroyStage >= 0, "illager", !Strings.isNullOrEmpty((String)data1) ? data1 : "pillager");
                break;
            }
            case WANDERING_TRADER: {
                this.renderVillagerHead(rotation, destroyStage >= 0, "", "wandering_trader");
                break;
            }
            case WITCH: {
                this.renderWitchHead(rotation, destroyStage >= 0);
            }
        }
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void renderVillagerHead(float rotation, boolean breaking, String folder, String type) {
        if (!breaking) {
            this.func_147499_a(this.getTexture(folder, type));
        }
        MODEL_VILLAGER.renderWithHood(rotation, 0.0f, 0.0625f);
    }

    private void renderVillagerHead(float rotation, boolean breaking, String folder, String type, String profession) {
        if (!breaking) {
            this.func_147499_a(this.getTexture(folder, folder));
        }
        MODEL_VILLAGER.renderBase(rotation, 0.0f, 0.0625f);
        if (!breaking) {
            boolean renderTypeHat;
            ResourceLocation texType = this.getTexture(folder + "/type", type);
            ResourceLocation texProfession = this.getTexture(folder + "/profession", Strings.isNullOrEmpty((String)profession) || profession.endsWith("none") ? "" : profession);
            VillagerMetadataSection.HatType tHat = this.getHatType(texType);
            VillagerMetadataSection.HatType pHat = this.getHatType(texProfession);
            boolean bl = renderTypeHat = pHat == VillagerMetadataSection.HatType.NONE || pHat == VillagerMetadataSection.HatType.PARTIAL && tHat != VillagerMetadataSection.HatType.FULL;
            if (renderTypeHat && texType != MissingTextureSprite.func_195675_b()) {
                this.func_147499_a(texType);
                MODEL_VILLAGER.renderOverlay(rotation, 0.0f, 0.0625f);
            }
            if (texProfession != MissingTextureSprite.func_195675_b()) {
                this.func_147499_a(texProfession);
                MODEL_VILLAGER.renderOverlay(rotation, 0.0f, 0.0625f);
            }
        }
    }

    private VillagerMetadataSection.HatType getHatType(ResourceLocation location) {
        if (location != null && location != MissingTextureSprite.func_195675_b()) {
            if (!HAT_CACHE.containsKey(location)) {
                VillagerMetadataSection.HatType type = VillagerMetadataSection.HatType.NONE;
                try (IResource iresource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);){
                    VillagerMetadataSection villagermetadatasection = (VillagerMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (villagermetadatasection != null) {
                        type = villagermetadatasection.func_217826_a();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                HAT_CACHE.put(location, type);
            }
            return HAT_CACHE.get(location);
        }
        return VillagerMetadataSection.HatType.NONE;
    }

    private void renderWitchHead(float rotation, boolean breaking) {
        if (!breaking) {
            this.func_147499_a(this.getTexture("", "witch"));
        }
        MODEL_WITCH.render(rotation, 0.0f, 0.0625f);
    }

    private ResourceLocation getTexture(String subFolder, String file) {
        if (!Strings.isNullOrEmpty((String)file)) {
            if (Strings.isNullOrEmpty((String)subFolder)) {
                subFolder = "|";
            }
            if (!TEXTURE_CACHE.contains((Object)subFolder, (Object)file)) {
                int i = file.indexOf(":");
                String modId = i > 0 ? file.substring(0, i) : "minecraft";
                String name = i > 0 ? file.substring(i + 1) : file;
                ResourceLocation location = new ResourceLocation(modId, "textures/entity/" + (subFolder.equals("|") ? "" : subFolder + "/") + name + ".png");
                TEXTURE_CACHE.put((Object)subFolder, (Object)file, (Object)location);
            }
            return (ResourceLocation)TEXTURE_CACHE.get((Object)subFolder, (Object)file);
        }
        return MissingTextureSprite.func_195675_b();
    }

    static {
        ENTITY_EQUIPPED = ItemStack.field_190927_a;
        TEXTURE_CACHE = HashBasedTable.create();
        HAT_CACHE = new HashMap<ResourceLocation, VillagerMetadataSection.HatType>();
        MODEL_VILLAGER = new ModelVillagerHead();
        MODEL_WITCH = new ModelWitchHead();
    }
}

