/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;

public abstract class BlockCloudBase
extends Block
implements ICloud {
    public BlockCloudBase(MaterialColor color) {
        this(Block.Properties.func_200949_a((Material)CloudAPI.materialCloud, (MaterialColor)color).func_200948_a(0.7f, 0.5f).func_200947_a(CloudAPI.soundTypeCloud).harvestTool(ToolType.SHOVEL).harvestLevel(0));
    }

    public BlockCloudBase(Block.Properties properties) {
        super(properties);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_220081_d(state, worldIn, pos);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return CloudPresets.isFlammable();
    }

    public PushReaction func_149656_h(BlockState state) {
        return CloudPresets.getPushReaction();
    }

    public boolean isFoliage(BlockState state, IWorldReader world, BlockPos pos) {
        return CloudPresets.isFoliage();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
            return super.func_220071_b(state, world, pos, context);
        }
        return VoxelShapes.func_197880_a();
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        CloudPresets.onEntityWalking(world, pos, entity);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        CloudPresets.onEntityCollision(state, world, pos, entity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean isCloudBlock(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean isCloudKickable(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }
}

