/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.ButtonIcon;
import shetiphian.core.common.ColorHelper;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketColorizer;

public class GuiColorizer
extends Screen {
    private static final Map<DyeColor, ItemStack> WOOL_STACKS = GuiColorizer.buildMap();
    private final ItemStack colorizer;
    private TextFieldWidget textField;
    private final int xSize = 138;
    private final int ySize = 110;
    private Mode mode = Mode.HSL;
    private final float[] slider = new float[]{0.5f, 1.0f, 0.5f};
    private final float[] lastSlider = new float[]{-1.0f, -1.0f, -1.0f};
    private int sColor = -1;
    private int lvColor = -1;
    private int resultColor = -1;
    private short resultIndex = (short)4096;
    private DyeColor resultDye = DyeColor.WHITE;
    private final short[] presetIndex = new short[18];
    private final String[] presetName = new String[18];
    private byte savePreset = (byte)-1;

    private static Map<DyeColor, ItemStack> buildMap() {
        HashMap<DyeColor, ItemStack> map = new HashMap<DyeColor, ItemStack>();
        map.put(DyeColor.WHITE, new ItemStack((IItemProvider)Blocks.field_196556_aL));
        map.put(DyeColor.ORANGE, new ItemStack((IItemProvider)Blocks.field_196557_aM));
        map.put(DyeColor.MAGENTA, new ItemStack((IItemProvider)Blocks.field_196558_aN));
        map.put(DyeColor.LIGHT_BLUE, new ItemStack((IItemProvider)Blocks.field_196559_aO));
        map.put(DyeColor.YELLOW, new ItemStack((IItemProvider)Blocks.field_196560_aP));
        map.put(DyeColor.LIME, new ItemStack((IItemProvider)Blocks.field_196561_aQ));
        map.put(DyeColor.PINK, new ItemStack((IItemProvider)Blocks.field_196562_aR));
        map.put(DyeColor.GRAY, new ItemStack((IItemProvider)Blocks.field_196563_aS));
        map.put(DyeColor.LIGHT_GRAY, new ItemStack((IItemProvider)Blocks.field_196564_aT));
        map.put(DyeColor.CYAN, new ItemStack((IItemProvider)Blocks.field_196565_aU));
        map.put(DyeColor.PURPLE, new ItemStack((IItemProvider)Blocks.field_196566_aV));
        map.put(DyeColor.BLUE, new ItemStack((IItemProvider)Blocks.field_196567_aW));
        map.put(DyeColor.BROWN, new ItemStack((IItemProvider)Blocks.field_196568_aX));
        map.put(DyeColor.GREEN, new ItemStack((IItemProvider)Blocks.field_196569_aY));
        map.put(DyeColor.RED, new ItemStack((IItemProvider)Blocks.field_196570_aZ));
        map.put(DyeColor.BLACK, new ItemStack((IItemProvider)Blocks.field_196602_ba));
        return map;
    }

    public GuiColorizer(ItemStack stack) {
        super((ITextComponent)new StringTextComponent(""));
        this.colorizer = stack;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
            this.resultIndex = ((ItemColorizer)stack.func_77973_b()).getRGB16(stack);
            this.resultColor = RGB16Helper.getColor((short)this.resultIndex);
            this.setSliders(ColorHelper.colorToHSL((int)this.resultColor));
        }
    }

    public void init() {
        super.init();
        int winX = (this.width - this.xSize) / 2;
        int winY = (this.height - this.ySize) / 2;
        if (!this.colorizer.func_190926_b() && this.colorizer.func_77973_b() instanceof ItemColorizer) {
            ListNBT tagList = ((ItemColorizer)this.colorizer.func_77973_b()).getNBTTagList(this.colorizer);
            for (int preset = 0; preset < 18; preset = (int)((byte)(preset + 1))) {
                CompoundNBT tagPresets = tagList.func_150305_b(preset);
                this.presetIndex[preset] = tagPresets.func_74765_d("rgb16");
                this.presetName[preset] = tagPresets.func_74779_i("name");
            }
        }
        this.buttons.clear();
        this.children.clear();
        this.addButton((Widget)new ButtonMode(this, winX + 17, winY + 12, Mode.RGB));
        this.addButton((Widget)new ButtonMode(this, winX + 53, winY + 12, Mode.HSL));
        this.addButton((Widget)new ButtonMode(this, winX + 89, winY + 12, Mode.HSV));
        this.addButton((Widget)new ButtonSlider(this, winX + 12, winY + 31, 10, 10, ButtonSlider.Segment.RED, ButtonSlider.Operation.SUBTRACT));
        this.addButton((Widget)new ButtonSlider(this, winX + 26, winY + 33, 50, 6, ButtonSlider.Segment.RED, ButtonSlider.Operation.SELECT));
        this.addButton((Widget)new ButtonSlider(this, winX + 80, winY + 31, 10, 10, ButtonSlider.Segment.RED, ButtonSlider.Operation.ADD));
        this.addButton((Widget)new ButtonSlider(this, winX + 12, winY + 45, 10, 10, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.SUBTRACT));
        this.addButton((Widget)new ButtonSlider(this, winX + 26, winY + 47, 50, 6, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.SELECT));
        this.addButton((Widget)new ButtonSlider(this, winX + 80, winY + 45, 10, 10, ButtonSlider.Segment.GREEN, ButtonSlider.Operation.ADD));
        this.addButton((Widget)new ButtonSlider(this, winX + 12, winY + 59, 10, 10, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.SUBTRACT));
        this.addButton((Widget)new ButtonSlider(this, winX + 26, winY + 61, 50, 6, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.SELECT));
        this.addButton((Widget)new ButtonSlider(this, winX + 80, winY + 59, 10, 10, ButtonSlider.Segment.BLUE, ButtonSlider.Operation.ADD));
        for (int row = 0; row < 2; row = (int)((byte)(row + 1))) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                int index = row * 9 + col;
                this.addButton((Widget)new ButtonPreset(this, winX + 17 + col * 12, winY + 78 + row * 12, index));
            }
        }
        if (this.savePreset > -1) {
            for (Widget button : this.buttons) {
                button.active = false;
            }
            this.addButton((Widget)new Button(this, winX + 78, winY + 59, 1));
            this.addButton((Widget)new Button(this, winX + 93, winY + 59, 2));
            this.addButton((Widget)new Button(this, winX + 35, winY + 59, 3));
            if (this.savePreset < 32) {
                this.textField = new TextFieldWidget(this.font, winX + 35, winY + 40, 68, 10, "");
                this.textField.func_146189_e(true);
                this.textField.func_146203_f(32);
                this.textField.func_146195_b(true);
                this.textField.func_146180_a("");
            }
        }
    }

    public void tick() {
        if (this.textField != null) {
            this.textField.func_146178_a();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawGuiContainerBackgroundLayer();
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        for (Widget button : this.buttons) {
            button.render(mouseX, mouseY, partialTicks);
        }
        this.drawGuiContainerForegroundLayer(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.enableDepthTest();
        RenderHelper.func_74519_b();
    }

    private void drawGuiContainerBackgroundLayer() {
        int winX = (this.width - this.xSize) / 2;
        int winY = (this.height - this.ySize) / 2;
        GuiFunctions.enterDrawTextureStateWithBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.COLORIZER.get());
        this.blit(winX, winY, 0, 0, this.xSize, this.ySize);
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.slider[0] != this.lastSlider[0] || this.slider[1] != this.lastSlider[1] || this.slider[2] != this.lastSlider[2]) {
            this.setupColors();
        }
        switch (this.mode) {
            case RGB: {
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 33), (double)(winX + 76), (double)(winY + 39), (float)this.blitOffset, (int)-65536, (int)-16777216, (int)-16777216, (int)-65536);
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (float)this.blitOffset, (int)-16711936, (int)-16777216, (int)-16777216, (int)-16711936);
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (float)this.blitOffset, (int)-16776961, (int)-16777216, (int)-16777216, (int)-16776961);
                break;
            }
            case HSL: {
                GuiFunctions.drawTextureScaled((double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (float)this.blitOffset, (int[])new int[]{77, 256});
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (float)this.blitOffset, (int)this.sColor, (int)-8421505, (int)-8421505, (int)this.sColor);
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 61), (double)(winX + 51), (double)(winY + 67), (float)this.blitOffset, (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
                GuiFunctions.drawGradientRect((double)(winX + 51), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (float)this.blitOffset, (int)-1, (int)this.lvColor, (int)this.lvColor, (int)-1);
                break;
            }
            case HSV: {
                GuiFunctions.drawTextureScaled((double)(winX + 26), (double)(winY + 33), (int)0, (int)250, (int)50, (int)6, (double)1.0, (float)this.blitOffset, (int[])new int[]{77, 256});
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 47), (double)(winX + 76), (double)(winY + 53), (float)this.blitOffset, (int)this.sColor, (int)-1, (int)-1, (int)this.sColor);
                GuiFunctions.drawGradientRect((double)(winX + 26), (double)(winY + 61), (double)(winX + 76), (double)(winY + 67), (float)this.blitOffset, (int)this.lvColor, (int)-16777216, (int)-16777216, (int)this.lvColor);
            }
        }
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[0])), (double)(winY + 33), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.blitOffset, (int[])new int[0]);
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[1])), (double)(winY + 47), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.blitOffset, (int[])new int[0]);
        GuiFunctions.drawTextureScaled((double)((double)winX + 24.75 + (double)(50.0f * this.slider[2])), (double)(winY + 61), (int)0, (int)206, (int)10, (int)24, (double)0.25, (float)this.blitOffset, (int[])new int[0]);
        GuiColorizer.fill((int)(winX + 94), (int)(winY + 34), (int)(winX + 126), (int)(winY + 66), (int)RGB16Helper.getColor((short)this.resultIndex));
        if (this.savePreset < 0) {
            GuiFunctions.enterRenderItemState();
            this.itemRenderer.func_180450_b(WOOL_STACKS.get(this.resultDye), winX + 110, winY + 50);
            GuiFunctions.exitRenderItemState();
        }
    }

    private void drawGuiContainerForegroundLayer(int mouseX, int mouseY, float partialTicks) {
        int winX = (this.width - this.xSize) / 2;
        int winY = (this.height - this.ySize) / 2;
        if (this.savePreset < 0) {
            if (mouseX >= winX + 94 && mouseY >= winY + 34 && mouseX <= winX + 126 && mouseY <= winY + 66) {
                String colorInfo = RGB16Helper.getTooltip((short)this.resultIndex) + "\u00a77 - \u00a7" + ItemColorizer.getFormatCode(this.resultDye) + Localization.get((String)this.resultDye.func_176762_d());
                ArrayList<String> list = new ArrayList<String>();
                list.add(colorInfo);
                this.renderTooltip(list, mouseX, mouseY);
                return;
            }
            for (Widget button : this.buttons) {
                if (!(button instanceof ButtonPreset) || !button.isMouseOver((double)mouseX, (double)mouseY)) continue;
                int index = ((ButtonPreset)button).getIndex();
                ArrayList<String> list = new ArrayList<String>();
                if (!Strings.isNullOrEmpty((String)this.presetName[index])) {
                    list.add(this.presetName[index]);
                }
                list.add(RGB16Helper.getTooltip((short)this.presetIndex[index]));
                list.add("");
                list.add("\u00a77\u00a7o" + Localization.get((String)"info.colorizer.preset.save.txt"));
                list.add("\u00a77\u00a7o" + Localization.get((String)"info.colorizer.preset.load.txt"));
                this.renderTooltip(list, mouseX, mouseY);
                return;
            }
        } else {
            GuiFunctions.enterDrawTextureStateWithBlend();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.blit(winX + 18, winY + 28, 154, 0, 102, 53);
            GuiFunctions.exitDrawTextureStateWithBlend();
            ((Widget)this.buttons.get(30)).render(mouseX, mouseY, partialTicks);
            ((Widget)this.buttons.get(31)).render(mouseX, mouseY, partialTicks);
            ((Widget)this.buttons.get(32)).render(mouseX, mouseY, partialTicks);
            this.textField.render(mouseX, mouseY, partialTicks);
        }
    }

    public boolean charTyped(char character, int keyCode) {
        if (this.textField != null && this.textField.func_146176_q() && this.textField.charTyped(character, keyCode)) {
            return true;
        }
        return super.charTyped(character, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.savePreset == -1) {
            Minecraft mc = Minecraft.func_71410_x();
            if (keyCode == 256 || keyCode == mc.field_71474_y.field_151445_Q.getKey().func_197937_c()) {
                mc.func_147108_a(null);
                if (mc.field_71462_r == null) {
                    mc.func_213228_a(true);
                }
            }
            NetworkHandler.sendToServer(new PacketColorizer(-1, this.resultIndex, ""));
            return true;
        }
        if (keyCode == 256 || keyCode == 257) {
            if (keyCode == 257) {
                this.saveAndSyncPreset();
            }
            this.savePreset = (byte)-1;
            this.init();
            return true;
        }
        if (this.textField != null && this.textField.func_146176_q() && this.textField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.textField != null && this.textField.func_146176_q() && this.textField.func_223281_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.textField != null && this.textField.func_146176_q() && this.textField.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.textField != null && this.textField.func_146176_q() && this.textField.mouseDragged(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.textField != null && this.textField.func_146176_q() && this.textField.mouseScrolled(mouseX, mouseY, scroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    private void setSliders(float[] values) {
        if (values != null && values.length == 3) {
            for (int index = 0; index < 3; index = (int)((byte)(index + 1))) {
                this.slider[index] = MathHelper.func_76131_a((float)values[index], (float)0.0f, (float)1.0f);
            }
        }
    }

    private void setupColors() {
        this.lastSlider[0] = this.slider[0];
        this.lastSlider[1] = this.slider[1];
        this.lastSlider[2] = this.slider[2];
        switch (this.mode) {
            case RGB: {
                this.resultColor = ColorHelper.rgbToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSL: {
                this.sColor = ColorHelper.hslToColor((float)this.slider[0], (float)1.0f, (float)0.5f);
                this.lvColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)0.5f);
                this.resultColor = ColorHelper.hslToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
                break;
            }
            case HSV: {
                this.sColor = ColorHelper.hsvToColor((float)this.slider[0], (float)1.0f, (float)1.0f);
                this.lvColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)1.0f);
                this.resultColor = ColorHelper.hsvToColor((float)this.slider[0], (float)this.slider[1], (float)this.slider[2]);
            }
        }
        this.resultIndex = RGB16Helper.getIndexFor((int)this.resultColor);
        this.resultDye = RGB16Helper.getDyeColor((short)this.resultIndex);
    }

    private void saveAndSyncPreset() {
        if (!this.colorizer.func_190926_b() && this.colorizer.func_77973_b() instanceof ItemColorizer) {
            ((ItemColorizer)this.colorizer.func_77973_b()).setRGB16Preset(this.colorizer, this.savePreset, this.resultIndex, this.textField.func_146179_b());
        }
        NetworkHandler.sendToServer(new PacketColorizer(this.savePreset, this.resultIndex, this.textField.func_146179_b()));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class Button
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final int index;
        private final Point normal = new Point(60, 230);
        private final Point hover = new Point(70, 230);
        private final Point pressed = new Point(80, 230);

        Button(GuiColorizer parent, int x, int y, int index) {
            super(x, y, 10, 10);
            this.parent = parent;
            this.index = index;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (!this.visible) {
                return;
            }
            this.isHovered = this.active && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            Minecraft mc = Minecraft.func_71410_x();
            Point txPoint = this.isHovered ? (mc.field_71417_B.func_198030_b() ? this.pressed : this.hover) : this.normal;
            GuiFunctions.enterDrawTextureStateWithBlend();
            mc.func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.blit(this.x, this.y, txPoint.x, txPoint.y, this.width, this.height);
            this.blit(this.x, this.y, 10 * this.index, 220, this.width, this.height);
            GuiFunctions.exitDrawTextureStateWithBlend();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                if (this.index == 1 || this.index == 2) {
                    if (this.index == 1) {
                        this.parent.saveAndSyncPreset();
                    }
                    this.parent.savePreset = (byte)-1;
                    this.parent.init();
                } else if (this.index == 3) {
                    this.parent.textField.func_146180_a(this.parent.textField.func_146179_b() + "\u00a7");
                }
                return true;
            }
            return false;
        }
    }

    private static class ButtonPreset
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final int index;
        private final int color;

        public ButtonPreset(GuiColorizer parent, int posX, int posY, int index) {
            super(posX, posY, 8, 8);
            this.parent = parent;
            this.index = index;
            this.color = RGB16Helper.getColor((short)parent.presetIndex[index]);
        }

        public int getIndex() {
            return this.index;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (!this.visible) {
                return;
            }
            this.isHovered = this.active && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            Screen.fill((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.color);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                if (button == 0) {
                    this.parent.resultIndex = this.parent.presetIndex[this.index];
                    this.parent.resultColor = RGB16Helper.getColor((short)this.parent.resultIndex);
                    switch (this.parent.mode) {
                        case RGB: {
                            this.parent.setSliders(ColorHelper.colorToRGB((int)this.parent.resultColor));
                            break;
                        }
                        case HSL: {
                            this.parent.setSliders(ColorHelper.colorToHSL((int)this.parent.resultColor));
                            break;
                        }
                        case HSV: {
                            this.parent.setSliders(ColorHelper.colorToHSV((int)this.parent.resultColor));
                        }
                    }
                } else if (button == 1) {
                    this.parent.savePreset = (byte)this.index;
                    this.parent.init();
                }
                return true;
            }
            return false;
        }
    }

    private static class ButtonSlider
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final Operation operation;
        private final Segment segment;

        public ButtonSlider(GuiColorizer parent, int posX, int posY, int sizeX, int sizeY, Segment segment, Operation operation) {
            super(posX, posY, sizeX, sizeY);
            this.parent = parent;
            this.operation = operation;
            this.segment = segment;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (!this.visible || this.operation == Operation.SELECT) {
                return;
            }
            this.isHovered = this.active && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            Minecraft mc = Minecraft.func_71410_x();
            Point txPoint = this.isHovered ? (mc.field_71417_B.func_198030_b() ? this.operation.pressed : this.operation.hover) : this.operation.normal;
            GuiFunctions.enterDrawTextureStateWithBlend();
            mc.func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.blit(this.x, this.y, txPoint.x, txPoint.y, this.width, this.height);
            GuiFunctions.exitDrawTextureStateWithBlend();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                float step = 0.01f;
                if (this.operation == Operation.SUBTRACT) {
                    ((GuiColorizer)this.parent).slider[this.segment.ordinal()] = MathHelper.func_76131_a((float)(this.parent.slider[this.segment.ordinal()] - step), (float)0.0f, (float)1.0f);
                } else if (this.operation == Operation.ADD) {
                    ((GuiColorizer)this.parent).slider[this.segment.ordinal()] = MathHelper.func_76131_a((float)(this.parent.slider[this.segment.ordinal()] + step), (float)0.0f, (float)1.0f);
                } else {
                    double mx = mouseX - (double)this.x;
                    double diff = mx - (double)((int)mx);
                    diff = diff < (double)0.4f ? 0.0 : (diff > (double)0.6f ? 1.0 : 0.5);
                    ((GuiColorizer)this.parent).slider[this.segment.ordinal()] = MathHelper.func_76131_a((float)((float)(((double)((int)mx) + diff) * 2.0) / 100.0f), (float)0.0f, (float)1.0f);
                }
                return true;
            }
            return false;
        }

        static enum Segment {
            RED,
            GREEN,
            BLUE;

        }

        static enum Operation {
            ADD(new Point(30, 230), new Point(40, 230), new Point(50, 230)),
            SUBTRACT(new Point(0, 230), new Point(10, 230), new Point(20, 230)),
            SELECT(null, null, null);

            private final Point normal;
            private final Point hover;
            private final Point pressed;

            private Operation(Point normal, Point hover, Point pressed) {
                this.normal = normal;
                this.hover = hover;
                this.pressed = pressed;
            }
        }
    }

    private static class ButtonMode
    extends ButtonIcon {
        private final GuiColorizer parent;
        private final Mode mode;
        private final Point normal = new Point(0, 240);
        private final Point hover = new Point(32, 240);
        private final Point pressed = new Point(64, 240);

        public ButtonMode(GuiColorizer parent, int posX, int posY, Mode mode) {
            super(posX, posY, 32, 10);
            this.parent = parent;
            this.mode = mode;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (!this.visible) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = this.isHovered = this.active && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            Point txPoint = this.parent.mode == this.mode ? this.pressed : (this.isHovered ? this.hover : this.normal);
            GuiFunctions.enterDrawTextureStateWithBlend();
            mc.func_110434_K().func_110577_a(Textures.COLORIZER.get());
            this.blit(this.x, this.y, txPoint.x, txPoint.y, this.width, this.height);
            GuiFunctions.exitDrawTextureStateWithBlend();
            String displayString = this.mode.toString().toUpperCase();
            if (!Strings.isNullOrEmpty((String)displayString)) {
                FontRenderer fontRenderer = mc.field_71466_p;
                float left = (float)this.x + (float)this.width / 2.0f - (float)fontRenderer.func_78256_a(displayString) / 2.0f;
                float top = (float)this.y + (float)(this.height - 8) / 2.0f;
                fontRenderer.func_211126_b(displayString, left + 0.5f, top + 0.6f, 0x1A1A1A);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clicked(mouseX, mouseY)) {
                if (this.parent.mode != this.mode) {
                    this.parent.mode = this.mode;
                    switch (this.mode) {
                        case RGB: {
                            this.parent.setSliders(ColorHelper.colorToRGB((int)this.parent.resultColor));
                            break;
                        }
                        case HSL: {
                            this.parent.setSliders(ColorHelper.colorToHSL((int)this.parent.resultColor));
                            break;
                        }
                        case HSV: {
                            this.parent.setSliders(ColorHelper.colorToHSV((int)this.parent.resultColor));
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static enum Mode {
        RGB,
        HSL,
        HSV;

    }
}

