/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.core.client.gui.GuiSidedContainer;
import shetiphian.core.common.inventory.SidedContainer;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.common.inventory.ContainerCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;

@OnlyIn(value=Dist.CLIENT)
public class GuiCraftFurnace
extends GuiSidedContainer<ContainerCraftFurnace> {
    private final boolean isCloud;

    public GuiCraftFurnace(ContainerCraftFurnace screenContainer, PlayerInventory inv, ITextComponent title) {
        super((SidedContainer)screenContainer, true, inv, title);
        String[] stringArray;
        this.isCloud = ((TileEntityCraftFurnace)((ContainerCraftFurnace)this.func_212873_a_()).getTile()).isCloud;
        this.field_146999_f = 182;
        int n = this.field_147000_g = this.isCloud ? 172 : 196;
        if (this.isCloud) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "gui.craftfurnace.cloud.basic.txt";
            stringArray2[1] = "gui.craftfurnace.items.txt";
            stringArray = stringArray2;
            stringArray2[2] = "gui.craftfurnace.cloud.output.txt";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "gui.craftfurnace.basic.txt";
            stringArray3[1] = "gui.craftfurnace.items.txt";
            stringArray3[2] = "gui.craftfurnace.fuel.txt";
            stringArray3[3] = "gui.craftfurnace.inputs.txt";
            stringArray = stringArray3;
            stringArray3[4] = "gui.craftfurnace.output.txt";
        }
        this.invNames = stringArray;
    }

    protected List<String> getInfoBoxText() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.isCloud) {
            lines.add("\u00a79I:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.items.info"));
            lines.add(null);
            lines.add("\u00a76II:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.output.info"));
            lines.add(null);
            lines.add("\u00a7aIII:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.process.info"));
        } else {
            lines.add("\u00a71I:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.fuel.info"));
            lines.add(null);
            lines.add("\u00a79II:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.items.info"));
            lines.add(null);
            lines.add("\u00a76III:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.output.info"));
            lines.add(null);
            lines.add("\u00a7aIV:\u00a7r " + Localization.get((String)"gui.craftfurnace.slot.process.info"));
        }
        return lines;
    }

    public void initSidedContainer() {
    }

    private void drawCommon() {
        if (this.isCloud) {
            this.blit(this.field_147003_i, this.field_147009_r, 0, 84, 182, 74);
        } else {
            this.blit(this.field_147003_i, this.field_147009_r, 0, 60, 182, 98);
        }
    }

    private void bindTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.isCloud ? Textures.CLOUD_CRAFTFURNACE.get() : Textures.CRAFTFURNACE.get());
    }

    protected void drawNormal(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        if (this.isCloud) {
            this.blit(this.field_147003_i, this.field_147009_r + 74, 0, 158, 182, 98);
        } else {
            this.blit(this.field_147003_i, this.field_147009_r + 98, 0, 158, 182, 98);
        }
        int offset = this.isCloud ? 0 : 24;
        TileEntityCraftFurnace furnace = (TileEntityCraftFurnace)((ContainerCraftFurnace)this.func_212873_a_()).getTile();
        int progress = furnace.getCookProgressScaled(0, 19);
        this.blit(this.field_147003_i + 82, this.field_147009_r + 34 + offset - progress, 238, 256 - progress, 18, progress);
        progress = furnace.getCookProgressScaled(1, 19);
        this.blit(this.field_147003_i + 82, this.field_147009_r + 58 + offset - progress, 238, 256 - progress, 18, progress);
        if (!this.isCloud) {
            progress = furnace.getFuelProgressScaled(54);
            this.blit(this.field_147003_i + 64, this.field_147009_r + 10, 184, 238, progress, 18);
        }
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    private void drawGuide(boolean info) {
        if (this.isCloud) {
            GuiCraftFurnace.fill((int)(this.field_147003_i + 22), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 58), (int)(this.field_147009_r + 64), (int)-2141891073);
            GuiCraftFurnace.fill((int)(this.field_147003_i + 124), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 160), (int)(this.field_147009_r + 64), (int)-2130728448);
            if (info) {
                GuiCraftFurnace.fill((int)(this.field_147003_i + 82), (int)(this.field_147009_r + 16), (int)(this.field_147003_i + 100), (int)(this.field_147009_r + 58), (int)-2141847723);
            }
        } else {
            GuiCraftFurnace.fill((int)(this.field_147003_i + 64), (int)(this.field_147009_r + 10), (int)(this.field_147003_i + 118), (int)(this.field_147009_r + 28), (int)-2147483478);
            GuiCraftFurnace.fill((int)(this.field_147003_i + 22), (int)(this.field_147009_r + 34), (int)(this.field_147003_i + 58), (int)(this.field_147009_r + 88), (int)-2141891073);
            GuiCraftFurnace.fill((int)(this.field_147003_i + 124), (int)(this.field_147009_r + 34), (int)(this.field_147003_i + 160), (int)(this.field_147009_r + 88), (int)-2130728448);
            if (info) {
                GuiCraftFurnace.fill((int)(this.field_147003_i + 82), (int)(this.field_147009_r + 40), (int)(this.field_147003_i + 100), (int)(this.field_147009_r + 82), (int)-2141847723);
            }
        }
    }

    private void drawGuideText(boolean info) {
        if (this.isCloud) {
            this.drawCenteredString(this.font, "I", this.field_147003_i + 40, this.field_147009_r + 33, -1);
            this.drawCenteredString(this.font, "II", this.field_147003_i + 142, this.field_147009_r + 33, -1);
            if (info) {
                this.drawCenteredString(this.font, "III", this.field_147003_i + 91, this.field_147009_r + 33, -1);
            }
        } else {
            this.drawCenteredString(this.font, "I", this.field_147003_i + 91, this.field_147009_r + 15, -1);
            this.drawCenteredString(this.font, "II", this.field_147003_i + 40, this.field_147009_r + 57, -1);
            this.drawCenteredString(this.font, "III", this.field_147003_i + 142, this.field_147009_r + 57, -1);
            if (info) {
                this.drawCenteredString(this.font, "IV", this.field_147003_i + 91, this.field_147009_r + 57, -1);
            }
        }
    }

    protected void drawInfo(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        this.drawGuide(true);
        GuiFunctions.exitDrawTextureStateWithBlend();
        if (this.infoBox != null) {
            this.infoBox.render(mouseX, mouseY, partialTicks);
        }
        this.drawGuideText(true);
    }

    protected void drawConfig(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.drawCommon();
        this.drawGuide(false);
        GuiFunctions.exitDrawTextureStateWithBlend();
        this.drawGuideText(false);
    }

    protected void renderFaceButton(Widget button, Direction face, int mouseX, int mouseY, float partialTicks) {
        byte index = this.indexSide[face.func_176745_a()];
        if (this.isCloud) {
            if (index == 0) {
                GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-22016);
                GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth() / 2), (int)(button.y + button.getHeight()), (int)-11184641);
            } else {
                int color = index == 1 ? -11184641 : (index == 2 ? -22016 : Integer.MIN_VALUE);
                GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)color);
            }
        } else if (index == 0) {
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-22016);
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth() / 2), (int)(button.y + button.getHeight()), (int)-11184641);
            GuiCraftFurnace.fill((int)button.x, (int)(button.y + button.getHeight() / 2), (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-16777046);
        } else if (index == 3) {
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-16777046);
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth() / 2), (int)(button.y + button.getHeight()), (int)-11184641);
        } else if (index == 4) {
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-22016);
            GuiCraftFurnace.fill((int)(button.x + button.getWidth() / 2), (int)(button.y + button.getWidth() / 2), (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)-16777046);
        } else {
            int color = index == 1 ? -11184641 : (index == 2 ? -16777046 : Integer.MIN_VALUE);
            GuiCraftFurnace.fill((int)button.x, (int)button.y, (int)(button.x + button.getWidth()), (int)(button.y + button.getHeight()), (int)color);
        }
    }
}

