/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.gui.Textures;
import shetiphian.terraqueous.client.render.RenderEnderTable;
import shetiphian.terraqueous.common.inventory.ContainerEnderTable;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnderTable
extends ContainerScreen<ContainerEnderTable> {
    private static final ItemStack STACK_ENDER_DUST = new ItemStack((IItemProvider)Values.itemEnderDust);
    public static final Tag<Item> TAG_MONOCLE = new ItemTags.Wrapper(new ResourceLocation("terraqueous", "status/ender_sight"));
    private final Random random = new Random();
    public int ticks;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookRotation;
    public float bookRotationPrev;
    ItemStack enchantStack;

    public GuiEnderTable(ContainerEnderTable screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.field_146999_f = 182;
        this.field_147000_g = 171;
        this.enchantStack = ItemStack.field_190927_a;
    }

    public void tick() {
        super.tick();
        ItemStack stack = ((ContainerEnderTable)this.field_147002_h).func_75139_a(0).func_75211_c();
        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.enchantStack)) {
            this.enchantStack = stack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.pageFlip <= this.flipT + 1.0f && this.pageFlip >= this.flipT - 1.0f);
        }
        ++this.ticks;
        this.pageFlipPrev = this.pageFlip;
        this.bookRotationPrev = this.bookRotation;
        boolean flag = false;
        for (int index = 0; index < 3; ++index) {
            if (((ContainerEnderTable)this.field_147002_h).experienceCost[index] == 0) continue;
            flag = true;
            break;
        }
        this.bookRotation = flag ? (this.bookRotation += 0.2f) : (this.bookRotation -= 0.2f);
        this.bookRotation = MathHelper.func_76131_a((float)this.bookRotation, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.pageFlip) * 0.4f;
        float f = 0.2f;
        f1 = MathHelper.func_76131_a((float)f1, (float)(-f), (float)f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        Minecraft minecraft = Minecraft.func_71410_x();
        for (int index = 0; index < 3; ++index) {
            if (!this.isMouseOverButton(index, mouseX, mouseY) || !((ContainerEnderTable)this.field_147002_h).func_75140_a((PlayerEntity)minecraft.field_71439_g, index)) continue;
            minecraft.field_71442_b.func_78756_a(((ContainerEnderTable)this.field_147002_h).field_75152_c, index);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void setTexture() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.ENDERTABLE.get());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int winX = (this.width - this.field_146999_f) / 2;
        int winY = (this.height - this.field_147000_g) / 2;
        GuiFunctions.enterDrawTextureStateWithBlend();
        GlStateManager.disableLighting();
        this.setTexture();
        this.blit(winX, winY, 0, 85, 182, 73);
        this.blit(winX, winY + 73, 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
        GlStateManager.pushMatrix();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        int scaleFactor = (int)this.getMinecraft().field_195558_d.func_198100_s();
        GlStateManager.viewport((int)((this.width - 320) / 2 * scaleFactor), (int)((this.height - 240) / 2 * scaleFactor), (int)(320 * scaleFactor), (int)(240 * scaleFactor));
        GlStateManager.translatef((float)-0.34f, (float)0.23f, (float)0.0f);
        GlStateManager.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        float f1 = 1.0f;
        GlStateManager.matrixMode((int)5888);
        GlStateManager.loadIdentity();
        RenderHelper.func_74519_b();
        GlStateManager.translatef((float)-0.2f, (float)4.3f, (float)-16.0f);
        GlStateManager.scalef((float)f1, (float)f1, (float)f1);
        float f2 = 5.0f;
        GlStateManager.scalef((float)f2, (float)f2, (float)f2);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderEnderTable.textureBook);
        GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float f3 = this.bookRotationPrev + (this.bookRotation - this.bookRotationPrev) * partialTicks;
        GlStateManager.translatef((float)((1.0f - f3) * 0.2f), (float)((1.0f - f3) * 0.1f), (float)((1.0f - f3) * 0.25f));
        GlStateManager.rotatef((float)(-(1.0f - f3) * 90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float f4 = this.pageFlipPrev + (this.pageFlip - this.pageFlipPrev) * partialTicks + 0.25f;
        float f5 = this.pageFlipPrev + (this.pageFlip - this.pageFlipPrev) * partialTicks + 0.75f;
        f4 = MathHelper.func_76131_a((float)((f4 - (float)MathHelper.func_76140_b((double)f4)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        f5 = MathHelper.func_76131_a((float)((f5 - (float)MathHelper.func_76140_b((double)f5)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        RenderEnderTable.modelBook.func_217103_a(0.0f, f4, f5, f3, 0.0f, 0.0625f);
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.viewport((int)0, (int)0, (int)minecraft.field_195558_d.func_198109_k(), (int)minecraft.field_195558_d.func_198091_l());
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EnchantmentNameParts.func_178176_a().func_148335_a((long)((ContainerEnderTable)this.field_147002_h).func_217005_f());
        for (int index = 0; index < 3; ++index) {
            GuiFunctions.enterDrawTextureState();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int bX = winX + 66;
            int bY = winY + 8;
            this.blitOffset = 0;
            this.setTexture();
            int expCost = ((ContainerEnderTable)this.field_147002_h).experienceCost[index];
            int matCost = ((ContainerEnderTable)this.field_147002_h).materialCost[index];
            if (expCost == 0) {
                this.blit(bX, bY + 19 * index, 0, 19, 108, 19);
            } else {
                int[] color = new int[]{6839882, 8453920, 8453920};
                boolean hasExp = minecraft.field_71439_g.field_71068_ca >= expCost;
                boolean hasMat = ((ContainerEnderTable)this.field_147002_h).hasMaterialNeeded(index);
                if (!(hasMat && hasExp || minecraft.field_71439_g.field_71075_bZ.field_75098_d)) {
                    this.blit(bX, bY + 19 * index, 0, 19, 108, 19);
                    this.blit(bX + 90, bY + 1 + 19 * index, 16, 57, 16, 16);
                    color[0] = (color[0] & 0xFEFEFE) >> 1;
                    color[1] = hasExp ? 4226832 : 9199709;
                    color[2] = hasMat ? 4226832 : 9199709;
                } else {
                    if (this.isMouseOverButton(index, mouseX, mouseY)) {
                        this.blit(bX, bY + 19 * index, 0, 38, 108, 19);
                        color[0] = 0xFFFF80;
                    } else {
                        this.blit(bX, bY + 19 * index, 0, 0, 108, 19);
                    }
                    this.blit(bX + 90, bY + 19 * index, 0, 57, 16, 16);
                }
                this.renderMaterial(bX + 74, bY + 1 + 19 * index);
                FontRenderer fontrenderer = minecraft.func_211500_ak().func_211504_a(Minecraft.field_71464_q);
                if (fontrenderer != null) {
                    int width = 72 - fontrenderer.func_78256_a("" + (expCost + matCost)) / 2;
                    String text = EnchantmentNameParts.func_178176_a().func_148334_a(fontrenderer, width);
                    fontrenderer.func_78279_b(text, bX + 2, bY + 2 + 19 * index, width, color[0]);
                    fontrenderer = minecraft.field_71466_p;
                    fontrenderer.func_175063_a("" + expCost, (float)(bX + 106 - fontrenderer.func_78256_a("" + expCost)), (float)(bY + 10 + 19 * index), color[1]);
                    if (matCost > 0) {
                        fontrenderer.func_175063_a("" + matCost, (float)(bX + 90 - fontrenderer.func_78256_a("" + matCost)), (float)(bY + 10 + 19 * index), color[2]);
                    }
                }
            }
            GuiFunctions.exitDrawTextureState();
        }
    }

    private void renderMaterial(int x, int y) {
        ItemStack stack = ((ContainerEnderTable)this.field_147002_h).enchantIds[0] > -1 || ((ContainerEnderTable)this.field_147002_h).enchantIds[1] > -1 || ((ContainerEnderTable)this.field_147002_h).enchantIds[2] > -1 ? STACK_ENDER_DUST : ((ContainerEnderTable)this.field_147002_h).func_75139_a(1).func_75211_c();
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            GuiFunctions.enterRenderItemState();
            this.itemRenderer.func_175042_a(stack, x, y);
            GuiFunctions.exitRenderItemState();
        }
    }

    private boolean isMouseOverButton(int index, double mouseX, double mouseY) {
        return this.func_195359_a(66, 9 + 19 * index, 107, 17, mouseX, mouseY);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        for (int index = 0; index < 3; ++index) {
            int expCost;
            if (!this.isMouseOverButton(index, mouseX, mouseY) || (expCost = ((ContainerEnderTable)this.field_147002_h).experienceCost[index]) < 1) continue;
            int enchantId = ((ContainerEnderTable)this.field_147002_h).enchantIds[index];
            ArrayList list = Lists.newArrayList();
            if (enchantId >= 0) {
                if (this.canReadEnchants()) {
                    List<EnchantmentData> enchants = ((ContainerEnderTable)this.field_147002_h).getEnchantments(index, expCost);
                    for (EnchantmentData enchant : enchants) {
                        String s = enchant.field_76302_b.func_200305_d(enchant.field_76303_c).getString();
                        list.add(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + s);
                    }
                } else {
                    Enchantment enchantment = Enchantment.func_185262_c((int)enchantId);
                    int l = ((ContainerEnderTable)this.field_147002_h).worldClue[index];
                    String key = "container.enchant.clue";
                    list.add("" + TextFormatting.WHITE + TextFormatting.ITALIC + I18n.func_135052_a((String)key, (Object[])new Object[]{enchantment == null ? "" : enchantment.func_200305_d(l).func_150254_d()}));
                    if (enchantment == null) {
                        Collections.addAll(list, "", TextFormatting.RED + I18n.func_135052_a((String)"forge.container.enchant.limitedEnchantability", (Object[])new Object[0]));
                    }
                }
            } else {
                String s = Localization.get((String)((ContainerEnderTable)this.field_147002_h).tooltips[index]);
                if (!this.canReadEnchants()) {
                    s = TextFormatting.OBFUSCATED.toString() + s.replace(" ", "");
                }
                list.add(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + s);
            }
            this.renderTooltip(list, mouseX, mouseY);
            break;
        }
        this.func_191948_b(mouseX, mouseY);
    }

    private boolean canReadEnchants() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack headItem = player.func_184582_a(EquipmentSlotType.HEAD);
        return !headItem.func_190926_b() && TAG_MONOCLE.func_199685_a_((Object)headItem.func_77973_b());
    }
}

