/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.GuiFunctions;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.misc.StormForgeHelper;

@OnlyIn(value=Dist.CLIENT)
public class GuiStormScroll
extends Screen {
    private static final ResourceLocation texture = new ResourceLocation("terraqueous", "textures/gui/stormscroll.png");

    public GuiStormScroll() {
        super((ITextComponent)new StringTextComponent(""));
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int winX = this.width / 2;
        int winY = this.height / 2;
        this.drawBackground(winX - 173, winY - 87);
        this.drawBlocks(winX, winY);
        this.drawForeground(winX - 173, winY - 87);
    }

    private void drawBackground(int x, int y) {
        GuiFunctions.enterDrawTextureState();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.blit(x, y, 0, 89, 30, 167);
        this.blit(x + 30, y, 0, 0, 143, 10);
        this.blit(x + 173, y, 0, 10, 143, 10);
        this.drawTextureMirrored(x + 316, y, 0, 89, 30, 167);
        this.blit(x + 30, y + 10, 0, 20, 143, 65);
        this.blit(x + 30, y + 75, 0, 20, 143, 65);
        this.blit(x + 173, y + 10, 0, 20, 143, 65);
        this.blit(x + 173, y + 75, 0, 20, 143, 65);
        this.drawTextureInverted(x + 30, y + 140, 0, 10, 143, 10);
        this.drawTextureInverted(x + 173, y + 140, 0, 0, 143, 10);
        this.blit(x + 30, y + 12, 144, 80, 112, 24);
        this.blit(x + 34, y + 40, 176, 104, 80, 88);
        this.blit(x + 266, y + 8, 144, 0, 48, 48);
        this.blit(x + 236, y + 126, 64, 88, 80, 16);
        GuiFunctions.exitDrawTextureState();
    }

    private void drawForeground(int x, int y) {
        GuiFunctions.enterDrawTextureState();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.blit(x + 116, y + 48, 144, 48, 48, 16);
        this.blit(x + 184, y + 18, 192, 0, 64, 80);
        GuiFunctions.exitDrawTextureState();
    }

    private void drawBlocks(int x, int y) {
        this.itemRenderer.field_77023_b = 0.0f;
        GuiFunctions.enterRenderItemState();
        this.drawBaseAt(x - 48, y - 24);
        this.drawPillarAt(x - 48, y - 55);
        this.drawBlock(new ItemStack((IItemProvider)Values.blockCloudCraftFurnace), x + 16, y - 58);
        GuiFunctions.exitRenderItemState();
        this.itemRenderer.field_77023_b = 0.0f;
    }

    private void drawBaseAt(int x, int y) {
        this.drawRowAt(x + 64, y + 0, 0, 0);
        this.drawRowAt(x + 56, y + 4, 0, 9, 1);
        this.drawRowAt(x + 48, y + 8, 0, 18, 10, 2);
        this.drawRowAt(x + 40, y + 12, 0, 27, 19, 11, 3);
        this.drawRowAt(x + 32, y + 16, 0, 36, 28, 20, 12, 4);
        this.drawRowAt(x + 24, y + 20, 0, 45, 37, 29, 21, 13, 5);
        this.drawRowAt(x + 16, y + 24, 0, 54, 46, 38, 30, 22, 14, 6);
        this.drawRowAt(x + 8, y + 28, 0, 63, 55, 47, 39, 31, 23, 15, 7);
        this.drawRowAt(x + 0, y + 32, 0, 72, 64, 56, 48, 40, 32, 24, 16, 8);
        this.drawRowAt(x + 8, y + 36, 0, 73, 65, 57, 49, 41, 33, 25, 17);
        this.drawRowAt(x + 16, y + 40, 0, 74, 66, 58, 50, 42, 34, 26);
        this.drawRowAt(x + 24, y + 44, 0, 75, 67, 59, 51, 43, 35);
        this.drawRowAt(x + 32, y + 48, 0, 76, 68, 60, 52, 44);
        this.drawRowAt(x + 40, y + 52, 0, 77, 69, 61, 53);
        this.drawRowAt(x + 48, y + 56, 0, 78, 70, 62);
        this.drawRowAt(x + 56, y + 60, 0, 79, 71);
        this.drawRowAt(x + 64, y + 64, 0, 80);
    }

    private void drawPillarAt(int x, int y) {
        for (int layer = 1; layer < 8; layer = (int)((byte)(layer + 1))) {
            int ypos = (7 - layer) * 9 + y;
            this.drawRowAt(x + 8, ypos - 4, layer, 63);
            this.drawRowAt(x + 0, ypos + 0, layer, 72, 64);
            this.drawRowAt(x + 8, ypos + 4, layer, 73);
        }
    }

    private void drawRowAt(int x, int y, int layer, int ... numbers) {
        for (int index : numbers) {
            StormForgeHelper.SFBlock sfb = StormForgeHelper.getSFBlockByIndex(layer, index);
            if (sfb != null) {
                this.drawBlock(sfb.getSourceStack(), x, y);
            }
            x += 16;
        }
        this.itemRenderer.field_77023_b += 6.0f;
    }

    private void drawBlock(ItemStack stack, int x, int y) {
        if (stack != null) {
            this.itemRenderer.func_175042_a(stack, x, y);
        }
    }

    private void drawTextureMirrored(int x, int y, int u, int v, int sx, int sy) {
        GuiFunctions.drawTextureMirrored((int)x, (int)y, (int)u, (int)v, (int)sx, (int)sy, (float)this.blitOffset, (int[])new int[0]);
    }

    private void drawTextureInverted(int x, int y, int u, int v, int sx, int sy) {
        GuiFunctions.drawTextureInverted((int)x, (int)y, (int)u, (int)v, (int)sx, (int)sy, (float)this.blitOffset, (int[])new int[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

