/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.misc;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.terraqueous.api.plant.PlantAPI;

@OnlyIn(value=Dist.CLIENT)
public class FoliageColor {
    private static final FoliageColor INSTANCE = new FoliageColor();
    public static int[][] colorBuffer = new int[4][65536];

    public static int getRenderColor(EnumFoliage foliage) {
        return INSTANCE.getBiomeFoliageColor(0.5, 1.0, foliage);
    }

    public static int getBiomeColor(IEnviromentBlockReader world, BlockPos pos, EnumFoliage foliage) {
        return INSTANCE.getBiomeFoliageColor(world, pos, foliage);
    }

    private int getBiomeFoliageColor(IEnviromentBlockReader world, BlockPos pos, EnumFoliage foliage) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int sZ = -1; sZ <= 1; ++sZ) {
            for (int sX = -1; sX <= 1; ++sX) {
                BlockPos sPos = pos.func_177982_a(sX, 0, sZ);
                int color = this.getBiomeFoliageColor(world.func_180494_b(sPos), sPos, foliage);
                red += (color & 0xFF0000) >> 16;
                green += (color & 0xFF00) >> 8;
                blue += color & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
    }

    private int getBiomeFoliageColor(Biome biome, BlockPos pos, EnumFoliage foliage) {
        double temperature = MathHelper.func_76131_a((float)biome.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double rainfall = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return this.getBiomeFoliageColor(temperature, rainfall, foliage);
    }

    private int getBiomeFoliageColor(double temperature, double rainfall, EnumFoliage foliage) {
        if (foliage == null) {
            return 0xFFFFFF;
        }
        int colorPoint = this.getFoliagePoint(temperature, rainfall, foliage.useAlt());
        return colorBuffer[foliage.getBufferIndex()][colorPoint];
    }

    private int getFoliagePoint(double temperature, double rainfall, boolean useAlt) {
        int valueT = (int)((1.0 - temperature) * 252.0);
        int valueR = (int)((1.0 - (rainfall *= temperature)) * 252.0);
        if (useAlt) {
            return valueT << 8 | ++valueR;
        }
        return valueR << 8 | (valueT += 256);
    }

    public static enum EnumFoliage {
        LIGHT(0, false),
        VIBRANT(0, true),
        DARK(1, false),
        MEDIUM(1, true),
        PLUM(2, false),
        CHERRY(2, true),
        LIFE(3, false),
        DEATH(3, true);

        private final int bufferIndex;
        private final boolean useAlt;

        private EnumFoliage(int bufferIndex, boolean useAlt) {
            this.bufferIndex = bufferIndex;
            this.useAlt = useAlt;
        }

        private int getBufferIndex() {
            return this.bufferIndex;
        }

        private boolean useAlt() {
            return this.useAlt;
        }

        public static EnumFoliage getFoliage(PlantAPI.TreeType type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case APPLE: {
                    return LIGHT;
                }
                case CHERRY: {
                    return CHERRY;
                }
                case ORANGE: {
                    return MEDIUM;
                }
                case PEAR: {
                    return MEDIUM;
                }
                case PEACH: {
                    return MEDIUM;
                }
                case MANGO: {
                    return DARK;
                }
                case LEMON: {
                    return VIBRANT;
                }
                case PLUM: {
                    return PLUM;
                }
                case COCONUT: {
                    return VIBRANT;
                }
                case BANANA: {
                    return LIGHT;
                }
                case MULBERRY: {
                    return LIGHT;
                }
            }
            return null;
        }

        public static EnumFoliage getFoliage(PlantAPI.PlantType type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case GRAPEVINE: {
                    return LIGHT;
                }
                case LIFEVINE: {
                    return LIFE;
                }
                case DEATHVINE: {
                    return DEATH;
                }
            }
            return null;
        }
    }
}

