/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

@OnlyIn(value=Dist.CLIENT)
public class RenderFlowerPot
extends TileEntityRenderer<TileEntityFlowerPot> {
    public void render(TileEntityFlowerPot tile, double x, double y, double z, float partialTicks, int destroyStage) {
        int facing;
        ItemStack plantstack = tile.getPlantStack();
        if (plantstack.func_190926_b()) {
            return;
        }
        TileEntityFlowerPot.RenderStyle style = tile.getRenderStyle();
        if (style == TileEntityFlowerPot.RenderStyle.NONE) {
            return;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(plantstack);
        if (model == null) {
            return;
        }
        Block block = tile.func_195044_w().func_177230_c();
        if (style == TileEntityFlowerPot.RenderStyle.DEFAULT) {
            TileEntityFlowerPot.RenderStyle renderStyle = model.func_177556_c() ? TileEntityFlowerPot.RenderStyle.BLOCK : (style = ItemTags.field_200037_g.func_199685_a_((Object)plantstack.func_77973_b()) ? TileEntityFlowerPot.RenderStyle.CROSS_SINGLE : TileEntityFlowerPot.RenderStyle.CROSS_MULTI);
        }
        float rotation = (facing = tile.getPlantFacing().func_176736_b()) == 0 ? 180.0f : (facing == 2 ? 0.0f : (float)facing * 90.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        switch (style) {
            case CROSS_MULTI: {
                if (block == Values.blockLargeFlowerPot) {
                    GlStateManager.translated((double)(x + 0.25), (double)(y + (double)0.74f), (double)(z + 0.25));
                    ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                    this.renderCross(renderer, plantstack, 0.16f, 0.02f);
                    this.renderCross(renderer, plantstack, 0.44f, 0.09f);
                    this.renderCross(renderer, plantstack, 0.45f, 0.39f);
                    this.renderCross(renderer, plantstack, 0.18f, 0.48f);
                    this.renderCross(renderer, plantstack, 0.01f, 0.26f);
                    break;
                }
                if (block == Values.blockMediumFlowerPot) {
                    GlStateManager.translated((double)(x + 0.25), (double)(y + (double)0.62f), (double)(z + 0.25));
                    ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                    this.renderCross(renderer, plantstack, 0.25f, 0.11f);
                    this.renderCross(renderer, plantstack, 0.37f, 0.32f);
                    this.renderCross(renderer, plantstack, 0.13f, 0.32f);
                    break;
                }
            }
            case CROSS_SINGLE: {
                if (block == Values.blockLargeFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.88f), (double)(z + 0.5));
                    GlStateManager.scalef((float)2.8f, (float)2.6f, (float)2.8f);
                } else if (block == Values.blockMediumFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.68f), (double)(z + 0.5));
                    GlStateManager.scalef((float)2.2f, (float)2.0f, (float)2.6f);
                } else {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.48f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.6f, (float)1.4f, (float)1.6f);
                }
                ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
                this.render(renderer, plantstack, 225.0f);
                this.render(renderer, plantstack, 135.0f);
                break;
            }
            case BLOCK: {
                if (block == Values.blockLargeFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.46f), (double)(z + 0.5));
                    GlStateManager.scalef((float)2.5f, (float)2.5f, (float)2.5f);
                } else if (block == Values.blockMediumFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.37f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.8f, (float)1.8f, (float)1.8f);
                } else {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.3f), (double)(z + 0.5));
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation);
                break;
            }
            case PANE: {
                if (block == Values.blockLargeFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.78f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.4f, (float)1.4f, (float)1.4f);
                } else if (block == Values.blockMediumFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.61f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.43f), (double)(z + 0.5));
                    GlStateManager.scalef((float)0.55f, (float)0.55f, (float)0.55f);
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation);
                break;
            }
            case TALL: {
                if (block == Values.blockLargeFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.3f), (double)(z + 0.5));
                    GlStateManager.scalef((float)2.5f, (float)5.0f, (float)2.5f);
                } else if (block == Values.blockMediumFlowerPot) {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.28f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.8f, (float)2.6f, (float)1.8f);
                } else {
                    GlStateManager.translated((double)(x + 0.5), (double)(y + (double)0.22f), (double)(z + 0.5));
                    GlStateManager.scalef((float)1.0f, (float)2.0f, (float)1.0f);
                }
                this.render(Minecraft.func_71410_x().func_175599_af(), plantstack, rotation);
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
    }

    private void render(ItemRenderer renderer, ItemStack plantstack, float rotation) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        renderer.func_181564_a(plantstack, ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.popMatrix();
    }

    private void renderCross(ItemRenderer renderer, ItemStack plantstack, float x, float z) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)0.0, (double)z);
        this.render(renderer, plantstack, 225.0f);
        this.render(renderer, plantstack, 135.0f);
        GlStateManager.popMatrix();
    }
}

