/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import shetiphian.core.client.ClientFunction;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.render.RenderCoconut;
import shetiphian.terraqueous.client.render.RenderEnderTable;
import shetiphian.terraqueous.client.render.RenderFlowerPot;
import shetiphian.terraqueous.client.render.RenderSign;
import shetiphian.terraqueous.client.render.RenderStormForge;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySign;

public class RenderRegistry {
    public static void setup() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnderTable.class, (TileEntityRenderer)new RenderEnderTable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySign.class, (TileEntityRenderer)new RenderSign());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlowerPot.class, (TileEntityRenderer)new RenderFlowerPot());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySFController.class, (TileEntityRenderer)new RenderStormForge());
        RenderingRegistry.registerEntityRenderingHandler(EntityCoconut.class, (IRenderFactory)RenderCoconut.INSTANCE);
        RenderRegistry.registerColorize();
    }

    private static void registerColorize() {
        ClientFunction.registerColorize((Block)Values.blockWaterVapor);
        ClientFunction.registerColorize((Block)Values.blockGlowVapor);
        ClientFunction.registerColorize((Block)Values.blockVaporLantern);
        ClientFunction.registerColorize((Block)Values.blockSmallFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockMediumFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockLargeFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockPlanter);
        ClientFunction.registerColorize((Block)Values.blockGardenWallWave);
        ClientFunction.registerColorize((Block)Values.blockGardenWallSpeed);
        ClientFunction.registerColorize((Block)Values.blockPicketFence);
        ClientFunction.registerColorize((Block)Values.blockDryingHay);
        ClientFunction.registerColorize((Block)Values.blockStormForge);
        ClientFunction.registerColorize((Block)Values.blockPergolaGate);
        ClientFunction.registerColorize((Block)Values.blockPergolaRoof);
        ClientFunction.registerColorize((Block)Values.blockPergolaWall);
        ClientFunction.registerColorize((Block)Values.blockPaper);
        ClientFunction.registerColorize((Block)Values.blockGlowPaper);
        ClientFunction.registerColorize((Block)Values.blockPaperLantern);
        ClientFunction.registerColorize((Block)Values.blockPlants.get((Object)PlantAPI.PlantType.GRASS));
        for (Block block : Values.blockPlants.values()) {
            ClientFunction.registerColorize((Block)block);
        }
        for (Block block : Values.blockLeaves.values()) {
            ClientFunction.registerColorize((Block)block);
        }
    }
}

