/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import shetiphian.terraqueous.Configuration;

public class BlockBurnium
extends Block {
    private static final VoxelShape COLLISION = VoxelShapes.func_197873_a((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
    private final boolean isOre;

    public BlockBurnium(boolean isOre) {
        super(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193562_N).func_200948_a(isOre ? 3.0f : 5.0f, 15.0f).func_200947_a(SoundType.field_185851_d).func_200951_a(isOre ? 8 : 10).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.isOre = isOre;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return COLLISION;
    }

    public boolean isBeaconBase(BlockState state, IWorldReader world, BlockPos pos, BlockPos beacon) {
        return !this.isOre;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        this.func_196262_a(world.func_180495_p(pos), world, pos, entity);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof LivingEntity && !entity.func_70045_F()) {
            entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
            entity.func_70015_d(this.isOre ? 2 : 4);
        }
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        return PathNodeType.DANGER_FIRE;
    }

    public BlockRenderLayer func_180664_k() {
        return this.isOre ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || this.isOre && layer == BlockRenderLayer.TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)Configuration.TWEAKS.burniumReactsToWater.get()).booleanValue() && rand.nextInt(10) == 0) {
            BlockBurnium.waterInteraction(world, pos, rand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void waterInteraction(World world, BlockPos pos, Random rand) {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            Fluid fluid = world.func_204610_c((BlockPos)(mPos = mPos.func_189533_g((Vec3i)pos.func_177972_a(direction)))).func_206886_c();
            if (fluid != Fluids.field_204546_a && fluid != Fluids.field_207212_b) continue;
            float x = (float)pos.func_177958_n() + 0.5f + (float)direction.func_82601_c() / 2.0f;
            float y = (float)pos.func_177956_o() + 0.5f + (float)direction.func_96559_d() / 2.0f;
            float z = (float)pos.func_177952_p() + 0.5f + (float)direction.func_82599_e() / 2.0f;
            world.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
            for (int l = 0; l < 8; ++l) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            break;
        }
    }
}

