/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ToolType;

public class BlockColumn
extends RotatedPillarBlock {
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"type", EnumType.class);

    public BlockColumn(MaterialColor color) {
        this(Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)color).func_200943_b(1.8f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    }

    protected BlockColumn(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)EnumType.MIDDLE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{VARIANT});
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.MIDDLE) {
            return super.func_185499_a(state, rotation);
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b((IProperty)field_176298_M)) {
                    case X: {
                        return (BlockState)((BlockState)state.func_206870_a((IProperty)field_176298_M, (Comparable)Direction.Axis.Z)).func_206870_a(VARIANT, (Comparable)((Object)(type == EnumType.LOWER ? EnumType.UPPER : EnumType.LOWER)));
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a((IProperty)field_176298_M, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b((IProperty)field_176298_M)) {
                    case X: {
                        return (BlockState)state.func_206870_a((IProperty)field_176298_M, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)((BlockState)state.func_206870_a((IProperty)field_176298_M, (Comparable)Direction.Axis.X)).func_206870_a(VARIANT, (Comparable)((Object)(type == EnumType.LOWER ? EnumType.UPPER : EnumType.LOWER)));
                    }
                }
                return state;
            }
            case CLOCKWISE_180: {
                return (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)(type == EnumType.LOWER ? EnumType.UPPER : EnumType.LOWER)));
            }
        }
        return state;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176298_M, (Comparable)face.func_176740_k());
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_70093_af()) {
            switch (face) {
                case DOWN: 
                case SOUTH: 
                case WEST: {
                    return (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.UPPER));
                }
                case UP: 
                case NORTH: 
                case EAST: {
                    return (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LOWER));
                }
            }
        }
        return state;
    }

    private static enum EnumType implements IStringSerializable
    {
        UPPER(0),
        MIDDLE(1),
        LOWER(2);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[3];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

