/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.common.inventory.ContainerProviders;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCrafting;

public class BlockCrafting
extends HorizontalBlock {
    private final Supplier<? extends TileEntity> tile;

    public BlockCrafting(Supplier<? extends TileEntity> tile) {
        this(tile, Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    }

    public BlockCrafting(Supplier<? extends TileEntity> tile, Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH));
        this.tile = tile;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D});
    }

    public boolean hasTileEntity(BlockState state) {
        return this.tile != null;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (this.tile != null) {
            return this.tile.get();
        }
        return null;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_70093_af()) {
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            TileEntity tile;
            if (this == Values.blockCloudWorkbench) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.CloudWorkbench(pos), (BlockPos)pos);
            }
            if ((tile = world.func_175625_s(pos)) == null) {
                return true;
            }
            if (tile instanceof TileEntityCloudFurnace) {
                ((TileEntityCloudFurnace)tile).dropExp();
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.CloudFurnace((TileEntityCloudFurnace)tile), (BlockPos)pos);
            }
            if (tile instanceof TileEntityCraftBench) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.CraftBench((TileEntityCraftBench)tile), (BlockPos)pos);
            }
            if (tile instanceof TileEntityCraftFurnace) {
                ((TileEntityCraftFurnace)tile).dropExp();
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.CraftFurnace((TileEntityCraftFurnace)tile), (BlockPos)pos);
            }
        }
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityCrafting) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                ((TileEntityCrafting)tile).addExtraDrops(drops);
                drops.forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public static class Cloud
    extends BlockCrafting
    implements ICloud {
        public Cloud(Supplier<? extends TileEntity> tile) {
            super(tile, Block.Properties.func_200945_a((Material)CloudAPI.materialCloud).func_200943_b(2.0f).func_200947_a(CloudAPI.soundTypeCloud).harvestTool(ToolType.SHOVEL).harvestLevel(1));
        }

        public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
            return super.func_220081_d(state, worldIn, pos);
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return CloudPresets.isFlammable();
        }

        public PushReaction func_149656_h(BlockState state) {
            return CloudPresets.getPushReaction();
        }

        public boolean isFoliage(BlockState state, IWorldReader world, BlockPos pos) {
            return CloudPresets.isFoliage();
        }

        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            if (context == ISelectionContext.func_216377_a() || CloudPresets.shouldCollide(state, world, pos, context.getEntity())) {
                return super.func_220071_b(state, world, pos, context);
            }
            return VoxelShapes.func_197880_a();
        }

        @Override
        public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (CloudPresets.shouldCollide(state, (IBlockReader)world, pos, (Entity)player)) {
                return super.func_220051_a(state, world, pos, player, hand, hit);
            }
            return false;
        }

        public void func_176199_a(World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityWalking(world, pos, entity);
        }

        public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
            CloudPresets.onEntityCollision(state, world, pos, entity);
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            CloudPresets.onFallenUpon(world, pos, entity, fallDistance);
        }

        @Override
        public boolean isCloudBlock(BlockState state, IBlockReader world, BlockPos pos) {
            return true;
        }

        @Override
        public boolean isCloudKickable(BlockState state, IBlockReader world, BlockPos pos) {
            return false;
        }
    }
}

