/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBase;
import shetiphian.terraqueous.common.item.ItemBlockLeaves;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockLeaves
extends BlockLeavesBase {
    public static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);

    public BlockLeaves(PlantAPI.TreeType treeType) {
        super(treeType);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{VARIANT});
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_177229_b(VARIANT) == EnumType.FRUIT) {
            Item fruit = Values.itemTreeFruit.get((Object)this.treeType);
            if (fruit != null) {
                if (player != null) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)fruit));
                } else {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)fruit));
                }
            }
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.NORMAL))), (boolean)true);
            return true;
        }
        return false;
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case NORMAL: {
                return this.airCheck(world, pos);
            }
            case FLOWER: {
                return true;
            }
            case FRUIT: {
                return false;
            }
        }
        return false;
    }

    private boolean airCheck(World world, BlockPos pos) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!world.func_175623_d(pos.func_177972_a(facing))) continue;
            return true;
        }
        return false;
    }

    public boolean canUseBonemeal(World world, Random rand, BlockPos pos, BlockState state) {
        return rand.nextFloat() < 0.45f && this.canGrow(world, pos, state, false);
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case NORMAL: {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FLOWER))), (boolean)true);
                break;
            }
            case FLOWER: {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FRUIT))), (boolean)true);
            }
        }
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        super.func_196265_a(state, world, pos, random);
        if (!world.func_175623_d(pos) && this.canGrow(world, pos, state, world.field_72995_K)) {
            switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
                case NORMAL: {
                    if (!PlantFunctions.growFruitFlower((IBlockReader)world, pos, this.treeType)) break;
                    this.grow(world, random, pos, state);
                    break;
                }
                case FLOWER: {
                    if (!PlantFunctions.growFruit((IBlockReader)world, pos, this.treeType)) break;
                    this.grow(world, random, pos, state);
                }
            }
        } else if (state.func_177229_b(VARIANT) == EnumType.FRUIT && PlantFunctions.dropFruit((IBlockReader)world, pos, this.treeType)) {
            Item fruit = Values.itemTreeFruit.get((Object)this.treeType);
            if (fruit != null) {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)fruit));
            }
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.NORMAL))), (boolean)true);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        ItemStack stack = context.func_195996_i();
        if (state != null && stack.func_77973_b() instanceof ItemBlockLeaves) {
            state = (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.byValue(ItemBlockLeaves.getType(stack))));
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemBlockLeaves.create(this.treeType, ((EnumType)((Object)state.func_177229_b(VARIANT))).getValue());
    }

    @Override
    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getValue() > 0 && layer == BlockRenderLayer.CUTOUT || super.canRenderInLayer(state, layer);
    }

    public static BlockState getAltVariant(BlockState state, boolean fruit) {
        if (state.func_177230_c() instanceof BlockLeaves) {
            state = (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)(fruit ? EnumType.FRUIT : EnumType.FLOWER)));
        }
        return state;
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0),
        FLOWER(1),
        FRUIT(2);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[3];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

