/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;

public abstract class BlockLeavesBase
extends LeavesBlock
implements IBonemealable,
IColored {
    protected final PlantAPI.TreeType treeType;

    public BlockLeavesBase(PlantAPI.TreeType treeType) {
        super(Block.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_185850_c));
        this.treeType = treeType;
    }

    public PlantAPI.TreeType getTreeType() {
        return this.treeType;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return field_196478_c ? layer == BlockRenderLayer.CUTOUT_MIPPED : layer == BlockRenderLayer.SOLID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.treeType));
            }
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.treeType));
        }
        return 0xFFFFFF;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return BlockLeavesBase.updateDistance((BlockState)this.func_176223_P().func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.TRUE), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        world.func_180501_a(pos, BlockLeavesBase.updateDistance(state, (IWorld)world, pos), 3);
    }

    private static BlockState updateDistance(BlockState state, IWorld world, BlockPos pos) {
        int i = 7;
        try (BlockPos.PooledMutableBlockPos mPos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction direction : Direction.values()) {
                mPos.func_189533_g((Vec3i)pos).func_189536_c(direction);
                i = Math.min(i, BlockLeavesBase.getDistance(world.func_180495_p((BlockPos)mPos)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (BlockTags.field_200031_h.func_199685_a_((Object)neighbor.func_177230_c())) {
            return 0;
        }
        return BlockTags.field_206952_E.func_199685_a_((Object)neighbor.func_177230_c()) && neighbor.func_196959_b((IProperty)field_208494_a) ? (Integer)neighbor.func_177229_b((IProperty)field_208494_a) : 7;
    }
}

