/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBase;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockLeavesCoconut
extends BlockLeavesBase {
    private static final ResourceLocation TAG_COCONUT_LOGS = new ResourceLocation("terraqueous:coconut_logs");

    public BlockLeavesCoconut(PlantAPI.TreeType treeType) {
        super(treeType);
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        if (!world.field_72995_K) {
            BlockPos down = pos.func_177977_b();
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(down);
            boolean[] s = new boolean[4];
            boolean[] c = new boolean[4];
            int sIndex = 0;
            int cIndex = 0;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    mPos.func_189533_g((Vec3i)down).func_196234_d(x, 0, z);
                    if (x == 0 || z == 0) {
                        s[sIndex] = world.func_180495_p((BlockPos)mPos).func_177230_c() == this;
                        ++sIndex;
                        continue;
                    }
                    c[cIndex] = world.func_180495_p((BlockPos)mPos).func_177230_c().getTags().contains(TAG_COCONUT_LOGS);
                    ++cIndex;
                }
            }
            if (c[0] && s[1] && s[0] || c[1] && s[0] && s[2] || c[3] && s[2] && s[3] || c[2] && s[3] && s[1]) {
                List list = world.func_217357_a(EntityCoconut.class, new AxisAlignedBB(pos.func_177982_a(-1, -2, -1), pos.func_177982_a(2, 1, 2)));
                return list.isEmpty();
            }
        }
        return false;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, BlockState state) {
        return random.nextFloat() < 0.45f;
    }

    public void grow(World world, Random random, BlockPos pos, BlockState state) {
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new EntityCoconut(world, pos, true));
        }
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        super.func_196265_a(state, world, pos, random);
        if (!world.func_175623_d(pos) && this.canGrow(world, pos, state, world.field_72995_K) && PlantFunctions.growFruit((IBlockReader)world, pos, PlantAPI.TreeType.COCONUT)) {
            this.grow(world, random, pos, state);
        }
    }
}

