/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.block.BlockPergolaGate;
import shetiphian.terraqueous.common.item.ItemBlockRGB;
import shetiphian.terraqueous.common.item.ItemBlockVine;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public abstract class BlockPergola
extends Block
implements IShearable,
IBonemealable,
IColored,
IRGB16_Block,
IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<EnumCover> COVERING = EnumProperty.func_177709_a((String)"covering", EnumCover.class);
    private static final Material MATERIAL = new Materials.Builder(MaterialColor.field_151667_k).isOpaque(false).isSolid(false).setPushReaction(PushReaction.IGNORE).build();

    public BlockPergola() {
        super(Block.Properties.func_200945_a((Material)MATERIAL).func_200948_a(2.0f, 10.0f).func_200944_c().func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(COVERING, (Comparable)((Object)EnumCover.NONE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{COVERING, WATERLOGGED});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRGB16(Values.tileRGB16, DyeColor.WHITE);
    }

    private TileEntityRGB16 getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        EnumCover covering = (EnumCover)((Object)state.func_177229_b(COVERING));
        if (covering != EnumCover.NONE) {
            covering.dropFruit(null, world, pos);
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)EnumCover.NONE))), (boolean)true);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem;
        EnumCover cover = (EnumCover)((Object)state.func_177229_b(COVERING));
        if (cover.hasFruit()) {
            cover.dropFruit(player, world, pos);
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)cover.getWithoutFruit()))), (boolean)true);
            return true;
        }
        if ((cover == EnumCover.NONE || player.field_71075_bZ.field_75098_d) && !(heldItem = player.func_184586_b(hand)).func_190926_b()) {
            EnumCover covering = EnumCover.NONE;
            if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                if (heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() == Blocks.field_203214_jx) {
                    covering = EnumCover.KELP;
                }
            } else if (heldItem.func_77973_b() instanceof ItemBlockVine) {
                boolean withFruit = ItemBlockVine.hasFruit(heldItem);
                switch (((ItemBlockVine)heldItem.func_77973_b()).getPlantType()) {
                    case GRAPEVINE: {
                        covering = withFruit ? EnumCover.GRAPEVINE_FRUIT : EnumCover.GRAPEVINE;
                        break;
                    }
                    case LIFEVINE: {
                        covering = withFruit ? EnumCover.LIFEVINE_FRUIT : EnumCover.LIFEVINE;
                        break;
                    }
                    case DEATHVINE: {
                        covering = withFruit ? EnumCover.DEATHVINE_FRUIT : EnumCover.DEATHVINE;
                    }
                }
            } else if (heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() == Blocks.field_150395_bd) {
                covering = EnumCover.VINE;
            }
            if (covering != EnumCover.NONE && covering != cover) {
                world.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 1.0f);
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)covering))), (boolean)true);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public float func_176195_g(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177229_b(COVERING) != EnumCover.NONE ? 0.2f : this.field_149782_v;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177229_b(COVERING) != EnumCover.NONE;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Block block = ((EnumCover)((Object)world.func_180495_p(pos).func_177229_b(COVERING))).getVine();
        if (block != null) {
            list.add(new ItemStack((IItemProvider)block));
        }
        return list;
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        if (!this.canGrow(world, pos, state, false)) {
            return;
        }
        this.grow(world, random, pos, state);
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, BlockState state) {
        return this.canGrow(world, pos, state, false) && random.nextFloat() < 0.45f;
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        boolean waterlogged = (Boolean)state.func_177229_b((IProperty)WATERLOGGED);
        EnumCover cover = (EnumCover)((Object)state.func_177229_b(COVERING));
        if (cover == EnumCover.NONE) {
            return waterlogged;
        }
        if (waterlogged && cover != EnumCover.KELP || !waterlogged && cover == EnumCover.KELP) {
            if (cover.hasFruit() && !isClient) {
                cover.dropFruit(null, world, pos);
            }
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)EnumCover.NONE))), (boolean)true);
            return false;
        }
        if (!cover.hasFruit() && !(this instanceof BlockPergolaGate)) {
            return true;
        }
        for (Direction facing : Direction.values()) {
            if (this.isBlockOvergrown(world, pos.func_177972_a(facing))) continue;
            return true;
        }
        return false;
    }

    private boolean isBlockOvergrown(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockPergola && state.func_177229_b(COVERING) != EnumCover.NONE;
    }

    public void grow(World world, Random random, BlockPos pos, BlockState state) {
        EnumCover cover = (EnumCover)((Object)state.func_177229_b(COVERING));
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            if (world.field_73012_v.nextInt(4) == 0) {
                if (cover == EnumCover.NONE) {
                    Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)EnumCover.KELP))), (boolean)true);
                } else if (cover == EnumCover.KELP) {
                    if (world.field_73012_v.nextBoolean() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j) {
                        Function.setBlock((IWorld)world, (BlockPos)pos.func_177984_a(), (BlockState)Blocks.field_203214_jx.func_176223_P(), (boolean)true);
                    } else {
                        this.doSpread(world, this.getSpread(world, pos), EnumCover.KELP);
                    }
                }
            }
        } else if (cover != EnumCover.NONE) {
            boolean canSpread;
            EnumCover newCover;
            PlantAPI.PlantType plantType = cover.getPlantType();
            if (!cover.hasFruit() && !(state.func_177230_c() instanceof BlockPergolaGate) && plantType != null && (newCover = cover.getWithFruit()) != cover && random.nextBoolean() && PlantFunctions.canGrowFruit(world, pos, plantType)) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)newCover))), (boolean)true);
                return;
            }
            boolean bl = plantType != null ? PlantFunctions.canSpread(world, pos, plantType) : (canSpread = world.field_73012_v.nextInt(4) == 0);
            if (canSpread) {
                this.doSpread(world, this.getSpread(world, pos), cover.getWithoutFruit());
            }
        }
    }

    private BlockPos getSpread(World world, BlockPos pos) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        list.add(Direction.UP);
        list.add(Direction.DOWN);
        list.add(Direction.NORTH);
        list.add(Direction.EAST);
        list.add(Direction.SOUTH);
        list.add(Direction.WEST);
        int attempts = list.size();
        for (int attempt = 0; attempt < attempts; attempt = (int)((byte)(attempt + 1))) {
            int index = Function.random.nextInt(attempts - attempt);
            Direction facing = (Direction)list.get(index);
            list.remove(index);
            BlockPos sPos = pos.func_177972_a(facing);
            BlockState state = world.func_180495_p(sPos);
            if (!(state.func_177230_c() instanceof BlockPergola) || this.isBlockOvergrown(world, sPos)) continue;
            return sPos;
        }
        return null;
    }

    private void doSpread(World world, BlockPos pos, EnumCover cover) {
        if (pos == null || cover == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockPergola) || state.func_177230_c() instanceof BlockPergolaGate && (cover.hasFruit() || !((BlockPergolaGate)state.func_177230_c()).shouldOvergrow(state, world, pos))) {
            return;
        }
        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(COVERING, (Comparable)((Object)cover))), (boolean)true);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityRGB16 tile = this.getTile((IBlockReader)world, pos);
        if (tile != null && stack.func_77973_b() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, Direction facing, DyeColor color) {
        return this.recolorBlock(state, world, pos, null, null, facing, null, color.func_176610_l());
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vec3d hitVec, String dyeName) {
        TileEntity tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = world.func_175625_s(pos)) instanceof TileEntityRGB16) {
            if (!world.func_201670_d()) {
                if (player == null) {
                    ((TileEntityRGB16)tile).getRGB16(null).setValues(dyeName);
                } else {
                    ((TileEntityRGB16)tile).getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (data.world != null && data.pos != null) {
            if (index == 0) {
                TileEntity tile = data.world.func_175625_s(data.pos);
                if (tile instanceof TileEntityRGB16) {
                    RGB16 rgb16 = ((TileEntityRGB16)tile).getRGB16(null);
                    return rgb16 != null ? rgb16.getColor() : 0xFFFFFF;
                }
            } else if (data.state != null && index == 6) {
                PlantAPI.PlantType plantType = ((EnumCover)((Object)data.state.func_177229_b(COVERING))).getPlantType();
                if (plantType != null) {
                    return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(plantType));
                }
                return BiomeColors.func_217615_b((IEnviromentBlockReader)data.world, (BlockPos)data.pos);
            }
        }
        return 0xFFFFFF;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        RGB16 rgb16;
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)rgb16);
        }
        return stack;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Block block;
        if (player != null && player.func_70093_af() && (block = ((EnumCover)((Object)state.func_177229_b(COVERING))).getVine()) != null) {
            return new ItemStack((IItemProvider)block);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static enum EnumStyle implements IStringSerializable
    {
        NONE,
        NORMAL,
        BOTTOM,
        MIDDLE,
        TOP;

        private static final Map<String, EnumStyle> map;

        public static EnumStyle byName(String name) {
            name = name.toLowerCase().trim();
            return map.getOrDefault(name, NONE);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumStyle>();
            for (EnumStyle value : EnumStyle.values()) {
                map.put(value.func_176610_l(), value);
            }
        }
    }

    static enum EnumCover implements IStringSerializable
    {
        NONE(null, false),
        VINE(null, false),
        KELP(null, false),
        GRAPEVINE(PlantAPI.PlantType.GRAPEVINE, false),
        GRAPEVINE_FRUIT(PlantAPI.PlantType.GRAPEVINE, true),
        LIFEVINE(PlantAPI.PlantType.LIFEVINE, false),
        LIFEVINE_FRUIT(PlantAPI.PlantType.LIFEVINE, true),
        DEATHVINE(PlantAPI.PlantType.DEATHVINE, false),
        DEATHVINE_FRUIT(PlantAPI.PlantType.DEATHVINE, true);

        private static final Map<String, EnumCover> map;
        private final PlantAPI.PlantType plant;
        private final boolean hasFruit;

        private EnumCover(PlantAPI.PlantType plant, boolean hasFruit) {
            this.plant = plant;
            this.hasFruit = hasFruit;
        }

        public PlantAPI.PlantType getPlantType() {
            return this.plant;
        }

        public boolean hasFruit() {
            return this.hasFruit;
        }

        public void dropFruit(PlayerEntity player, World world, BlockPos pos) {
            Item fruit;
            if (this.hasFruit && (fruit = Values.itemPlantFruit.get((Object)this.plant)) != null) {
                if (player != null) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)fruit));
                } else {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)fruit));
                }
            }
        }

        public EnumCover getWithFruit() {
            switch (this) {
                case GRAPEVINE: 
                case GRAPEVINE_FRUIT: {
                    return GRAPEVINE_FRUIT;
                }
                case LIFEVINE: 
                case LIFEVINE_FRUIT: {
                    return LIFEVINE_FRUIT;
                }
                case DEATHVINE: 
                case DEATHVINE_FRUIT: {
                    return DEATHVINE_FRUIT;
                }
            }
            return this;
        }

        public EnumCover getWithoutFruit() {
            switch (this) {
                case GRAPEVINE: 
                case GRAPEVINE_FRUIT: {
                    return GRAPEVINE;
                }
                case LIFEVINE: 
                case LIFEVINE_FRUIT: {
                    return LIFEVINE;
                }
                case DEATHVINE: 
                case DEATHVINE_FRUIT: {
                    return DEATHVINE;
                }
            }
            return this;
        }

        public Block getVine() {
            switch (this) {
                case VINE: {
                    return Blocks.field_150395_bd;
                }
                case KELP: {
                    return Blocks.field_203214_jx;
                }
            }
            return this.plant == null ? null : Values.blockPlants.get((Object)this.plant);
        }

        public static EnumCover byName(String name) {
            name = name.toLowerCase().trim();
            return map.getOrDefault(name, NONE);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumCover>();
            for (EnumCover value : EnumCover.values()) {
                map.put(value.func_176610_l(), value);
            }
        }
    }
}

