/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;

public class BlockPergolaGate
extends BlockPergola {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final BooleanProperty GATE_UP = BooleanProperty.func_177716_a((String)"gate_above");
    public static final BooleanProperty GATE_DOWN = BooleanProperty.func_177716_a((String)"gate_bellow");
    protected static final VoxelShape POSTS_NS = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)-0.1, (double)-0.1, (double)6.9, (double)1.1, (double)16.1, (double)9.1), (VoxelShape)Block.func_208617_a((double)14.9, (double)-0.1, (double)6.9, (double)16.1, (double)16.1, (double)9.1));
    protected static final VoxelShape POSTS_EW = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.9, (double)-0.1, (double)-0.1, (double)9.1, (double)16.1, (double)1.1), (VoxelShape)Block.func_208617_a((double)6.9, (double)-0.1, (double)14.9, (double)9.1, (double)16.1, (double)16.1));
    protected static final VoxelShape TOP_BAR_NS = Block.func_208617_a((double)0.9, (double)14.9, (double)6.9, (double)15.1, (double)16.1, (double)9.1);
    protected static final VoxelShape TOP_BAR_EW = Block.func_208617_a((double)6.9, (double)14.9, (double)0.9, (double)9.1, (double)16.1, (double)15.1);
    protected static final VoxelShape DOOR_NS = Block.func_208617_a((double)0.9, (double)2.9, (double)7.4, (double)15.1, (double)13.1, (double)8.6);
    protected static final VoxelShape DOOR_EW = Block.func_208617_a((double)7.4, (double)2.9, (double)0.9, (double)8.6, (double)13.1, (double)15.1);
    protected static final VoxelShape GATE_TOP_NS = VoxelShapes.func_197872_a((VoxelShape)POSTS_NS, (VoxelShape)TOP_BAR_NS);
    protected static final VoxelShape GATE_TOP_EW = VoxelShapes.func_197872_a((VoxelShape)POSTS_EW, (VoxelShape)TOP_BAR_EW);
    protected static final VoxelShape GATE_BOTTOM_NS = VoxelShapes.func_197872_a((VoxelShape)POSTS_NS, (VoxelShape)DOOR_NS);
    protected static final VoxelShape GATE_BOTTOM_EW = VoxelShapes.func_197872_a((VoxelShape)POSTS_EW, (VoxelShape)DOOR_EW);
    protected static final VoxelShape DOOR_COLLISION_NS = Block.func_208617_a((double)1.0, (double)3.0, (double)7.5, (double)15.0, (double)24.0, (double)8.5);
    protected static final VoxelShape DOOR_COLLISION_EW = Block.func_208617_a((double)7.5, (double)3.0, (double)1.0, (double)8.5, (double)24.0, (double)15.0);

    public BlockPergolaGate() {
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)COVERING, (Comparable)((Object)BlockPergola.EnumCover.NONE)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, OPEN, POWERED, GATE_UP, GATE_DOWN});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRGB16(Values.tileRGB16, DyeColor.WHITE);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((IProperty)GATE_DOWN)).booleanValue()) {
            return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.X ? GATE_BOTTOM_EW : GATE_BOTTOM_NS;
        }
        if (!((Boolean)state.func_177229_b((IProperty)GATE_UP)).booleanValue()) {
            return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.X ? GATE_TOP_EW : GATE_TOP_NS;
        }
        return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.X ? POSTS_EW : POSTS_NS;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((IProperty)GATE_DOWN)).booleanValue()) {
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.X ? POSTS_EW : POSTS_NS;
            }
            return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.X ? DOOR_COLLISION_EW : DOOR_COLLISION_NS;
        }
        return this.func_220053_a(state, world, pos, context);
    }

    @Override
    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (hit.func_216354_b().func_176740_k() == Direction.Axis.Y || ((Boolean)state.func_177229_b((IProperty)GATE_DOWN)).booleanValue() || player.func_70093_af()) && heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() instanceof VineBlock) {
            return super.func_220051_a(state, world, pos, player, hand, hit);
        }
        if (state.func_177229_b((IProperty)COVERING) != BlockPergola.EnumCover.NONE) {
            world.func_184133_a(null, pos, SoundEvents.field_187575_bT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)GATE_DOWN)).booleanValue()) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            state = (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
        } else {
            Direction direction = player.func_174811_aO();
            if (state.func_177229_b((IProperty)FACING) == direction.func_176734_d()) {
                state = (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)direction);
            }
            state = (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
        }
        world.func_180501_a(pos, state, 10);
        world.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? 1008 : 1014, pos, 0);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPergolaGate) {
            ((TileEntityPergolaGate)tile).setLastUsed();
        }
        return true;
    }

    public boolean shouldOvergrow(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPergolaGate) {
            long lastUsed = ((TileEntityPergolaGate)tile).getLastUsed();
            int[] delay = new int[]{36000, 12000};
            if (lastUsed > (long)delay[0]) {
                int chances = (int)((lastUsed - (long)delay[0]) / (long)delay[1]);
                for (int chance = 0; chance < chances; ++chance) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_195992_f();
        boolean gateUp = this.canConnect(world.func_180495_p(pos.func_177984_a()), direction);
        boolean gateDown = this.canConnect(world.func_180495_p(pos.func_177977_b()), direction);
        boolean powered = !gateDown && world.func_175640_z(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(powered))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a((IProperty)GATE_UP, (Comparable)Boolean.valueOf(gateUp))).func_206870_a((IProperty)GATE_DOWN, (Comparable)Boolean.valueOf(gateDown));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.field_72995_K) {
            boolean powered;
            boolean gateUp = this.canConnect(world.func_180495_p(pos.func_177984_a()), (Direction)state.func_177229_b((IProperty)FACING));
            boolean gateDown = this.canConnect(world.func_180495_p(pos.func_177977_b()), (Direction)state.func_177229_b((IProperty)FACING));
            boolean bl = powered = !gateDown && world.func_175640_z(pos);
            if (state.func_177229_b((IProperty)COVERING) != BlockPergola.EnumCover.NONE) {
                if ((Boolean)state.func_177229_b((IProperty)POWERED) != powered || (Boolean)state.func_177229_b((IProperty)GATE_UP) != gateUp || (Boolean)state.func_177229_b((IProperty)GATE_DOWN) != gateDown) {
                    Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a((IProperty)GATE_UP, (Comparable)Boolean.valueOf(gateUp))).func_206870_a((IProperty)GATE_DOWN, (Comparable)Boolean.valueOf(gateDown))), (boolean)true);
                }
                return;
            }
            if (!gateDown && (Boolean)state.func_177229_b((IProperty)POWERED) != powered && (Boolean)state.func_177229_b((IProperty)OPEN) != powered) {
                world.func_217378_a(null, powered ? 1008 : 1014, pos, 0);
            }
            if ((Boolean)state.func_177229_b((IProperty)POWERED) != powered || (Boolean)state.func_177229_b((IProperty)OPEN) != powered || (Boolean)state.func_177229_b((IProperty)GATE_UP) != gateUp || (Boolean)state.func_177229_b((IProperty)GATE_DOWN) != gateDown) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(powered))).func_206870_a((IProperty)GATE_UP, (Comparable)Boolean.valueOf(gateUp))).func_206870_a((IProperty)GATE_DOWN, (Comparable)Boolean.valueOf(gateDown))), (boolean)true);
            }
        }
    }

    private boolean canConnect(BlockState state, Direction direction) {
        return state.func_177230_c() == this && ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == direction.func_176740_k();
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }
}

