/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.block.BlockPergolaWall;

public class BlockPergolaRoof
extends BlockPergola {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty POST = BooleanProperty.func_177716_a((String)"post");
    protected static final VoxelShape TOP_BARS = Block.func_208617_a((double)0.0, (double)13.9, (double)0.0, (double)16.0, (double)16.1, (double)16.0);
    protected static final VoxelShape BEAM_NS_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.9, (double)0.9, (double)0.0, (double)5.1, (double)9.1, (double)16.0), (VoxelShape)Block.func_208617_a((double)10.9, (double)0.9, (double)0.0, (double)14.1, (double)9.1, (double)16.0));
    protected static final VoxelShape BEAM_EW_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)7.9, (double)2.9, (double)16.0, (double)14.1, (double)5.1), (VoxelShape)Block.func_208617_a((double)0.0, (double)7.9, (double)10.9, (double)16.0, (double)14.1, (double)13.1));
    protected static final VoxelShape BEAM_EW_SINGLE = Block.func_208617_a((double)0.0, (double)7.9, (double)6.9, (double)16.0, (double)14.1, (double)9.1);
    protected static final VoxelShape CAP_N_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.9, (double)4.9, (double)-3.1, (double)5.1, (double)9.1, (double)0.0), (VoxelShape)Block.func_208617_a((double)10.9, (double)4.9, (double)-3.1, (double)14.1, (double)9.1, (double)0.0));
    protected static final VoxelShape CAP_S_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.9, (double)4.9, (double)16.0, (double)5.1, (double)9.1, (double)19.1), (VoxelShape)Block.func_208617_a((double)10.9, (double)4.9, (double)16.0, (double)14.1, (double)9.1, (double)19.1));
    protected static final VoxelShape CAP_E_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)16.0, (double)10.9, (double)2.9, (double)18.1, (double)14.1, (double)5.1), (VoxelShape)Block.func_208617_a((double)16.0, (double)10.9, (double)10.9, (double)18.1, (double)14.1, (double)13.1));
    protected static final VoxelShape CAP_W_DUAL = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)-2.1, (double)10.9, (double)2.9, (double)0.0, (double)14.1, (double)5.1), (VoxelShape)Block.func_208617_a((double)-2.1, (double)10.9, (double)10.9, (double)0.0, (double)14.1, (double)13.1));
    protected static final VoxelShape CAP_E_SINGLE = Block.func_208617_a((double)16.0, (double)10.9, (double)6.9, (double)18.1, (double)14.1, (double)9.1);
    protected static final VoxelShape CAP_W_SINGLE = Block.func_208617_a((double)-2.1, (double)10.9, (double)6.9, (double)0.0, (double)14.1, (double)9.1);
    protected static final VoxelShape POST_S = Block.func_208617_a((double)4.9, (double)1.9, (double)4.9, (double)11.1, (double)13.1, (double)11.1);
    protected static final VoxelShape POST_L = Block.func_208617_a((double)4.9, (double)-3.1, (double)4.9, (double)11.1, (double)9.1, (double)11.1);
    private static final Map<String, VoxelShape> SHAPE_CACHE = new HashMap<String, VoxelShape>();

    public BlockPergolaRoof() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)POST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH, SOUTH, EAST, WEST, POST});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        String key = state.toString();
        if (SHAPE_CACHE.containsKey(key)) {
            return SHAPE_CACHE.get(key);
        }
        boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
        boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
        boolean post = (Boolean)state.func_177229_b((IProperty)POST);
        VoxelShape shape = TOP_BARS;
        if (!east || !west) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)BEAM_NS_DUAL);
            if (!north) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_N_DUAL);
            }
            if (!south) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_S_DUAL);
            }
        }
        if (!north || !south) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)BEAM_EW_DUAL);
            if (!east) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_E_DUAL);
            }
            if (!west) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_W_DUAL);
            }
        } else {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)BEAM_EW_SINGLE);
            if (!east) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_E_SINGLE);
            }
            if (!west) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)CAP_W_SINGLE);
            }
        }
        if (post) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)POST_L);
        }
        if (!north && !east || !east && !south || !south && !west || !west && !north) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)POST_S);
        }
        SHAPE_CACHE.put(key, shape);
        return shape;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnectedState(super.func_196258_a(context), context.func_195991_k(), context.func_195995_a());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState updated = this.getConnectedState(state, world, pos);
        if (state != updated) {
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)updated, (boolean)true);
        }
    }

    private BlockState getConnectedState(BlockState state, World world, BlockPos pos) {
        boolean post;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockPergolaRoof;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockPergolaRoof;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockPergolaRoof;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockPergolaRoof;
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        Block downBlock = downState.func_177230_c();
        boolean bl = post = downBlock instanceof WallBlock || downBlock instanceof FenceBlock;
        if (!post && downBlock instanceof BlockPergolaWall) {
            BlockPergola.EnumStyle style = (BlockPergola.EnumStyle)((Object)downState.func_177229_b(BlockPergolaWall.POST));
            post = style != BlockPergola.EnumStyle.NONE && style != BlockPergola.EnumStyle.BOTTOM;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(west))).func_206870_a((IProperty)POST, (Comparable)Boolean.valueOf(post));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!world.func_175727_C(pos.func_177984_a()) || rand.nextInt(15) != 1 || (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_200132_m() && blockstate.func_224755_d((IBlockReader)world, blockpos, Direction.UP))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

