/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockPineapple
extends BushBlock
implements IPlantable,
IBonemealable {
    public static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);
    private static final VoxelShape SHAPE_SMALL = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape SHAPE_LARGE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape SHAPE_PINEAPPLE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public BlockPineapple() {
        super(Block.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)EnumType.SMALL)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{VARIANT});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case SMALL: {
                return SHAPE_SMALL;
            }
            case LARGE: {
                return SHAPE_LARGE;
            }
        }
        return SHAPE_PINEAPPLE;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnumType type = (EnumType)((Object)state.func_177229_b(VARIANT));
        if (type == EnumType.SMALL || type == EnumType.FRUIT) {
            boolean removeBlock;
            if (type == EnumType.SMALL) {
                removeBlock = !this.func_196260_a(state, (IWorldReader)world, pos);
            } else {
                BlockState oState = world.func_180495_p(pos.func_177977_b());
                if (oState.func_177230_c() != this) {
                    removeBlock = true;
                } else {
                    EnumType gType = (EnumType)((Object)oState.func_177229_b(VARIANT));
                    boolean bl = removeBlock = gType != EnumType.LARGE_STEM && gType != EnumType.LARGE;
                }
            }
            if (removeBlock) {
                world.func_175655_b(pos, true);
                return;
            }
        } else {
            boolean pineapple;
            BlockPos oPos = pos.func_177984_a();
            BlockState oState = world.func_180495_p(oPos);
            boolean bl = pineapple = oState.func_177230_c() == this && oState.func_177229_b(VARIANT) == EnumType.FRUIT;
            if (type == EnumType.LARGE_STEM && !pineapple) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LARGE))), (boolean)true);
            } else if (type == EnumType.LARGE && pineapple) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LARGE_STEM))), (boolean)true);
            }
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case FRUIT: {
                return false;
            }
            case LARGE: 
            case LARGE_STEM: {
                return world.func_175623_d(pos.func_177984_a());
            }
            case SMALL: {
                return true;
            }
        }
        return false;
    }

    public boolean canUseBonemeal(World world, Random rand, BlockPos pos, BlockState state) {
        return rand.nextFloat() < 0.45f;
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case SMALL: {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.LARGE))), (boolean)true);
                break;
            }
            case LARGE: 
            case LARGE_STEM: {
                Function.setBlock((IWorld)world, (BlockPos)pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.FRUIT))), (boolean)true);
            }
        }
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case SMALL: {
                if (!PlantFunctions.canGrow(world, pos, PlantAPI.PlantType.PINEAPPLE)) break;
                this.grow(world, random, pos, state);
                break;
            }
            case LARGE: 
            case LARGE_STEM: {
                if (!world.func_175623_d(pos.func_177984_a()) || !PlantFunctions.canGrowFruit(world, pos, PlantAPI.PlantType.PINEAPPLE)) break;
                this.grow(world, random, pos, state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return (world.func_201669_a(pos, 0) >= 8 || world.func_217337_f(pos)) && super.func_196260_a(state, world, pos);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() == this && state.func_177229_b(VARIANT) == EnumType.LARGE_STEM || super.func_200014_a_(state, world, pos);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Plains;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        Item item = Values.itemPlantFruit.get((Object)PlantAPI.PlantType.PINEAPPLE);
        return item != null ? new ItemStack((IItemProvider)item) : ItemStack.field_190927_a;
    }

    public static enum EnumType implements IStringSerializable
    {
        SMALL(0),
        LARGE(1),
        LARGE_STEM(2),
        FRUIT(3);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[4];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

