/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.ItemBlockRGB;

public class BlockRGB
extends Block
implements IColored,
IRGB16_Block {
    private final DyeColor startColor;
    private final boolean renderSolid;
    private final boolean renderTranslucent;

    public BlockRGB(Block.Properties properties, boolean renderSolid, boolean renderTranslucent) {
        this(properties, DyeColor.WHITE, renderSolid, renderTranslucent);
    }

    public BlockRGB(Block.Properties properties, DyeColor startColor, boolean renderSolid, boolean renderTranslucent) {
        super(properties);
        this.startColor = startColor;
        this.renderSolid = renderSolid;
        this.renderTranslucent = renderTranslucent;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRGB16(Values.tileRGB16, this.startColor);
    }

    private TileEntityRGB16 getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityRGB16 ? (TileEntityRGB16)tile : null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityRGB16 tile = this.getTile((IBlockReader)world, pos);
        if (tile != null && stack.func_77973_b() instanceof ItemBlockRGB) {
            tile.setRGB16(((ItemBlockRGB)stack.func_77973_b()).getRGB16(stack), placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return this.renderTranslucent ? BlockRenderLayer.TRANSLUCENT : (this.renderSolid ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT_MIPPED);
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT && this.renderTranslucent || layer == BlockRenderLayer.SOLID && this.renderSolid || layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, Direction facing, DyeColor color) {
        return this.recolorBlock(state, world, pos, null, null, facing, null, color.func_176610_l());
    }

    public boolean recolorBlock(BlockState state, IWorld world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vec3d hitVec, String dyeName) {
        TileEntityRGB16 tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = this.getTile((IBlockReader)world, pos)) != null) {
            if (!world.func_201670_d()) {
                if (player == null) {
                    tile.getRGB16(null).setValues(dyeName);
                } else {
                    tile.getRGB16(player).recolor(player, dyeName);
                }
                Function.syncTile((TileEntity)tile);
            }
            if (player != null) {
                player.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        RGB16 rgb16;
        TileEntityRGB16 tile = this.getTile((IBlockReader)world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            int color = rgb16.getColor();
            return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        }
        return null;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityRGB16 tile;
        if (data.world != null && data.pos != null && index == 0 && (tile = this.getTile((IBlockReader)data.world, data.pos)) != null) {
            RGB16 rgb16 = tile.getRGB16(null);
            return rgb16 != null ? rgb16.getColor() : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        RGB16 rgb16;
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityRGB16 tile = this.getTile(world, pos);
        if (tile != null && (rgb16 = tile.getRGB16(null)) != null) {
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)rgb16);
        }
        return stack;
    }
}

