/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.trees.OakTree;
import net.minecraft.block.trees.Tree;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.worldgen.feature.FeatureAppleTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureBananaTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCherryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCoconutTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureLemonTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMangoTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMulberryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureOrangeTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePeachTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePearTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePlumTree;

public class BlockSapling
extends SaplingBlock {
    private final PlantAPI.TreeType treeType;

    public BlockSapling(PlantAPI.TreeType treeType) {
        super(BlockSapling.getTree(treeType), Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.treeType = treeType;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_200014_a_(state, world, pos) || this.treeType == PlantAPI.TreeType.COCONUT && Tags.Blocks.SAND.func_199685_a_((Object)state.func_177230_c());
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        if (world.isAreaLoaded(pos, 1) && world.func_201696_r(pos.func_177984_a()) >= 9 && PlantFunctions.canSaplingGrow((IBlockReader)world, pos, this.treeType)) {
            this.func_176478_d((IWorld)world, pos, state, random);
        }
    }

    private static Tree getTree(PlantAPI.TreeType treeType) {
        switch (treeType) {
            case APPLE: {
                return new AppleTree();
            }
            case CHERRY: {
                return new CherryTree();
            }
            case ORANGE: {
                return new OrangeTree();
            }
            case PEAR: {
                return new PearTree();
            }
            case PEACH: {
                return new PeachTree();
            }
            case MANGO: {
                return new MangoTree();
            }
            case LEMON: {
                return new LemonTree();
            }
            case PLUM: {
                return new PlumTree();
            }
            case BANANA: {
                return new BananaTree();
            }
            case COCONUT: {
                return new CoconutTree();
            }
            case MULBERRY: {
                return new MulberryTree();
            }
        }
        return new OakTree();
    }

    private static class MulberryTree
    extends Tree {
        private MulberryTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureMulberryTree(true);
        }
    }

    private static class CoconutTree
    extends Tree {
        private CoconutTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureCoconutTree(true);
        }
    }

    private static class BananaTree
    extends Tree {
        private BananaTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureBananaTree(true);
        }
    }

    private static class PlumTree
    extends Tree {
        private PlumTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeaturePlumTree(true);
        }
    }

    private static class LemonTree
    extends Tree {
        private LemonTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureLemonTree(true);
        }
    }

    private static class MangoTree
    extends Tree {
        private MangoTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureMangoTree(true);
        }
    }

    private static class PeachTree
    extends Tree {
        private PeachTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeaturePeachTree(true);
        }
    }

    private static class PearTree
    extends Tree {
        private PearTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeaturePearTree(true);
        }
    }

    private static class OrangeTree
    extends Tree {
        private OrangeTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureOrangeTree(true);
        }
    }

    private static class CherryTree
    extends Tree {
        private CherryTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureCherryTree(true);
        }
    }

    private static class AppleTree
    extends Tree {
        private AppleTree() {
        }

        protected AbstractTreeFeature<NoFeatureConfig> func_196936_b(Random random) {
            return new FeatureAppleTree(true);
        }
    }
}

