/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.item.ItemBlockVine;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockVine
extends VineBlock
implements IBonemealable,
IColored {
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.func_177716_a((String)"has_fruit");
    protected final PlantAPI.PlantType plantType;

    public BlockVine(PlantAPI.PlantType plantType) {
        super(Block.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c));
        this.plantType = plantType;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{HAS_FRUIT});
    }

    public PlantAPI.PlantType getPlantType() {
        return this.plantType;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_FRUIT)).booleanValue()) {
            Item fruit = Values.itemPlantFruit.get((Object)this.plantType);
            if (fruit != null) {
                if (player != null) {
                    Function.giveItem((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)fruit));
                } else {
                    Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)fruit));
                }
            }
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(false))), (boolean)true);
            return true;
        }
        return super.func_220051_a(state, world, pos, player, hand, hit);
    }

    public void func_196265_a(BlockState state, World world, BlockPos pos, Random random) {
        super.func_196265_a(state, world, pos, random);
        if (!((Boolean)state.func_177229_b((IProperty)HAS_FRUIT)).booleanValue() && random.nextBoolean() && PlantFunctions.canGrowFruit(world, pos, this.plantType)) {
            this.grow(world, random, pos, state);
        }
    }

    public boolean canGrow(World world, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) == false;
    }

    public boolean canUseBonemeal(World world, Random rand, BlockPos pos, BlockState state) {
        return rand.nextFloat() < 0.45f && this.canGrow(world, pos, state, false);
    }

    public void grow(World world, Random rand, BlockPos pos, BlockState state) {
        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(true))), (boolean)true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.plantType));
            }
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.plantType));
        }
        return 0xFFFFFF;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        ItemStack stack = context.func_195996_i();
        if (state != null && stack.func_77973_b() instanceof ItemBlockVine) {
            state = (BlockState)state.func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(ItemBlockVine.hasFruit(stack)));
        }
        return state;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemBlockVine.create(this.plantType, (Boolean)state.func_177229_b((IProperty)HAS_FRUIT));
    }

    public static BlockState getFruitVariant(BlockState state) {
        if (state.func_177230_c() instanceof BlockVine) {
            state = (BlockState)state.func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

