/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PaneBlock;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class BlockWall
extends Block
implements IWaterLoggable {
    public static final EnumProperty<PostHeight> POST_HEIGHT = EnumProperty.func_177709_a((String)"post", PostHeight.class);
    public static final EnumProperty<WallHeight> WALL_HEIGHT_EAST = EnumProperty.func_177709_a((String)"east", WallHeight.class);
    public static final EnumProperty<WallHeight> WALL_HEIGHT_NORTH = EnumProperty.func_177709_a((String)"north", WallHeight.class);
    public static final EnumProperty<WallHeight> WALL_HEIGHT_SOUTH = EnumProperty.func_177709_a((String)"south", WallHeight.class);
    public static final EnumProperty<WallHeight> WALL_HEIGHT_WEST = EnumProperty.func_177709_a((String)"west", WallHeight.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final Map<BlockState, VoxelShape> stateToShapeMap;
    private final Map<BlockState, VoxelShape> stateToCollisionShapeMap;
    private static final VoxelShape CENTER_POLE_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static Tag<Block> WALL_POST_OVERRIDE = new BlockTags.Wrapper(new ResourceLocation("wall_post_override"));

    public BlockWall(Block.Properties properties, float postWidth, float postHeightLow, float postHeightTall, float extensionWidth, float extMinY, float extMaxYLow, float extMaxYTall) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(POST_HEIGHT, (Comparable)((Object)PostHeight.NORMAL))).func_206870_a(WALL_HEIGHT_NORTH, (Comparable)((Object)WallHeight.NONE))).func_206870_a(WALL_HEIGHT_EAST, (Comparable)((Object)WallHeight.NONE))).func_206870_a(WALL_HEIGHT_SOUTH, (Comparable)((Object)WallHeight.NONE))).func_206870_a(WALL_HEIGHT_WEST, (Comparable)((Object)WallHeight.NONE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateToShapeMap = this.makeShapes(postWidth, postHeightLow, postHeightTall, extensionWidth, extMinY, extMaxYLow, extMaxYTall);
        float heightLow = Math.max(postHeightLow, extMaxYLow) * 1.5f;
        float heightTall = Math.max(postHeightTall, extMaxYTall) * 1.5f;
        this.stateToCollisionShapeMap = this.makeShapes(postWidth, heightLow, heightTall, extensionWidth, extMinY, heightLow, heightTall);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POST_HEIGHT, WALL_HEIGHT_NORTH, WALL_HEIGHT_EAST, WALL_HEIGHT_WEST, WALL_HEIGHT_SOUTH, WATERLOGGED});
    }

    protected Map<BlockState, VoxelShape> makeShapes(float postWidth, float postHeightLow, float postHeightTall, float extWidth, float extMinY, float extMaxYLow, float extMaxYTall) {
        float postMinXZ = 8.0f - postWidth;
        float postMaxXZ = 8.0f + postWidth;
        float extMinXZ = 8.0f - extWidth;
        float extMaxXZ = 8.0f + extWidth;
        VoxelShape shapePostLow = Block.func_208617_a((double)postMinXZ, (double)0.0, (double)postMinXZ, (double)postMaxXZ, (double)postHeightLow, (double)postMaxXZ);
        VoxelShape shapePostTall = Block.func_208617_a((double)postMinXZ, (double)0.0, (double)postMinXZ, (double)postMaxXZ, (double)postHeightTall, (double)postMaxXZ);
        VoxelShape shapeNorthLow = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)0.0, (double)extMaxXZ, (double)extMaxYLow, (double)extMaxXZ);
        VoxelShape shapeSouthLow = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYLow, (double)16.0);
        VoxelShape shapeWestLow = Block.func_208617_a((double)0.0, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYLow, (double)extMaxXZ);
        VoxelShape shapeEastLow = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)16.0, (double)extMaxYLow, (double)extMaxXZ);
        VoxelShape shapeNorthTall = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)0.0, (double)extMaxXZ, (double)extMaxYTall, (double)extMaxXZ);
        VoxelShape shapeSouthTall = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYTall, (double)16.0);
        VoxelShape shapeWestTall = Block.func_208617_a((double)0.0, (double)extMinY, (double)extMinXZ, (double)extMaxXZ, (double)extMaxYTall, (double)extMaxXZ);
        VoxelShape shapeEastTall = Block.func_208617_a((double)extMinXZ, (double)extMinY, (double)extMinXZ, (double)16.0, (double)extMaxYTall, (double)extMaxXZ);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PostHeight postHeight : POST_HEIGHT.func_177700_c()) {
            for (WallHeight eastHeight : WALL_HEIGHT_EAST.func_177700_c()) {
                for (WallHeight northHeight : WALL_HEIGHT_NORTH.func_177700_c()) {
                    for (WallHeight westHeight : WALL_HEIGHT_WEST.func_177700_c()) {
                        for (WallHeight southHeight : WALL_HEIGHT_SOUTH.func_177700_c()) {
                            VoxelShape baseShape = VoxelShapes.func_197880_a();
                            baseShape = VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)(postHeight == PostHeight.NORMAL ? shapePostLow : shapePostTall));
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, eastHeight, shapeEastLow, shapeEastTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, westHeight, shapeWestLow, shapeWestTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, northHeight, shapeNorthLow, shapeNorthTall);
                            baseShape = BlockWall.getHeightAlteredShape(baseShape, southHeight, shapeSouthLow, shapeSouthTall);
                            BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(POST_HEIGHT, (Comparable)((Object)postHeight))).func_206870_a(WALL_HEIGHT_EAST, (Comparable)((Object)eastHeight))).func_206870_a(WALL_HEIGHT_WEST, (Comparable)((Object)westHeight))).func_206870_a(WALL_HEIGHT_NORTH, (Comparable)((Object)northHeight))).func_206870_a(WALL_HEIGHT_SOUTH, (Comparable)((Object)southHeight));
                            builder.put(state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), (Object)baseShape);
                            builder.put(state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), (Object)baseShape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static VoxelShape getHeightAlteredShape(VoxelShape baseShape, WallHeight height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallHeight.TALL) {
            return VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallHeight.LOW ? VoxelShapes.func_197872_a((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.stateToShapeMap.get(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.stateToCollisionShapeMap.get(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    protected boolean shouldConnect(BlockState state, boolean isSideSolid, Direction direction) {
        Block block = state.func_177230_c();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)state, (Direction)direction);
        return state.func_203425_a(BlockTags.field_219757_z) || !BlockWall.func_220073_a((Block)block) && isSideSolid || block instanceof PaneBlock || flag;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos nPos = pos.func_177978_c();
        BlockPos ePos = pos.func_177974_f();
        BlockPos sPos = pos.func_177968_d();
        BlockPos wPos = pos.func_177976_e();
        BlockPos uPos = pos.func_177984_a();
        BlockState nState = world.func_180495_p(nPos);
        BlockState eState = world.func_180495_p(ePos);
        BlockState sState = world.func_180495_p(sPos);
        BlockState wState = world.func_180495_p(wPos);
        BlockState uState = world.func_180495_p(uPos);
        boolean nConnect = this.shouldConnect(nState, nState.func_224755_d((IBlockReader)world, nPos, Direction.SOUTH), Direction.SOUTH);
        boolean eConnect = this.shouldConnect(eState, eState.func_224755_d((IBlockReader)world, ePos, Direction.WEST), Direction.WEST);
        boolean sConnect = this.shouldConnect(sState, sState.func_224755_d((IBlockReader)world, sPos, Direction.NORTH), Direction.NORTH);
        boolean wConnect = this.shouldConnect(wState, wState.func_224755_d((IBlockReader)world, wPos, Direction.EAST), Direction.EAST);
        BlockState myState = (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        return this.getConnectedState((IWorldReader)world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == Direction.DOWN) {
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }
        return facing == Direction.UP ? this.func_235625_a_((IWorldReader)world, state, facingPos, facingState) : this.func_235627_a_((IWorldReader)world, currentPos, state, facingPos, facingState, facing);
    }

    private static boolean hasHeightForProperty(BlockState state, Property<WallHeight> heightProperty) {
        return state.func_177229_b(heightProperty) != WallHeight.NONE;
    }

    private BlockState func_235625_a_(IWorldReader world, BlockState myState, BlockPos uPos, BlockState uState) {
        boolean nConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_NORTH);
        boolean eConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_EAST);
        boolean sConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_SOUTH);
        boolean wConnect = BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_WEST);
        return this.getConnectedState(world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    private BlockState func_235627_a_(IWorldReader world, BlockPos pos, BlockState myState, BlockPos facingPos, BlockState facingState, Direction face) {
        Direction direction = face.func_176734_d();
        boolean nConnect = face == Direction.NORTH ? this.shouldConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_NORTH);
        boolean eConnect = face == Direction.EAST ? this.shouldConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_EAST);
        boolean sConnect = face == Direction.SOUTH ? this.shouldConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_SOUTH);
        boolean wConnect = face == Direction.WEST ? this.shouldConnect(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, direction), direction) : BlockWall.hasHeightForProperty(myState, WALL_HEIGHT_WEST);
        BlockPos uPos = pos.func_177984_a();
        BlockState uState = world.func_180495_p(uPos);
        return this.getConnectedState(world, myState, uPos, uState, nConnect, eConnect, sConnect, wConnect);
    }

    private BlockState getConnectedState(IWorldReader world, BlockState myState, BlockPos uPos, BlockState uState, boolean nConnect, boolean eConnect, boolean sConnect, boolean wConnect) {
        PostHeight pHeight;
        WallHeight wHeight;
        WallHeight nHeight = nConnect ? WallHeight.LOW : WallHeight.NONE;
        WallHeight eHeight = eConnect ? WallHeight.LOW : WallHeight.NONE;
        WallHeight sHeight = sConnect ? WallHeight.LOW : WallHeight.NONE;
        WallHeight wallHeight = wHeight = wConnect ? WallHeight.LOW : WallHeight.NONE;
        if (uState.func_177230_c() == this) {
            nHeight = nConnect && uState.func_177229_b(WALL_HEIGHT_NORTH) != WallHeight.NONE ? WallHeight.TALL : nHeight;
            eHeight = eConnect && uState.func_177229_b(WALL_HEIGHT_EAST) != WallHeight.NONE ? WallHeight.TALL : eHeight;
            sHeight = sConnect && uState.func_177229_b(WALL_HEIGHT_SOUTH) != WallHeight.NONE ? WallHeight.TALL : sHeight;
            wHeight = wConnect && uState.func_177229_b(WALL_HEIGHT_WEST) != WallHeight.NONE ? WallHeight.TALL : wHeight;
            pHeight = PostHeight.TALL;
        } else {
            VoxelShape voxelshape = uState.func_196952_d((IBlockReader)world, uPos).func_212434_a(Direction.DOWN);
            pHeight = uState.func_177230_c().func_203417_a(WALL_POST_OVERRIDE) || !VoxelShapes.func_197879_c((VoxelShape)CENTER_POLE_SHAPE, (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223234_e_) ? PostHeight.EXT : PostHeight.NORMAL;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)myState.func_206870_a(POST_HEIGHT, (Comparable)((Object)pHeight))).func_206870_a(WALL_HEIGHT_NORTH, (Comparable)((Object)nHeight))).func_206870_a(WALL_HEIGHT_EAST, (Comparable)((Object)eHeight))).func_206870_a(WALL_HEIGHT_SOUTH, (Comparable)((Object)sHeight))).func_206870_a(WALL_HEIGHT_WEST, (Comparable)((Object)wHeight));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(WALL_HEIGHT_NORTH, state.func_177229_b(WALL_HEIGHT_SOUTH))).func_206870_a(WALL_HEIGHT_EAST, state.func_177229_b(WALL_HEIGHT_WEST))).func_206870_a(WALL_HEIGHT_SOUTH, state.func_177229_b(WALL_HEIGHT_NORTH))).func_206870_a(WALL_HEIGHT_WEST, state.func_177229_b(WALL_HEIGHT_EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(WALL_HEIGHT_NORTH, state.func_177229_b(WALL_HEIGHT_EAST))).func_206870_a(WALL_HEIGHT_EAST, state.func_177229_b(WALL_HEIGHT_SOUTH))).func_206870_a(WALL_HEIGHT_SOUTH, state.func_177229_b(WALL_HEIGHT_WEST))).func_206870_a(WALL_HEIGHT_WEST, state.func_177229_b(WALL_HEIGHT_NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(WALL_HEIGHT_NORTH, state.func_177229_b(WALL_HEIGHT_WEST))).func_206870_a(WALL_HEIGHT_EAST, state.func_177229_b(WALL_HEIGHT_NORTH))).func_206870_a(WALL_HEIGHT_SOUTH, state.func_177229_b(WALL_HEIGHT_EAST))).func_206870_a(WALL_HEIGHT_WEST, state.func_177229_b(WALL_HEIGHT_SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(WALL_HEIGHT_NORTH, state.func_177229_b(WALL_HEIGHT_SOUTH))).func_206870_a(WALL_HEIGHT_SOUTH, state.func_177229_b(WALL_HEIGHT_NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(WALL_HEIGHT_EAST, state.func_177229_b(WALL_HEIGHT_WEST))).func_206870_a(WALL_HEIGHT_WEST, state.func_177229_b(WALL_HEIGHT_EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public static enum WallHeight implements IStringSerializable
    {
        NONE("none"),
        LOW("low"),
        TALL("tall");

        private final String heightName;

        private WallHeight(String name) {
            this.heightName = name;
        }

        public String toString() {
            return this.getString();
        }

        public String getString() {
            return this.heightName;
        }

        public String func_176610_l() {
            return this.toString();
        }
    }

    public static enum PostHeight implements IStringSerializable
    {
        NORMAL("normal"),
        TALL("tall"),
        EXT("ext");

        private final String heightName;

        private PostHeight(String name) {
            this.heightName = name;
        }

        public String toString() {
            return this.getString();
        }

        public String getString() {
            return this.heightName;
        }

        public String func_176610_l() {
            return this.toString();
        }
    }
}

