/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesCoconut;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class EntityCoconut
extends Entity
implements IEntityAdditionalSpawnData {
    private int fallTime;
    public float field_213325_aI;
    private int age;
    private byte delay;
    private EntitySize currentSize = new EntitySize(0.3f, 0.35f, false);
    private static DataParameter<Float> SIZE_DATA = EntityDataManager.func_187226_a(EntityCoconut.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityCoconut(World world) {
        this(Values.entityCoconut, world);
    }

    public EntityCoconut(EntityType type, World world) {
        super(type, world);
    }

    public EntityCoconut(World world, BlockPos pos, boolean treeSpawned) {
        this(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, treeSpawned);
    }

    public EntityCoconut(World world, double x, double y, double z, boolean treeSpawned) {
        super(Values.entityCoconut, world);
        if (treeSpawned) {
            x = x - 0.2 + (double)Function.random.nextInt(4) / 10.0;
            y -= 0.02;
            z = z - 0.2 + (double)Function.random.nextInt(4) / 10.0;
        }
        this.func_70107_b(x, y, z);
        this.field_213325_aI = treeSpawned ? 0.2f : 1.0f;
        this.age = treeSpawned ? 1 : -1;
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.field_70180_af.func_187227_b(SIZE_DATA, (Object)Float.valueOf(this.field_213325_aI));
        this.field_70177_z = (float)(Math.random() * 360.0);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE_DATA, (Object)Float.valueOf(this.field_213325_aI));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return this.field_213325_aI >= 1.0f;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_70046_E();
    }

    public AxisAlignedBB func_70046_E() {
        if (this.field_213325_aI < 1.0f) {
            return null;
        }
        return new AxisAlignedBB(this.field_70165_t - (double)0.15f, this.field_70163_u - (double)0.15f, this.field_70161_v - (double)0.15f, this.field_70165_t + (double)0.15f, this.field_70163_u + (double)0.15f, this.field_70161_v + (double)0.15f);
    }

    public EntitySize func_213305_a(Pose pose) {
        return this.currentSize;
    }

    private void setSize(float width, float height) {
        this.currentSize = new EntitySize(width, height, false);
        this.func_213323_x_();
    }

    public void func_70071_h_() {
        if (!this.getWorld().field_72995_K && this.age == 0) {
            this.func_70106_y();
        }
        this.field_213325_aI = ((Float)this.field_70180_af.func_187225_a(SIZE_DATA)).floatValue();
        if (this.field_213325_aI < 1.0f) {
            this.field_70145_X = true;
            this.growTick();
        } else {
            this.updateTick();
        }
        this.field_70180_af.func_187227_b(SIZE_DATA, (Object)Float.valueOf(this.field_213325_aI));
    }

    private void growTick() {
        if (this.delay < 1) {
            if (this.field_70163_u > this.field_70167_r) {
                this.field_70163_u -= this.field_70163_u - this.field_70167_r;
            }
            this.field_70167_r = this.field_70163_u;
            boolean onLeaf = this.getWorld().func_180495_p(this.func_180425_c().func_177984_a()).func_177230_c() instanceof BlockLeavesCoconut;
            if (this.field_213325_aI + 0.0025f >= 1.0f && onLeaf && (this.getWorld().field_72995_K || !PlantFunctions.dropFruit((IBlockReader)this.func_130014_f_(), this.func_180425_c(), PlantAPI.TreeType.COCONUT))) {
                this.field_213325_aI = 0.9999f;
                this.delay = (byte)20;
                if (this.func_213302_cg() < 0.35f) {
                    this.setSize(0.3f, 0.35f);
                }
            } else {
                this.field_213325_aI += 0.0025f;
                this.field_70163_u -= (double)0.0011f;
                this.delay = 1;
                this.setSize(0.3f, 0.35f * this.field_213325_aI);
            }
            if (!onLeaf && this.field_213325_aI < 1.0f && this.getWorld().field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.delay = (byte)(this.delay - 1);
        }
    }

    private void updateTick() {
        if (this.func_213302_cg() < 0.35f) {
            this.setSize(0.3f, 0.35f);
        }
        if (this.field_70145_X && this.fallTime > 3) {
            this.field_70145_X = false;
        }
        if (!this.field_70122_E) {
            ++this.fallTime;
        } else if (this.fallTime > 0) {
            this.fallTime = 0;
        }
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        BlockState state = this.func_130014_f_().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof FlowingFluidBlock || block instanceof IFluidBlock || block.func_149688_o(state) == Material.field_151586_h || block.func_149688_o(state) == Material.field_151587_i) {
            this.func_85031_j(null);
            return;
        }
        this.collideWithNearbyEntities();
        float friction = 0.98f;
        if (this.field_70122_E) {
            pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_70046_E().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            friction = this.func_130014_f_().func_180495_p(pos).getSlipperiness((IWorldReader)this.func_130014_f_(), pos, (Entity)this) * 0.98f;
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)friction, 0.98, (double)friction));
        if (!this.func_130014_f_().field_72995_K) {
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            if (this.fallTime > 100 && (y < 1 || y > 256)) {
                this.func_70106_y();
            }
            if (this.field_70122_E && this.age > 0) {
                ++this.age;
            }
            if (this.age >= 6000) {
                this.func_85031_j(null);
            }
        }
    }

    private void collideWithNearbyEntities() {
        List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_70046_E().func_72321_a(0.2, 0.0, 0.2));
        if (!list.isEmpty()) {
            this.field_70177_z = (float)(Math.random() * 360.0);
            this.field_70165_t += this.field_70146_Z.nextBoolean() ? -0.01 : 0.01;
            this.field_70161_v += this.field_70146_Z.nextBoolean() ? -0.01 : 0.01;
            for (Entity entity : list) {
                if (entity instanceof PlayerEntity) continue;
                this.func_70108_f(entity);
            }
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.NORMAL;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0) {
            List list = this.func_130014_f_().func_72839_b((Entity)this, this.func_70046_E().func_72321_a(0.25, 0.25, 0.25));
            for (Entity entity : list) {
                entity.func_70097_a((DamageSource)Values.damageCoconut, (float)Math.min(MathHelper.func_76141_d((float)((float)i * 2.0f)), 15));
            }
        }
    }

    public boolean func_85031_j(Entity entity) {
        if (this.field_213325_aI >= 0.9975f) {
            ItemStack stack;
            if (entity instanceof LivingEntity && !(stack = ((LivingEntity)entity).func_184614_ca()).func_190926_b() && Tags.Items.RODS.func_199685_a_((Object)stack.func_77973_b())) {
                int i = 3 + EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)entity));
                this.func_70024_g(-MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f, 0.1, MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f);
                return true;
            }
            this.func_70106_y();
            ItemStack itemStack = this.getPickedResult(null);
            if (itemStack != null) {
                Function.dropItem((World)this.func_130014_f_(), (BlockPos)new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), (ItemStack)itemStack);
            }
        }
        return true;
    }

    protected void func_213281_b(CompoundNBT nbtTag) {
        nbtTag.func_74774_a("Time", (byte)this.fallTime);
        nbtTag.func_74776_a("Size", this.field_213325_aI);
        nbtTag.func_74768_a("Age", this.age);
    }

    protected void func_70037_a(CompoundNBT nbtTag) {
        this.fallTime = nbtTag.func_74771_c("Time") & 0xFF;
        this.field_213325_aI = nbtTag.func_74760_g("Size");
        this.age = nbtTag.func_74762_e("Age");
        this.field_70180_af.func_187227_b(SIZE_DATA, (Object)Float.valueOf(this.field_213325_aI));
    }

    public World getWorld() {
        return this.func_130014_f_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        Item fruit = Values.itemTreeFruit.get((Object)PlantAPI.TreeType.COCONUT);
        return fruit != null ? new ItemStack((IItemProvider)fruit) : ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.field_213325_aI);
        buffer.func_150787_b(this.age);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.field_213325_aI = additionalData.readFloat();
        this.age = additionalData.func_150792_a();
    }
}

