/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity.ai;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.misc.ConfiguredItemListUtil;
import shetiphian.terraqueous.common.misc.WeightedList;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

public class TaskFlowerPotUpdate
extends Task<VillagerEntity> {
    private static WeightedList<Item> PLANTS = null;
    private BlockPos posFlowerPot;
    private long taskCooldown;
    private int idleTime;

    public TaskFlowerPotUpdate() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
    }

    protected boolean shouldExecute(ServerWorld world, VillagerEntity villager) {
        BlockPos pos;
        TileEntity tileEntity;
        DimensionType dimensionType = world.func_201675_m().func_186058_p();
        BlockPos villagerPosition = villager.func_180425_c();
        ArrayList list = Lists.newArrayList();
        int range = 8;
        for (int x = -range; x <= range; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos2 = villagerPosition.func_177982_a(x, y, z);
                    Block block = world.func_180495_p(pos2).func_177230_c();
                    if (!(block instanceof BlockFlowerPot)) continue;
                    list.add(GlobalPos.func_218179_a((DimensionType)dimensionType, (BlockPos)pos2));
                }
            }
        }
        if (!list.isEmpty() && (tileEntity = world.func_175625_s(pos = ((GlobalPos)list.get(world.field_73012_v.nextInt(list.size()))).func_218180_b())) instanceof TileEntityFlowerPot && this.canUpdateFlowerPot((TileEntityFlowerPot)tileEntity, world.func_82737_E())) {
            this.posFlowerPot = pos;
            return true;
        }
        return false;
    }

    protected void startExecuting(ServerWorld world, VillagerEntity villager, long gameTime) {
        if (gameTime > this.taskCooldown && this.posFlowerPot != null) {
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.posFlowerPot));
            villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new BlockPosWrapper(this.posFlowerPot), 0.5f, 1));
        }
    }

    protected void resetTask(ServerWorld world, VillagerEntity villager, long gameTime) {
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
        villager.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        this.idleTime = 0;
        this.taskCooldown = gameTime + 40L;
    }

    private boolean canUpdateFlowerPot(TileEntityFlowerPot flowerPot, long gameTime) {
        return flowerPot.getPlantStack().func_190926_b() || flowerPot.getVillagerPlantTimer() > 0L && flowerPot.getVillagerPlantTimer() < gameTime;
    }

    protected void updateTask(ServerWorld world, VillagerEntity villager, long gameTime) {
        if (this.posFlowerPot == null || this.posFlowerPot.func_218137_a((IPosition)villager.func_213303_ch(), 1.73)) {
            if (this.posFlowerPot != null && gameTime > this.taskCooldown) {
                Item plant;
                TileEntityFlowerPot flowerPot;
                villager.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.posFlowerPot));
                TileEntity tileEntity = world.func_175625_s(this.posFlowerPot);
                if (tileEntity instanceof TileEntityFlowerPot && this.canUpdateFlowerPot(flowerPot = (TileEntityFlowerPot)tileEntity, gameTime) && (plant = this.getPlant(world.field_73012_v)) != null) {
                    flowerPot.setPlantStack(new ItemStack((IItemProvider)plant));
                    flowerPot.setVillagerPlantTimer(gameTime + 40L);
                    Function.syncTile((TileEntity)flowerPot);
                    world.func_184133_a(null, this.posFlowerPot, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    this.posFlowerPot = null;
                }
            }
            ++this.idleTime;
        }
    }

    protected boolean shouldContinueExecuting(ServerWorld world, VillagerEntity villager, long gameTime) {
        return this.idleTime < 200;
    }

    private Item getPlant(Random random) {
        if (PLANTS == null || Values.rebuildGardnerList) {
            PLANTS = new WeightedList();
            Map<String, String> items = ConfiguredItemListUtil.generateItemList("village gardner", (List)Configuration.TWEAKS.VILLAGER.gardnerWhitelist.get(), (List)Configuration.TWEAKS.VILLAGER.gardnerBlacklist.get());
            for (Map.Entry<String, String> entry : items.entrySet()) {
                try {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getKey()));
                    if (item == null) continue;
                    String value = entry.getValue();
                    int weight = 1;
                    try {
                        weight = value.contains("-") ? Integer.parseInt(value.split("-")[0]) : Integer.parseInt(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PLANTS.addEntry(item, weight);
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error adding item '" + entry.getKey() + "' to village gardner planting list; " + error);
                }
            }
            Values.rebuildGardnerList = false;
        }
        Item plant = null;
        try {
            plant = PLANTS.getRandomEntry(random);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return plant;
    }
}

