/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.common.block.BlockDryingHay;

public class ItemBlockDryingHay
extends BlockItem
implements IColored {
    public ItemBlockDryingHay(Block block, Item.Properties builder) {
        super(block, builder);
        this.func_185043_a(new ResourceLocation("progress"), (stack, world, entity) -> ItemBlockDryingHay.getProgress(stack));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (int index = 0; index < 9; ++index) {
                list.add((Object)ItemBlockDryingHay.create(new ItemStack((IItemProvider)this), index));
            }
        }
    }

    public static ItemStack create(ItemStack stack, int progress) {
        if (!stack.func_190926_b() && progress >= 0) {
            CompoundNBT nbt = stack.func_190925_c("BlockStateTag");
            nbt.func_74768_a("progress", MathHelper.func_76125_a((int)progress, (int)0, (int)9));
        }
        return stack;
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        CompoundNBT nbt;
        if (!stack.func_190926_b() && !(nbt = stack.func_190925_c("BlockStateTag")).func_74764_b("progress")) {
            nbt.func_74768_a("progress", 0);
        }
        super.func_77622_d(stack, world, player);
    }

    public static int getProgress(ItemStack stack) {
        int progress = 0;
        if (!stack.func_190926_b()) {
            CompoundNBT nbt = stack.func_190925_c("BlockStateTag");
            progress = nbt.func_74764_b("progress") ? nbt.func_74762_e("progress") : 0;
        }
        return MathHelper.func_76125_a((int)progress, (int)0, (int)9);
    }

    public int getColorFor(IColored.Data data, int index) {
        return index == 0 && !data.stack.func_190926_b() ? BlockDryingHay.COLORS[ItemBlockDryingHay.getProgress(data.stack)] : 0xFFFFFF;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + (ItemBlockDryingHay.getProgress(stack) == 0 ? ".grass" : ".drying");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        int progress = ItemBlockDryingHay.getProgress(stack);
        if (progress > 0) {
            name = name.func_150258_a(" (" + progress + "0%)");
        }
        return name;
    }
}

