/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;

public class ItemBlockLeaves
extends BlockItem
implements IColored {
    private final PlantAPI.TreeType treeType;

    public ItemBlockLeaves(PlantAPI.TreeType treeType, Block block, Item.Properties builder) {
        super(block, builder);
        this.treeType = treeType;
        this.func_185043_a(new ResourceLocation("type"), (stack, world, entity) -> ItemBlockLeaves.getType(stack));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            if (this.treeType != PlantAPI.TreeType.COCONUT && this.treeType != PlantAPI.TreeType.BANANA) {
                list.add((Object)ItemBlockLeaves.create(this.treeType, 1));
                list.add((Object)ItemBlockLeaves.create(this.treeType, 2));
            }
        }
    }

    public static ItemStack create(PlantAPI.TreeType tree, int type) {
        ItemStack stack;
        Block block = Values.blockLeaves.get((Object)tree);
        if (block != null && !(stack = new ItemStack((IItemProvider)block)).func_190926_b()) {
            if (type > 0 && tree != PlantAPI.TreeType.COCONUT) {
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_74768_a("type", MathHelper.func_76125_a((int)type, (int)1, (int)(tree == PlantAPI.TreeType.BANANA ? 4 : 2)));
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static int getType(ItemStack stack) {
        if (!stack.func_190926_b()) {
            CompoundNBT nbt = stack.func_196082_o();
            return nbt.func_74764_b("type") ? nbt.func_74762_e("type") : 0;
        }
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (this.treeType == PlantAPI.TreeType.BANANA) {
            int type = ItemBlockLeaves.getType(stack);
            name = name + (type == 1 ? ".flower" : (type > 0 ? ".stalk" : ""));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            if (this.treeType == PlantAPI.TreeType.BANANA && data.stack != null && ItemBlockLeaves.getType(data.stack) > 0) {
                return 0xFFFFFF;
            }
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.treeType));
        }
        return 0xFFFFFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        if (this.treeType != PlantAPI.TreeType.COCONUT) {
            int type = ItemBlockLeaves.getType(stack);
            if (this.treeType == PlantAPI.TreeType.BANANA) {
                type -= 2;
            }
            if (type == 1) {
                tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.growingfruit.txt")));
            } else if (type == 2) {
                tooltip.add((ITextComponent)new StringTextComponent(Localization.get((String)"info.terraqueous.withfruit.txt")));
            }
        }
    }
}

