/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemCloudStaff
extends ToolItem
implements IToolMode {
    private static final int maxCharge = 1024000;

    public ItemCloudStaff(Item.Properties builder) {
        super(0.0f, 0.0f, (IItemTier)ItemTier.GOLD, (Set)Sets.newHashSet((Object[])new Block[0]), builder);
        this.func_185043_a(new ResourceLocation("mode"), (stack, world, entity) -> ItemCloudStaff.getEnumMode(stack).getValue());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            ItemStack stack = ItemCloudStaff.newTool(EnumMode.LIGHT, false);
            list.add((Object)stack.func_77946_l());
            ItemCloudStaff.setFluid(stack, new FluidStack((Fluid)Fluids.field_204546_a, 1024000));
            list.add((Object)stack);
        }
    }

    public static ItemStack newTool(EnumMode mode, boolean base_fill) {
        ItemStack stack = ItemCloudStaff.setType(new ItemStack((IItemProvider)Values.itemCloudStaff), mode);
        if (base_fill) {
            ItemCloudStaff.setFluid(stack, new FluidStack((Fluid)Fluids.field_204546_a, (int)(mode.getMultiplier() * 1000.0 * 8.0)));
        }
        return stack;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return CloudAPI.isCloud(state) ? this.field_77864_a : 1.0f;
    }

    @Nonnull
    private static CompoundNBT getTag(@Nonnull ItemStack stack) {
        CompoundNBT nbtTag = stack.func_196082_o();
        if (!nbtTag.func_74764_b("mode")) {
            nbtTag.func_74778_a("mode", EnumMode.LIGHT.toString());
        }
        return nbtTag;
    }

    public static EnumMode getEnumMode(ItemStack stack) {
        return EnumMode.byName(ItemCloudStaff.getTag(stack).func_74779_i("mode"));
    }

    private static ItemStack setType(ItemStack stack, EnumMode type) {
        ItemCloudStaff.getTag(stack).func_74778_a("mode", type.toString());
        return stack;
    }

    @Override
    public boolean changeMode(PlayerEntity player, ItemStack stack, boolean next) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCloudStaff) {
            EnumMode type = ItemCloudStaff.getEnumMode(stack);
            int value = type.getValue() + (next ? -1 : 1);
            ItemCloudStaff.setType(stack, EnumMode.byValue(value));
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand;
        ItemStack heldItem;
        ActionResultType toolResult = ActionResultType.PASS;
        PlayerEntity player = context.func_195999_j();
        if (player != null && !(heldItem = player.func_184586_b(hand = context.func_221531_n())).func_190926_b()) {
            BlockRayTraceResult raytraceresult;
            World world = context.func_195991_k();
            Direction facing = context.func_196000_l();
            FluidStack fluidStack = ItemCloudStaff.getFluid(heldItem);
            if (!player.func_70093_af() && (fluidStack.isEmpty() || fluidStack.getAmount() < 1024000) && (raytraceresult = (BlockRayTraceResult)ItemCloudStaff.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)) != null && raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && player.func_175151_a(raytraceresult.func_216350_a(), facing, heldItem)) {
                Fluid fluid;
                BlockPos pos = raytraceresult.func_216350_a();
                BlockState state = world.func_180495_p(pos);
                FluidStack wanted = new FluidStack((Fluid)Fluids.field_204546_a, fluidStack.isEmpty() ? 1000 : Math.min(1000, 1024000 - fluidStack.getAmount()));
                AtomicReference<FluidStack> drained = new AtomicReference<FluidStack>(FluidStack.EMPTY);
                if (state.func_177230_c() instanceof IBucketPickupHandler && world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a && (fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state)) != Fluids.field_204541_a) {
                    drained.set(new FluidStack((Fluid)Fluids.field_204546_a, 1000));
                }
                if (drained.get() == FluidStack.EMPTY) {
                    FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)raytraceresult.func_216354_b()).ifPresent(handler -> {
                        if (handler.drain(wanted, IFluidHandler.FluidAction.SIMULATE) != FluidStack.EMPTY) {
                            drained.set(handler.drain(wanted, IFluidHandler.FluidAction.EXECUTE));
                        }
                    });
                }
                if (drained.get() != FluidStack.EMPTY) {
                    if (!fluidStack.isEmpty()) {
                        fluidStack.grow(drained.get().getAmount());
                    } else {
                        fluidStack = wanted;
                        fluidStack.setAmount(drained.get().getAmount());
                    }
                    player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    ItemCloudStaff.setFluid(heldItem, fluidStack);
                    toolResult = ActionResultType.SUCCESS;
                }
            }
            if (toolResult == ActionResultType.PASS && (player.field_71075_bZ.field_75098_d || ItemCloudStaff.getBlockCount(heldItem) >= 1.0)) {
                EnumMode mode = ItemCloudStaff.getEnumMode(heldItem);
                BlockState state = null;
                if (mode == EnumMode.VAPOR) {
                    if (Values.blockWaterVapor != null) {
                        state = Values.blockWaterVapor.func_176223_P();
                    }
                } else if (!Values.blockClouds.isEmpty()) {
                    Block block;
                    CloudAPI.CloudType cloudType = null;
                    switch (mode) {
                        case LIGHT: {
                            cloudType = CloudAPI.CloudType.LIGHT;
                            break;
                        }
                        case DENSE: {
                            cloudType = CloudAPI.CloudType.DENSE;
                            break;
                        }
                        case STORM: {
                            cloudType = CloudAPI.CloudType.STORM;
                        }
                    }
                    if (cloudType != null && (block = Values.blockClouds.get((Object)cloudType)) != null) {
                        state = block.func_176223_P();
                    }
                }
                if (state != null && !fluidStack.isEmpty()) {
                    BlockPos pos = context.func_195995_a();
                    boolean placed = false;
                    if (pos.func_177956_o() < 0 && pos.func_177958_n() == 0 && pos.func_177952_p() == 0) {
                        pos = this.getAirPos(player);
                        player.func_184609_a(hand);
                    } else {
                        pos = pos.func_177972_a(facing);
                    }
                    if (world.func_175623_d(pos) && player.func_175151_a(pos, facing, heldItem)) {
                        world.func_184133_a(player, pos, state.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        placed = Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)state, (boolean)true);
                    }
                    if (placed) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            fluidStack.shrink((int)(1000.0 * mode.getMultiplier()));
                            ItemCloudStaff.setFluid(heldItem, fluidStack);
                        }
                        toolResult = ActionResultType.SUCCESS;
                    }
                }
            }
        }
        return toolResult;
    }

    private BlockPos getAirPos(PlayerEntity player) {
        int posX = 0;
        int posZ = 0;
        int camY = -MathHelper.func_76128_c((double)((double)(player.field_70125_A * 6.0f / 180.0f) + 0.5));
        int camX = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 12.0f / 360.0f) + 0.5)) % 12;
        if (camY == 3 || camY == -3) {
            posX = 0;
            posZ = 0;
            camY = camY == 3 ? 2 : -2;
        } else {
            camX = camX < 0 ? (camX += 12) : camX;
            switch (camX) {
                case 11: {
                    ++posX;
                    posZ += 2;
                    break;
                }
                case 0: {
                    posX += 0;
                    posZ += 2;
                    break;
                }
                case 1: {
                    --posX;
                    posZ += 2;
                    break;
                }
                case 2: {
                    posX -= 2;
                    ++posZ;
                    break;
                }
                case 3: {
                    posX -= 2;
                    posZ += 0;
                    break;
                }
                case 4: {
                    posX -= 2;
                    --posZ;
                    break;
                }
                case 5: {
                    --posX;
                    posZ -= 2;
                    break;
                }
                case 6: {
                    posX += 0;
                    posZ -= 2;
                    break;
                }
                case 7: {
                    ++posX;
                    posZ -= 2;
                    break;
                }
                case 8: {
                    posX += 2;
                    --posZ;
                    break;
                }
                case 9: {
                    posX += 2;
                    posZ += 0;
                    break;
                }
                case 10: {
                    posX += 2;
                    ++posZ;
                }
            }
            if (camY == -2 || camY == 2) {
                int n = camX >= 2 && camX <= 4 ? posX + 1 : (posX = camX >= 8 && camX <= 10 ? posX - 1 : posX);
                posZ = camX >= 5 && camX <= 7 ? posZ + 1 : (camX <= 1 || camX == 11 ? posZ - 1 : posZ);
            }
        }
        int[] blockXZ = Function.getBlockXZ((double)player.field_70165_t, (double)player.field_70161_v);
        return new BlockPos(blockXZ[0] + posX, (int)player.field_70163_u + camY + 1, blockXZ[1] + posZ);
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!stack.func_190926_b()) {
            int amount = 0;
            if (state.func_177230_c() instanceof BlockClouds) {
                amount = (int)Math.pow(4.0, ((BlockClouds)state.func_177230_c()).getCloud().getID()) * 1000;
            } else if (state.func_177230_c().equals(Values.blockWaterVapor)) {
                amount = 250;
            }
            if (amount > 0) {
                FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
                if (fluidStack.isEmpty()) {
                    fluidStack = new FluidStack((Fluid)Fluids.field_204546_a, amount);
                } else if (fluidStack.getAmount() + amount <= 1024000) {
                    fluidStack.grow(amount);
                } else {
                    fluidStack = null;
                }
                if (fluidStack != null) {
                    if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
                        ItemCloudStaff.setFluid(stack, fluidStack);
                    }
                    world.func_217377_a(pos, false);
                }
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return stack.func_190926_b() ? null : new CloudStaffFluidHandlerItemStack(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
        int amount = fluidStack.isEmpty() ? 0 : fluidStack.getAmount();
        return 1.0 - (double)amount / 1024000.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 2122170;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
            if (!fluidStack.isEmpty()) {
                fluidStack.shrink((int)(mode.getMultiplier() * 1000.0 * 8.0));
                ItemCloudStaff.setFluid(stack, (FluidStack)(fluidStack.getAmount() > 0 ? fluidStack : null));
            }
        }
        return stack.func_77946_l();
    }

    @Nonnull
    private static FluidStack getFluid(@Nonnull ItemStack stack) {
        CompoundNBT nbtTag = ItemCloudStaff.getTag(stack);
        if (!nbtTag.func_74764_b("Fluid")) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)nbtTag.func_74775_l("Fluid"));
    }

    private static void setFluid(@Nonnull ItemStack stack, FluidStack fluid) {
        CompoundNBT nbtTag = ItemCloudStaff.getTag(stack);
        if (fluid == null || fluid.getAmount() < 1) {
            nbtTag.func_82580_o("Fluid");
        } else {
            CompoundNBT fluidTag = new CompoundNBT();
            fluid.writeToNBT(fluidTag);
            nbtTag.func_218657_a("Fluid", (INBT)fluidTag);
        }
    }

    public static double getBlockCount(ItemStack stack) {
        double placeable = 0.0;
        if (!stack.func_190926_b()) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
            double amount = fluidStack.isEmpty() ? 0.0 : (double)fluidStack.getAmount() / 1000.0;
            placeable = amount / mode.getMultiplier();
            placeable = (double)((int)(placeable * 100.0)) / 100.0;
        }
        return placeable;
    }

    public static ItemStack extractBlocks(ItemStack stack, int maxCount, boolean execute) {
        if (!stack.func_190926_b() && maxCount > 0) {
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            FluidStack fluidStack = ItemCloudStaff.getFluid(stack);
            double amount = fluidStack.isEmpty() ? 0.0 : (double)fluidStack.getAmount() / 1000.0;
            double placeable = amount / mode.getMultiplier();
            if ((placeable = (double)((int)(placeable * 100.0)) / 100.0) >= 1.0) {
                int count = Math.min((int)placeable, maxCount);
                if (execute) {
                    fluidStack.shrink((int)((double)count * mode.getMultiplier() * 1000.0));
                    ItemCloudStaff.setFluid(stack, fluidStack);
                }
                switch (mode) {
                    case VAPOR: {
                        return new ItemStack((IItemProvider)Values.blockWaterVapor, count);
                    }
                    case LIGHT: {
                        return new ItemStack((IItemProvider)Values.blockClouds.get((Object)CloudAPI.CloudType.LIGHT), count);
                    }
                    case DENSE: {
                        return new ItemStack((IItemProvider)Values.blockClouds.get((Object)CloudAPI.CloudType.DENSE), count);
                    }
                    case STORM: {
                        return new ItemStack((IItemProvider)Values.blockClouds.get((Object)CloudAPI.CloudType.STORM), count);
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (!stack.func_190926_b()) {
            String[] text;
            EnumMode mode = ItemCloudStaff.getEnumMode(stack);
            for (String line : text = String.format(Localization.get((String)"msg.terraqueous.cloudstaff.placing.txt"), Localization.get((String)mode.getTooltip()), ItemCloudStaff.getBlockCount(stack)).split("<br>")) {
                tooltip.add((ITextComponent)new StringTextComponent(line));
            }
            tooltip.add(Localization.getTextComponent((String)"info.terraqueous.cloudstaff.mode.txt"));
        }
    }

    public static class CloudStaffFluidHandlerItemStack
    extends FluidHandlerItemStack {
        public CloudStaffFluidHandlerItemStack(ItemStack container) {
            super(container, 1024000);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid().equals(Fluids.field_204546_a);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return false;
        }
    }

    public static enum EnumMode {
        VAPOR(0, 0.25, "block.terraqueous.vapor_block"),
        LIGHT(1, 1.0, "block.terraqueous.light_cloud"),
        DENSE(2, 4.0, "block.terraqueous.dense_cloud"),
        STORM(3, 16.0, "block.terraqueous.storm_cloud");

        private static EnumMode[] array;
        private static final Map<String, EnumMode> map;
        private final byte value;
        private final double multiplier;
        private final String tooltip;

        private EnumMode(int value, double multiplier, String tooltip) {
            this.value = (byte)value;
            this.multiplier = multiplier;
            this.tooltip = tooltip;
        }

        public byte getValue() {
            return this.value;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public static EnumMode byValue(int value) {
            return array[value < 0 ? 3 : (value > 3 ? 0 : value)];
        }

        public static EnumMode byName(String name) {
            name = name.toLowerCase().trim();
            return map.getOrDefault(name, VAPOR);
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumMode>();
            array = new EnumMode[EnumMode.values().length];
            EnumMode[] enumModeArray = EnumMode.values();
            int n = enumModeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumMode value;
                EnumMode.array[value.getValue()] = value = enumModeArray[i];
                map.put(value.toString(), value);
            }
        }
    }
}

