/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.client.gui.GuiColorizer;

public class ItemColorizer
extends Item
implements IRGB16_Item {
    private static final Map<ResourceLocation, ResourceLocation> MAP_CLASS_LOOKUP = new HashMap<ResourceLocation, ResourceLocation>();
    private static final int maxCharge = 512;

    public ItemColorizer(Item.Properties builder) {
        super(builder);
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78040_i || super.func_194125_a(group);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        ItemStack stack;
        if (super.func_194125_a(group)) {
            stack = new ItemStack((IItemProvider)this);
            this.addCharge(stack, 0);
            list.add((Object)stack.func_77946_l());
        }
        if (this.func_194125_a(group)) {
            stack = new ItemStack((IItemProvider)this);
            this.addCharge(stack, 512);
            list.add((Object)stack);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    private void addCharge(ItemStack stack, int value) {
        int charge = this.getCharge(stack) + value;
        stack.func_196082_o().func_74777_a("charge", (short)MathHelper.func_76125_a((int)charge, (int)0, (int)512));
    }

    private short getCharge(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("charge")) {
            nbt.func_74777_a("charge", (short)0);
        }
        return (short)MathHelper.func_76125_a((int)nbt.func_74765_d("charge"), (int)0, (int)512);
    }

    private void useCharge(ItemStack stack) {
        this.addCharge(stack, -1);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getCharge(stack) > 0 ? 1.0 - (double)this.getCharge(stack) / 512.0 : 1.0;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        ItemStack dye;
        if (this.getCharge(stack) > 0 && (dye = new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)this.getDyeColor(stack)))).func_77973_b().func_111207_a(dye, player, target, hand)) {
            this.useCharge(stack);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184609_a(hand);
        RayTraceResult mop = ItemColorizer.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openGUI(stack));
        } else {
            this.addCharge(stack, 4);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUI(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemColorizer) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiColorizer(stack));
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        boolean success;
        boolean bl = success = this.func_195939_a(context) == ActionResultType.SUCCESS;
        if (success && context.func_195991_k().field_72995_K) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientPlayNetHandler handler = Minecraft.func_71410_x().func_147114_u();
                if (handler != null) {
                    BlockRayTraceResult result = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k());
                    handler.func_147297_a((IPacket)new CPlayerTryUseItemOnBlockPacket(context.func_221531_n(), result));
                }
            });
        }
        return success ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        int used = 0;
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            Direction facing;
            ItemStack stack = context.func_195996_i();
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            if (!player.func_175151_a(pos.func_177972_a(facing = context.func_196000_l()), facing, stack)) {
                return ActionResultType.FAIL;
            }
            if (player.func_70093_af()) {
                short index;
                if ((this.getCharge(stack) > 1 || player.field_71075_bZ.field_75098_d) && (index = ItemColorizer.getBlockColorIndex(world, pos, player)) > -1 && this.setRGB16(stack, index)) {
                    used = 2;
                }
            } else if ((this.getCharge(stack) > 3 || player.field_71075_bZ.field_75098_d) && ItemColorizer.setBlockColor(world, pos, player, facing, this.getRGB16(stack))) {
                used = 4;
            }
            if (used > 0 && !player.field_71075_bZ.field_75098_d) {
                this.addCharge(stack, -used);
            }
        }
        return used > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public static void buildClassLookUpMap(List<? extends String> list) {
        MAP_CLASS_LOOKUP.clear();
        list.listIterator().forEachRemaining(entry -> {
            try {
                String[] values = entry.split(":");
                ResourceLocation baseBlock = new ResourceLocation(values[0], values[1]);
                ResourceLocation colorBlock = new ResourceLocation(values[0], values[2].replace("*", "white"));
                MAP_CLASS_LOOKUP.put(baseBlock, colorBlock);
            }
            catch (Exception ignored) {
                Terraqueous.LOGGER.error("Couldn't process Colorizer class mapping '" + entry + "'");
            }
        });
    }

    public static boolean setBlockColor(World world, BlockPos pos, PlayerEntity player, Direction side, short index) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRGB16_Tile) {
            return ((IRGB16_Tile)tile).setRGB16(index, player);
        }
        DyeColor colorizerColor = DyeColor.func_196056_a((int)RGB16Helper.getSimpleColor((short)index));
        BlockState state = world.func_180495_p(pos);
        if (state.recolorBlock((IWorld)world, pos, side, colorizerColor)) {
            return true;
        }
        Block block = state.func_177230_c();
        ResourceLocation registryName = block.getRegistryName();
        if (registryName != null) {
            String dyeName;
            String[] specials;
            ResourceLocation altName;
            Block newBlock;
            if (MAP_CLASS_LOOKUP.containsKey(registryName) && (newBlock = (Block)ForgeRegistries.BLOCKS.getValue(altName = MAP_CLASS_LOOKUP.get(registryName))) != null) {
                registryName = altName;
                block = newBlock;
                state = ItemColorizer.copyProperties(state, newBlock);
            }
            String modId = registryName.func_110624_b();
            String blockName = registryName.func_110623_a();
            String trimmed = "";
            for (String string : specials = new String[]{"light_blue", "lightblue", "light_gray", "lightgray", "silver"}) {
                if (!blockName.contains(string)) continue;
                trimmed = blockName.replace(string, "<dye>");
            }
            if (Strings.isNullOrEmpty((String)trimmed)) {
                for (String string : DyeColor.values()) {
                    String dyeName3 = string.func_176762_d();
                    if (string == DyeColor.LIGHT_BLUE || string == DyeColor.LIGHT_GRAY || !blockName.contains(dyeName3)) continue;
                    trimmed = blockName.replace(dyeName3, "<dye>");
                }
            }
            if (Strings.isNullOrEmpty((String)trimmed)) {
                boolean atStart = true;
                boolean hasUnderscore = true;
                Block finder = ItemColorizer.getBlock(modId, "white_" + blockName);
                if (finder == null) {
                    hasUnderscore = false;
                    finder = ItemColorizer.getBlock(modId, "white" + blockName);
                    if (finder == null) {
                        atStart = false;
                        hasUnderscore = true;
                        finder = ItemColorizer.getBlock(modId, blockName + "_white");
                        if (finder == null) {
                            hasUnderscore = false;
                            finder = ItemColorizer.getBlock(modId, blockName + "white");
                        }
                    }
                }
                if (finder != null) {
                    trimmed = (atStart ? (hasUnderscore ? "<dye>_" : "<dye>") : "") + blockName + (!atStart ? (hasUnderscore ? "_<dye>" : "<dye>") : "");
                    block = finder;
                    state = ItemColorizer.copyProperties(state, finder);
                }
            }
            Object newBlock2 = null;
            if (!Strings.isNullOrEmpty((String)trimmed) && (newBlock2 = ItemColorizer.getBlock(modId, trimmed.replace("<dye>", dyeName = colorizerColor.func_176762_d()))) == null) {
                if (colorizerColor == DyeColor.LIGHT_BLUE) {
                    newBlock2 = ItemColorizer.getBlock(modId, trimmed.replace("<dye>", "lightblue"));
                } else if (colorizerColor == DyeColor.LIGHT_GRAY && (newBlock2 = ItemColorizer.getBlock(modId, trimmed.replace("<dye>", "lightgray"))) == null) {
                    newBlock2 = ItemColorizer.getBlock(modId, trimmed.replace("<dye>", "silver"));
                }
            }
            if (newBlock2 != null && newBlock2.getClass().equals(block.getClass())) {
                BlockState newState = ItemColorizer.copyProperties(state, (Block)newBlock2);
                CompoundNBT tiletag = new CompoundNBT();
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity != null) {
                    tileEntity.func_189515_b(tiletag);
                }
                if (Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)newState, (!(state.func_177230_c() instanceof BedBlock) ? 1 : 0) != 0)) {
                    TileEntity tileEntity2 = world.func_175625_s(pos);
                    if (tileEntity2 != null) {
                        tileEntity2.func_145839_a(tiletag);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static Block getBlock(String modId, String blockId) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, blockId));
        return block != null && !Objects.equals(block.getRegistryName(), ForgeRegistries.BLOCKS.getDefaultKey()) ? block : null;
    }

    private static BlockState copyProperties(BlockState original, Block block) {
        BlockState newState = block.func_176223_P();
        for (IProperty prop : newState.func_206869_a()) {
            if (!original.func_196959_b(prop)) continue;
            newState = (BlockState)newState.func_206870_a(prop, original.func_177229_b(prop));
        }
        return newState;
    }

    public static short getBlockColorIndex(World world, BlockPos pos, PlayerEntity player) {
        RGB16 rgb16;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRGB16_Tile && (rgb16 = ((IRGB16_Tile)tile).getRGB16(player)) != null) {
            return rgb16.getIndex();
        }
        BlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_206869_a()) {
            if (!prop.func_177701_a().equals("color") || prop.func_177699_b() != DyeColor.class) continue;
            DyeColor color = (DyeColor)state.func_177229_b(prop);
            return RGB16Helper.getIndexFor((DyeColor)color);
        }
        Block block = state.func_177230_c();
        ResourceLocation registryName = block.getRegistryName();
        if (registryName != null) {
            String blockName = registryName.func_110623_a();
            if (blockName.contains("light_blue") || blockName.contains("lightblue")) {
                return RGB16Helper.getIndexFor((DyeColor)DyeColor.LIGHT_BLUE);
            }
            if (blockName.contains("light_gray") || blockName.contains("lightgray") || blockName.contains("silver")) {
                return RGB16Helper.getIndexFor((DyeColor)DyeColor.LIGHT_GRAY);
            }
            for (DyeColor dyeColor : DyeColor.values()) {
                if (dyeColor == DyeColor.LIGHT_BLUE || dyeColor == DyeColor.LIGHT_GRAY || !blockName.contains(dyeColor.func_176762_d())) continue;
                return RGB16Helper.getIndexFor((DyeColor)dyeColor);
            }
        }
        return RGB16Helper.getIndexFor((int)state.func_185904_a().func_151565_r().field_76291_p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(Localization.getTextComponent((String)"info.terraqueous.shakepowered.txt"));
        String colorInfo = RGB16Helper.getTooltip((short)this.getRGB16(stack)) + "\u00a77 - ";
        DyeColor dye = this.getDyeColor(stack);
        colorInfo = colorInfo + "\u00a7" + ItemColorizer.getFormatCode(dye) + Localization.get((String)dye.func_176762_d());
        tooltip.add((ITextComponent)new StringTextComponent(colorInfo));
    }

    public static char getFormatCode(DyeColor color) {
        switch (color) {
            case WHITE: {
                return 'f';
            }
            case ORANGE: {
                return '6';
            }
            case MAGENTA: {
                return '5';
            }
            case LIGHT_BLUE: {
                return 'b';
            }
            case YELLOW: {
                return 'e';
            }
            case LIME: {
                return 'a';
            }
            case PINK: {
                return 'd';
            }
            case GRAY: {
                return '8';
            }
            case LIGHT_GRAY: {
                return '7';
            }
            case CYAN: {
                return '3';
            }
            case PURPLE: {
                return '5';
            }
            case BLUE: {
                return '9';
            }
            case BROWN: {
                return '6';
            }
            case GREEN: {
                return '2';
            }
            case RED: {
                return '4';
            }
            case BLACK: {
                return '8';
            }
        }
        return 'f';
    }

    public short getRGB16(ItemStack stack) {
        return RGB16StackHelper.readColorTag((ItemStack)stack);
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    private DyeColor getDyeColor(ItemStack stack) {
        return DyeColor.func_196056_a((int)RGB16StackHelper.readSimpleColorTag((ItemStack)stack));
    }

    public void setRGB16Preset(ItemStack stack, int preset, short rgbIndex, String name) {
        preset = MathHelper.func_76125_a((int)preset, (int)0, (int)17);
        CompoundNBT nbt = stack.func_196082_o();
        ListNBT tagList = this.getNBTTagList(stack);
        CompoundNBT tagPresets = new CompoundNBT();
        tagPresets.func_74777_a("rgb16", rgbIndex);
        tagPresets.func_74778_a("name", name);
        tagList.set(preset, (INBT)tagPresets);
        nbt.func_218657_a("rgb16presets", (INBT)tagList);
    }

    public ListNBT getNBTTagList(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("rgb16presets")) {
            ListNBT tagList = new ListNBT();
            short white = RGB16Helper.getIndexFor((String)"white");
            for (int index = 0; index < 18; index = (int)((byte)(index + 1))) {
                CompoundNBT tagPresets = new CompoundNBT();
                tagPresets.func_74777_a("rgb16", white);
                tagPresets.func_74778_a("name", "\u00a7o<not set>");
                tagList.add((Object)tagPresets);
            }
            nbt.func_218657_a("rgb16presets", (INBT)tagList);
        }
        return nbt.func_150295_c("rgb16presets", 10);
    }
}

