/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.internal.Strings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemScythe
extends ItemToolWithDamageSource
implements IToolMode {
    public ItemScythe(Item.Properties properties) {
        super(3.0f, -1.0f, (IItemTier)ItemTier.IRON, Values.damageScythe, properties);
        this.func_185043_a(new ResourceLocation("mode"), (stack, world, entity) -> ItemScythe.isSickle(stack) ? 1.0f : 0.0f);
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78040_i || super.func_194125_a(group);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)ItemScythe.newScythe(true));
            list.add((Object)ItemScythe.newScythe(false));
        }
    }

    public static ItemStack newScythe(boolean sickle) {
        ItemStack stack = new ItemStack((IItemProvider)Values.itemScythe);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74757_a("sickle", sickle);
        return stack;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof IPlantable || BlockTags.field_206952_E.func_199685_a_((Object)block) ? this.field_77864_a : 1.0f;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + (ItemScythe.isSickle(stack) ? "small" : "large");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            Localization.multiLineTooltip((String)"msg.terraqueous.scythe.shift.txt", tooltip);
            tooltip.add(Localization.getTextComponent((String)"info.terraqueous.scythe.mode.txt"));
            Localization.multiLineTooltip((String)("msg.terraqueous.scythe.mode." + (Object)((Object)ItemScythe.getMode(stack)) + ".txt"), tooltip);
        } else {
            if (ItemScythe.isSickle(stack)) {
                tooltip.add(Localization.getTextComponent((String)"info.terraqueous.scythe.small.txt"));
            } else {
                tooltip.add(Localization.getTextComponent((String)"info.terraqueous.scythe.large.txt"));
            }
            tooltip.add(Localization.getTextComponent((String)"info.shetiphian.holdshift.txt"));
        }
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
    }

    public static boolean isSickle(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("sickle")) {
            nbt.func_74757_a("sickle", false);
        }
        return nbt.func_74767_n("sickle");
    }

    private static HarvestMode getMode(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b("mode")) {
            nbt.func_74778_a("mode", "all");
        }
        return HarvestMode.fromName(nbt.func_74779_i("mode"));
    }

    @Override
    public boolean changeMode(PlayerEntity player, ItemStack stack, boolean reverse) {
        if (stack != null && stack.func_77973_b() instanceof ItemScythe) {
            HarvestMode mode = ItemScythe.getMode(stack).next(reverse);
            stack.func_196082_o().func_74778_a("mode", mode.toString());
            if (player != null) {
                String message = Localization.get((String)"info.terraqueous.scythe.modechanged.txt") + Localization.get((String)("msg.terraqueous.scythe.mode." + mode.toString() + ".txt")).replace("<br>", " ");
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChatPacket((ITextComponent)new StringTextComponent(message), ChatType.GAME_INFO));
                } else {
                    Localization.addChat((PlayerEntity)player, (String)message);
                }
            }
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && !player.func_70093_af()) {
            stack.func_196082_o().func_74757_a("sickle", !ItemScythe.isSickle(stack));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private void doExtraDrops(PlayerEntity player, ItemStack stack, ServerWorld world, BlockPos pos, Block block, BlockState state) {
        if (player.field_71075_bZ.field_75098_d || ItemScythe.isSickle(stack)) {
            return;
        }
        ResourceLocation location = block.getRegistryName();
        if (block instanceof TallGrassBlock || block instanceof DoublePlantBlock && location != null && location.func_110623_a().contains("grass")) {
            ItemStack shears = new ItemStack((IItemProvider)Items.field_151097_aZ);
            EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)stack), (ItemStack)shears);
            List drops = Block.func_220077_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos), (Entity)player, (ItemStack)shears);
            for (ItemStack drop : drops) {
                Function.dropItem((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Block block = state.func_177230_c();
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack.func_77952_i() + 1 >= stack.func_77958_k() && stack.func_77948_v()) {
                return false;
            }
            if (world instanceof ServerWorld) {
                this.doExtraDrops(player, stack, (ServerWorld)world, pos, block, state);
            }
        }
        boolean leaves = BlockTags.field_206952_E.func_199685_a_((Object)block);
        boolean plant = block instanceof IPlantable;
        if (!leaves && !plant) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        int level = (int)player.field_70163_u + (player.func_70093_af() ? 0 : 1);
        boolean isSickle = ItemScythe.isSickle(stack);
        if (isSickle && pos.func_177956_o() < level || !isSickle && pos.func_177956_o() > level) {
            return false;
        }
        HarvestMode mode = ItemScythe.getMode(stack);
        boolean used = false;
        int swingW = ItemScythe.isSickle(stack) ? 1 : 3;
        int swingD = ItemScythe.isSickle(stack) ? 1 : 2;
        for (int sX = -swingW; sX <= swingW; ++sX) {
            for (int sY = -swingD; sY <= swingD; ++sY) {
                for (int sZ = -swingW; sZ <= swingW; ++sZ) {
                    if (sX == 0 && sY == 0 && sZ == 0) continue;
                    BlockPos sPos = pos.func_177982_a(sX, sY, sZ);
                    BlockState sState = world.func_180495_p(sPos);
                    Block sBlock = sState.func_177230_c();
                    if (!sState.canHarvestBlock((IBlockReader)world, sPos, player)) continue;
                    boolean harvest = false;
                    boolean sLeaves = BlockTags.field_206952_E.func_199685_a_((Object)sBlock);
                    boolean sPlant = sBlock instanceof IPlantable;
                    if (sLeaves || sPlant) {
                        block0 : switch (mode) {
                            case ALL: {
                                harvest = true;
                                break;
                            }
                            case TYPE: {
                                harvest = leaves && sLeaves || plant && sPlant;
                                break;
                            }
                            case BLOCK: {
                                harvest = sBlock == block;
                                break;
                            }
                            case STATE: {
                                harvest = sBlock == block && sState == state;
                                break;
                            }
                            case TAG: {
                                Set tags = block.getTags();
                                for (ResourceLocation tag : sBlock.getTags()) {
                                    if (!tags.contains(tag)) continue;
                                    harvest = true;
                                    break block0;
                                }
                                break;
                            }
                        }
                    }
                    if (!harvest) continue;
                    if (world instanceof ServerWorld) {
                        this.doExtraDrops(player, stack, (ServerWorld)world, sPos, sBlock, sState);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        sBlock.func_180657_a(world, player, sPos, sState, world.func_175625_s(sPos), stack);
                        used = true;
                    }
                    sState.removedByPlayer(world, sPos, player, true, world.func_204610_c(sPos));
                }
            }
        }
        if (used) {
            stack.func_222118_a(1, entity, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return used;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity victim) {
        ItemStack offhand;
        if (stack.func_77952_i() + 2 >= stack.func_77958_k() && stack.func_77948_v()) {
            return true;
        }
        if (ItemScythe.isSickle(stack) && !(offhand = player.func_184592_cb()).func_190926_b() && offhand.func_77973_b() instanceof ItemScythe && ItemScythe.isSickle(offhand) && offhand.func_77952_i() + 2 < offhand.func_77958_k()) {
            ItemStack bonus = ItemScythe.newScythe(true);
            bonus.func_77966_a(Enchantments.field_185302_k, 1 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)offhand));
            boolean result = ItemToolWithDamageSource.onLeftClickEntity((PlayerEntity)player, (Entity)victim, (MyDamageSource)Values.damageScythe, (ItemStack)bonus);
            if (result && !player.field_71075_bZ.field_75098_d) {
                offhand.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.OFFHAND));
            }
            return result;
        }
        return super.onLeftClickEntity(stack, player, victim);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, MathHelper.func_76125_a((int)damage, (int)0, (int)this.getMaxDamage(stack)));
    }

    private static enum HarvestMode {
        ALL,
        TYPE,
        BLOCK,
        STATE,
        TAG;


        private HarvestMode next(boolean reverse) {
            switch (this) {
                case ALL: {
                    return reverse ? TAG : TYPE;
                }
                case TYPE: {
                    return reverse ? ALL : BLOCK;
                }
                case BLOCK: {
                    return reverse ? TYPE : STATE;
                }
                case STATE: {
                    return reverse ? BLOCK : TAG;
                }
                case TAG: {
                    return reverse ? STATE : ALL;
                }
            }
            return ALL;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        private static HarvestMode fromName(String name) {
            if (!Strings.isNullOrEmpty((String)name)) {
                for (HarvestMode mode : HarvestMode.values()) {
                    if (!mode.toString().equals(name)) continue;
                    return mode;
                }
            }
            return ALL;
        }
    }
}

