/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.item.ItemMultiTool;

public class MultiToolLootHandler
extends LootModifier {
    protected MultiToolLootHandler(ILootCondition[] conditions) {
        super(conditions);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemMultiTool.EnumType type;
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null && tool.func_77973_b() instanceof ItemMultiTool && (type = ItemMultiTool.getEnumType(tool)) != ItemMultiTool.EnumType.BROKEN) {
            Object processed;
            boolean hasSilkTouch;
            Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
            ServerWorld world = context.func_202879_g();
            boolean bl = hasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0;
            if (!hasSilkTouch && type == ItemMultiTool.EnumType.PICKAXE) {
                processed = new ArrayList();
                generatedLoot.forEach(arg_0 -> MultiToolLootHandler.lambda$doApply$0((ArrayList)processed, entity, world, tool, arg_0));
                generatedLoot = processed;
            }
            if (entity != null && !generatedLoot.isEmpty()) {
                processed = generatedLoot.iterator();
                while (processed.hasNext()) {
                    ItemStack drop = (ItemStack)processed.next();
                    if (entity instanceof PlayerEntity) {
                        Function.giveItem((PlayerEntity)((PlayerEntity)entity), (ItemStack)drop, null);
                        continue;
                    }
                    Function.dropItem((World)world, (BlockPos)new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), (ItemStack)drop);
                }
                BlockPos pos = (BlockPos)context.func_216031_c(LootParameters.field_216286_f);
                if (pos != null) {
                    for (int i = 0; i < 5; ++i) {
                        double rX = world.field_73012_v.nextGaussian() * 0.02;
                        double rY = world.field_73012_v.nextGaussian() * 0.02;
                        double rZ = world.field_73012_v.nextGaussian() * 0.02;
                        world.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 1, rX, rY, rZ, (double)0.15f);
                    }
                }
                return new ArrayList<ItemStack>();
            }
        }
        return generatedLoot;
    }

    private static ItemStack smelt(ItemStack stack, Entity entity, World world, ItemStack tool) {
        ItemStack smelted;
        int fortuneBase = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        FurnaceRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), world).orElse(null);
        if (recipe != null && !(smelted = recipe.func_77571_b().func_77946_l()).func_190926_b()) {
            int multiplier = stack.func_190916_E();
            if (Tags.Items.INGOTS.func_199685_a_((Object)smelted.func_77973_b())) {
                int fortuneRemaining = fortuneBase;
                int attempt = 0;
                while ((double)attempt < Math.ceil((double)fortuneBase / 3.0)) {
                    int chance = ((double)fortuneRemaining >= 3.0 ? 3 : fortuneRemaining) * 3;
                    if (chance > world.field_73012_v.nextInt(10) + 1) {
                        smelted.func_190917_f(smelted.func_190916_E());
                    }
                    fortuneRemaining -= 3;
                    ++attempt;
                }
            }
            smelted.func_190920_e(smelted.func_190916_E() * multiplier);
            if (entity != null && recipe.func_222138_b() > 0.0f) {
                world.func_217376_c((Entity)new ExperienceOrbEntity(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (int)(recipe.func_222138_b() * (float)multiplier)));
            }
            return smelted;
        }
        return stack;
    }

    private static /* synthetic */ void lambda$doApply$0(ArrayList processed, Entity entity, ServerWorld world, ItemStack tool, ItemStack stack) {
        processed.add(MultiToolLootHandler.smelt(stack, entity, (World)world, tool));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<MultiToolLootHandler> {
        public MultiToolLootHandler read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            return new MultiToolLootHandler(conditionsIn);
        }
    }
}

