/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.misc.IInteractionHandler;

public class BlueFlowerHandler
implements IInteractionHandler {
    public static BlueFlowerHandler INSTANCE = new BlueFlowerHandler();
    public static final List<String> DEFAULTS = BlueFlowerHandler.getDefaults();
    private static final List<EffectEntry> EFFECTS = new ArrayList<EffectEntry>();
    private static long TRANSMUTE_DELAY;
    private final Random rand = new Random();
    private final HashMap<UUID, Short> blueFlower = new HashMap();

    private static List<String> getDefaults() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("effect[minecraft:speed];time[30-60];level[0-1]");
        list.add("effect[minecraft:slowness];time[10-20];level[0-1]");
        list.add("effect[minecraft:haste];time[60-120];level[0-1]");
        list.add("effect[minecraft:mining_fatigue];time[60-120];level[0-1]");
        list.add("effect[minecraft:strength];time[60-120];level[0-1]");
        list.add("effect[minecraft:jump_boost];time[60-120];level[0-1]");
        list.add("effect[minecraft:nausea];time[10];level[0]");
        list.add("effect[minecraft:regeneration];time[10-30];level[0-1]");
        list.add("effect[minecraft:resistance];time[60-120];level[0-1]");
        list.add("effect[minecraft:fire_resistance];time[150-300];level[0-1]");
        list.add("effect[minecraft:water_breathing];time[150-300];level[0-1]");
        list.add("effect[minecraft:invisibility];time[60-300];level[0-1]");
        list.add("effect[minecraft:blindness];time[30-60];level[0-1]");
        list.add("effect[minecraft:night_vision];time[60-120];level[0-1]");
        list.add("effect[minecraft:hunger];time[10-30];level[0-1]");
        list.add("effect[minecraft:weakness];time[10-20];level[0-1]");
        list.add("effect[minecraft:poison];time[5-10];level[0]");
        list.add("effect[minecraft:wither];time[3-5];level[0]");
        list.add("effect[minecraft:absorption];time[30-60];level[0-1]");
        list.add("effect[minecraft:saturation];time[15-30];level[0-1]");
        list.add("effect[minecraft:glowing];time[30-60];level[0-1]");
        list.add("effect[minecraft:levitation];time[2-3];level[0]");
        list.add("effect[minecraft:luck];time[30-60];level[0-1]");
        list.add("effect[minecraft:unluck];time[20-40];level[0-1]");
        list.add("effect[minecraft:slow_falling];time[15-30];level[0-1]");
        list.add("effect[minecraft:conduit_power];time[90-180];level[0-1]");
        list.add("effect[minecraft:dolphins_grace];time[30-60];level[0-1]");
        list.add("effect[minecraft:hero_of_the_village];time[120];level[2-4]");
        return list;
    }

    public void buildList(List<String> list) {
        EFFECTS.clear();
        for (String entry : list) {
            int[] level;
            int[] time;
            String[] groups = new String[3];
            for (String string : entry.split(";")) {
                if (string.toLowerCase().startsWith("effect")) {
                    groups[0] = string.substring(7, string.length() - 1);
                    continue;
                }
                if (string.toLowerCase().startsWith("time")) {
                    groups[1] = string.substring(5, string.length() - 1);
                    continue;
                }
                if (!string.toLowerCase().startsWith("level")) continue;
                groups[2] = string.substring(6, string.length() - 1);
            }
            try {
                time = this.getValues(groups[1]);
                level = this.getValues(groups[2]);
            }
            catch (Exception ignored) {
                Terraqueous.LOGGER.error("Skipping invalid listTricksterBloomEffects entry: " + entry);
                continue;
            }
            EFFECTS.add(new EffectEntry(groups[0].contains(":") ? groups[0] : "minecraft:" + groups[0], time, level));
        }
    }

    private int[] getValues(String input) {
        int[] numbers = new int[2];
        String[] split = input.split("-");
        numbers[0] = Integer.parseInt(split[0]);
        numbers[1] = split.length > 1 ? Integer.parseInt(split[1]) : numbers[0];
        return numbers;
    }

    @Override
    public boolean onEntityCollision(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            INSTANCE.blueAdd((PlayerEntity)entity);
            return true;
        }
        return false;
    }

    @Override
    public Effect getStewEffect(Block block) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            EffectEntry pick = this.getRandomEntry();
            if (pick == null || pick.getEffect().func_220303_e() == EffectType.HARMFUL) continue;
            return pick.getEffect();
        }
        return this.rand.nextBoolean() ? Effects.field_188425_z : (this.rand.nextBoolean() ? Effects.field_76441_p : Effects.field_204839_B);
    }

    @Override
    public int getStewEffectDuration(Block block) {
        return this.rand.nextInt(5) + 5;
    }

    public void blueAdd(PlayerEntity player) {
        UUID uuid;
        if (!(player.func_130014_f_().field_72995_K || EFFECTS.isEmpty() || this.blueFlower.containsKey(uuid = player.func_110124_au()))) {
            short delay = (short)((this.rand.nextInt(90) + 30) * 20);
            this.blueFlower.put(uuid, delay);
        }
    }

    private EffectEntry getRandomEntry() {
        EffectEntry pick = EFFECTS.get(this.rand.nextInt(EFFECTS.size()));
        if (pick.getEffect() != null) {
            return pick;
        }
        EFFECTS.remove(pick);
        return null;
    }

    public void blueUpdate(PlayerEntity player) {
        UUID uuid;
        if (!player.func_130014_f_().field_72995_K && !EFFECTS.isEmpty() && this.blueFlower.containsKey(uuid = player.func_110124_au())) {
            short value = this.blueFlower.get(uuid);
            if (value > 0) {
                value = (short)(value - 1);
                this.blueFlower.put(uuid, value);
                return;
            }
            this.blueFlower.remove(uuid);
            EffectEntry pick = this.getRandomEntry();
            if (pick != null) {
                player.func_195064_c(new EffectInstance(pick.getEffect(), pick.getTime(this.rand), pick.getLevel(this.rand)));
            }
        }
    }

    public void mobTransmute(Entity entity, boolean toHostile) {
        if (entity != null && !entity.field_70170_p.field_72995_K && entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
            if (TRANSMUTE_DELAY > System.currentTimeMillis()) {
                return;
            }
            TRANSMUTE_DELAY = System.currentTimeMillis() + 20L;
            Entity entityNew = toHostile ? this.getHostileMobTransmute(entity) : this.getNeutralMobTransmute(entity);
            if (entityNew != null) {
                entity.func_70106_y();
                entityNew.field_70170_p.func_217376_c(entityNew);
            }
        }
    }

    private Entity getHostileMobTransmute(Entity entity) {
        if (entity.func_145818_k_() || entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()) {
            return null;
        }
        EndermanEntity entityNew = null;
        if (entity instanceof SheepEntity) {
            entityNew = this.rand.nextInt(3) == 0 ? new CaveSpiderEntity(EntityType.field_200794_h, entity.field_70170_p) : new SpiderEntity(EntityType.field_200748_an, entity.field_70170_p);
        } else if (entity instanceof RabbitEntity) {
            entityNew = new EndermanEntity(EntityType.field_200803_q, entity.field_70170_p);
        } else if (entity instanceof OcelotEntity) {
            entityNew = new CreeperEntity(EntityType.field_200797_k, entity.field_70170_p);
        } else if (entity instanceof WolfEntity) {
            entityNew = this.rand.nextInt(3) == 0 ? new WitherSkeletonEntity(EntityType.field_200722_aA, entity.field_70170_p) : new SkeletonEntity(EntityType.field_200741_ag, entity.field_70170_p);
        } else if (entity instanceof PigEntity) {
            entityNew = new ZombiePigmanEntity(EntityType.field_200785_Y, entity.field_70170_p);
        } else if (entity instanceof ChickenEntity) {
            entityNew = new ZombieEntity(EntityType.field_200725_aD, entity.field_70170_p);
        } else if (entity instanceof CowEntity) {
            entityNew = new SlimeEntity(EntityType.field_200743_ai, entity.field_70170_p);
        } else if (entity instanceof BatEntity) {
            entityNew = this.rand.nextBoolean() ? new EndermiteEntity(EntityType.field_200804_r, entity.field_70170_p) : new SilverfishEntity(EntityType.field_200740_af, entity.field_70170_p);
        } else if (entity instanceof VillagerEntity) {
            if (this.rand.nextInt(3) == 0) {
                entityNew = new WitchEntity(EntityType.field_200759_ay, entity.field_70170_p);
            } else {
                entityNew = new ZombieVillagerEntity(EntityType.field_200727_aF, entity.field_70170_p);
                ((ZombieVillagerEntity)entityNew).func_213792_a(((VillagerEntity)entity).func_213700_eh());
            }
        }
        if (entityNew != null) {
            entityNew.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }
        return entityNew;
    }

    private Entity getNeutralMobTransmute(Entity entity) {
        if (entity.func_145818_k_() || entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()) {
            return null;
        }
        SheepEntity entityNew = null;
        if (entity instanceof CaveSpiderEntity || entity instanceof SpiderEntity) {
            entityNew = new SheepEntity(EntityType.field_200737_ac, entity.field_70170_p);
        } else if (entity instanceof EndermanEntity) {
            entityNew = new RabbitEntity(EntityType.field_200736_ab, entity.field_70170_p);
        } else if (entity instanceof CreeperEntity) {
            entityNew = new OcelotEntity(EntityType.field_200781_U, entity.field_70170_p);
        } else if (entity instanceof AbstractSkeletonEntity) {
            entityNew = new WolfEntity(EntityType.field_200724_aC, entity.field_70170_p);
        } else if (entity instanceof ZombiePigmanEntity) {
            entityNew = new PigEntity(EntityType.field_200784_X, entity.field_70170_p);
        } else if (entity instanceof ZombieVillagerEntity) {
            entityNew = new VillagerEntity(EntityType.field_200756_av, entity.field_70170_p);
            ((VillagerEntity)entityNew).func_213753_a(((ZombieVillagerEntity)entity).func_213700_eh());
        } else if (entity instanceof ZombieEntity) {
            entityNew = new ChickenEntity(EntityType.field_200795_i, entity.field_70170_p);
        } else if (entity instanceof SlimeEntity) {
            if (this.rand.nextInt(3) == 0) {
                entityNew = new MooshroomEntity(EntityType.field_200780_T, entity.field_70170_p);
                if (this.rand.nextInt(3) == 0) {
                    CompoundNBT nbt = new CompoundNBT();
                    entityNew.func_213281_b(nbt);
                    nbt.func_74778_a("Type", "brown");
                    entityNew.func_70037_a(nbt);
                }
            } else {
                entityNew = new CowEntity(EntityType.field_200796_j, entity.field_70170_p);
            }
        } else if (entity instanceof SilverfishEntity || entity instanceof EndermiteEntity) {
            entityNew = new BatEntity(EntityType.field_200791_e, entity.field_70170_p);
        } else if (entity instanceof WitchEntity) {
            entityNew = new VillagerEntity(EntityType.field_200756_av, entity.field_70170_p);
        }
        if (entityNew != null) {
            entityNew.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }
        return entityNew;
    }

    private static class EffectEntry {
        private final String name;
        private final short tBase;
        private final short tAdd;
        private final byte lBase;
        private final byte lAdd;
        private Effect effect;

        EffectEntry(String name, int[] time, int[] level) {
            this.name = name;
            this.tBase = (short)MathHelper.func_76125_a((int)Math.min(time[0], time[1]), (int)0, (int)Short.MAX_VALUE);
            this.tAdd = (short)MathHelper.func_76125_a((int)(Math.max(time[0] - time[1], time[1] - time[0]) + 1), (int)1, (int)Short.MAX_VALUE);
            this.lBase = (byte)MathHelper.func_76125_a((int)Math.min(level[0], level[1]), (int)0, (int)127);
            this.lAdd = (byte)MathHelper.func_76125_a((int)(Math.max(level[0] - level[1], level[1] - level[0]) + 1), (int)1, (int)127);
        }

        int getTime(Random rand) {
            return (this.tAdd < 2 ? this.tBase : rand.nextInt(this.tAdd) + this.tBase) * 20;
        }

        int getLevel(Random rand) {
            return this.lAdd < 2 ? this.lBase : rand.nextInt(this.lAdd) + this.lBase;
        }

        Effect getEffect() {
            if (this.effect == null) {
                this.effect = (Effect)Registry.field_212631_t.func_82594_a(new ResourceLocation(this.name));
            }
            return this.effect;
        }
    }
}

