/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.item.Item;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;

public class ConfiguredItemListUtil {
    private static List<String> processTag(String listName, String tagResource) {
        ArrayList<String> items = new ArrayList<String>();
        try {
            ItemTags.Wrapper tag = new ItemTags.Wrapper(new ResourceLocation(tagResource));
            for (Item item : tag.func_199885_a()) {
                try {
                    items.add(item.getRegistryName().toString());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception error) {
            Terraqueous.LOGGER.debug("Error processing " + listName + " tag entry '" + tagResource + "'; " + error);
        }
        return items;
    }

    public static Map<String, String> generateItemList(String listName, List<? extends String> whitelist, List<? extends String> blacklist) {
        if (whitelist != null) {
            String resource;
            Matcher matcher;
            HashMap<String, String> items = new HashMap<String, String>();
            ArrayList<String> removeItems = new ArrayList<String>();
            ArrayList<String> removeMods = new ArrayList<String>();
            for (String string : whitelist) {
                try {
                    matcher = Configuration.Validators.PATTERN_ITEM.matcher(string);
                    if (!matcher.find()) continue;
                    resource = matcher.group(1);
                    String count = matcher.group(2);
                    if (string.startsWith("tag|")) {
                        ConfiguredItemListUtil.processTag(listName, resource).forEach(name -> {
                            if (!items.containsKey(name)) {
                                items.put((String)name, count);
                            }
                        });
                        continue;
                    }
                    if (items.containsKey(resource)) continue;
                    items.put(resource, count);
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error processing " + listName + " whitelist entry '" + string + "'; " + error);
                }
            }
            if (blacklist != null) {
                for (String string : blacklist) {
                    try {
                        matcher = Configuration.Validators.PATTERN_ITEM.matcher(string);
                        if (matcher.find()) {
                            resource = matcher.group(1);
                            if (string.startsWith("tag|")) {
                                removeItems.addAll(ConfiguredItemListUtil.processTag(listName, resource));
                                continue;
                            }
                            removeItems.add(resource);
                            continue;
                        }
                        if (!string.startsWith("mod|")) continue;
                        removeMods.add(string.substring(4));
                    }
                    catch (Exception error) {
                        Terraqueous.LOGGER.debug("Error processing " + listName + " blacklist entry '" + string + "'; " + error);
                    }
                }
                for (String string : removeItems) {
                    items.remove(string);
                }
                items.entrySet().removeIf(entry -> {
                    String modName = ((String)entry.getKey()).split(":")[0];
                    return removeMods.contains(((String)entry.getKey()).split(":")[0]);
                });
            }
            return items;
        }
        return new HashMap<String, String>();
    }
}

