/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import shetiphian.terraqueous.Values;

public class DeathFruitHelper {
    public static IAttribute dfAddiction = new RangedAttribute(null, "terraqueous.deathfruit.addiction", 0.0, 0.0, 200.0).func_111117_a("Death Fruit Addiction");
    public static IAttribute dfTimer = new RangedAttribute(null, "terraqueous.deathfruit.timer", 0.0, 0.0, 180.0).func_111117_a("Death Fruit Timer");
    public static int TIME_TO_CRASH = 36;
    public static int TIME_TO_WITHDRAW = 24;

    public static double addiction(LivingEntity entity, int adjustment) {
        IAttributeInstance attAddiction = entity.func_110148_a(dfAddiction);
        double value = 1.0;
        if (attAddiction != null) {
            double addiction = attAddiction.func_111126_e() + (double)adjustment;
            if (addiction < 0.0) {
                return 1.0;
            }
            attAddiction.func_111128_a(MathHelper.func_151237_a((double)addiction, (double)0.0, (double)200.0));
            value = 1.0 - addiction / 200.0;
        } else {
            entity.func_110140_aT().func_111150_b(dfAddiction);
        }
        return value;
    }

    public static void onPlayerUpdate(PlayerEntity player) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        int ticks = player.field_70173_aa;
        if (ticks % 100 != 0) {
            return;
        }
        IAttributeInstance attTimer = player.func_110148_a(dfTimer);
        if (attTimer == null || attTimer.func_111126_e() < 1.0) {
            DeathFruitHelper.addiction((LivingEntity)player, -1);
            return;
        }
        double remaining = attTimer.func_111126_e();
        attTimer.func_111128_a(Math.max(remaining - 1.0, 0.0));
        if (remaining > (double)(TIME_TO_CRASH + TIME_TO_WITHDRAW)) {
            return;
        }
        Random random = player.func_130014_f_().field_73012_v;
        double value = DeathFruitHelper.addiction((LivingEntity)player, 1);
        if (remaining > (double)TIME_TO_WITHDRAW && remaining <= (double)(TIME_TO_CRASH + TIME_TO_WITHDRAW)) {
            if (player.func_70660_b(Values.effectDeathFruitCrash) == null) {
                player.func_195064_c(new EffectInstance(Values.effectDeathFruitCrash, (int)((remaining - (double)TIME_TO_WITHDRAW) * 100.0), 0, false, false));
            }
            DeathFruitHelper.addPotion(player, DeathFruitHelper.getEffect(random, false), (int)(100.0 / value), value < 0.75 ? random.nextInt(2) : 0);
        }
        if (remaining > 0.0 && remaining <= (double)TIME_TO_WITHDRAW) {
            if (player.func_70660_b(Values.effectDeathFruitWithdraw) == null) {
                player.func_195064_c(new EffectInstance(Values.effectDeathFruitWithdraw, (int)(remaining * 100.0), 0, false, false));
            }
            Effect firstEffect = DeathFruitHelper.getEffect(random, false);
            DeathFruitHelper.addPotion(player, firstEffect, (int)(100.0 / value), random.nextInt(value < 0.75 ? 3 : 2));
            Effect secondEffect = firstEffect;
            while (secondEffect == firstEffect) {
                secondEffect = DeathFruitHelper.getEffect(random, true);
            }
            DeathFruitHelper.addPotion(player, secondEffect, (int)(100.0 / value), value < 0.75 ? random.nextInt(2) : 0);
        }
    }

    private static void addPotion(PlayerEntity player, Effect effect, int time, int severity) {
        if (effect != null) {
            player.func_195064_c(new EffectInstance(effect, time, severity, false, false));
        }
    }

    private static Effect getEffect(Random random, boolean withdraw) {
        switch (random.nextInt(withdraw ? 7 : 5)) {
            case 0: {
                return Effects.field_76438_s;
            }
            case 1: {
                return Effects.field_76421_d;
            }
            case 2: {
                return Effects.field_76437_t;
            }
            case 3: {
                return Effects.field_76419_f;
            }
            case 4: {
                return Effects.field_76440_q;
            }
            case 5: {
                return Effects.field_82731_v;
            }
            case 6: {
                return Effects.field_76431_k;
            }
        }
        return null;
    }
}

