/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class PlantFunctions {
    private static Table<PlantAPI.PlantType, PlantAPI.PlantEvent, int[]> plantChanceTable = HashBasedTable.create();
    private static int[] saplingGrow = new int[10];
    private static int[] fruitFlower = new int[10];
    private static int[] fruitGrow = new int[10];
    private static int[] fruitFall = new int[10];

    public static void load() {
        Configuration.Menu_Plants.SubMenu_PlantGrow grow = Configuration.PLANTS.PLANT_GROW;
        Configuration.Menu_Plants.SubMenu_PlantSpread spread = Configuration.PLANTS.PLANT_SPREAD;
        Configuration.Menu_Plants.SubMenu_FruitGrow fruit_grow = Configuration.PLANTS.FRUIT_GROW;
        plantChanceTable = HashBasedTable.create();
        plantChanceTable.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{(Integer)grow.flower_normal.get(), (Integer)grow.flower_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.FLOWER, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{(Integer)spread.flower_normal.get(), (Integer)spread.flower_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{(Integer)grow.grass_normal.get(), (Integer)grow.grass_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.GRASS, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{(Integer)spread.grass_normal.get(), (Integer)spread.grass_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{(Integer)grow.pineapple_normal.get(), (Integer)grow.pineapple_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.PINEAPPLE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{(Integer)fruit_grow.pineapple_normal.get(), (Integer)fruit_grow.pineapple_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{(Integer)grow.cactus_day.get(), (Integer)grow.cactus_night.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.CACTUS, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{(Integer)fruit_grow.cactus_day.get(), (Integer)fruit_grow.cactus_night.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{(Integer)spread.grapevine_normal.get(), (Integer)spread.grapevine_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.GRAPEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{(Integer)fruit_grow.grapevine_normal.get(), (Integer)fruit_grow.grapevine_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{(Integer)spread.lifevine_normal.get(), (Integer)spread.lifevine_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.LIFEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{(Integer)fruit_grow.lifevine_normal.get(), (Integer)fruit_grow.lifevine_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{(Integer)spread.deathvine_normal.get(), (Integer)spread.deathvine_rain.get()});
        plantChanceTable.put((Object)PlantAPI.PlantType.DEATHVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{(Integer)fruit_grow.deathvine_normal.get(), (Integer)fruit_grow.deathvine_rain.get()});
        saplingGrow = Configuration.TREES.SAPLING_GROW.getValues();
        fruitFlower = Configuration.TREES.FLOWER_GROW.getValues();
        fruitGrow = Configuration.TREES.FRUIT_GROW.getValues();
        fruitFall = Configuration.TREES.FRUIT_FALL.getValues();
    }

    public static boolean canGrow(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantGrow, plant, (IBlockReader)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canSpread(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantSpread, plant, (IBlockReader)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canGrowFruit(World world, BlockPos pos, PlantAPI.PlantType plant) {
        if (!plantChanceTable.contains((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow)) {
            return false;
        }
        int[] chances = (int[])plantChanceTable.get((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow);
        int index = plant == PlantAPI.PlantType.CACTUS ? (world.func_72935_r() ? 0 : 1) : (world.func_72867_j(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.FruitGrow, plant, (IBlockReader)world, pos, chances[index]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static byte getMaxPlacementAttempts(IBlockReader world, BlockPos pos, PlantAPI.PlantType plant) {
        switch (plant) {
            case FLOWER: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerMaxAttempts, world, pos, 5);
            }
            case GRASS: {
                return PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassMaxAttempts, world, pos, 5);
            }
        }
        return 0;
    }

    public static byte[] getSpreadRadius(IBlockReader world, BlockPos pos, PlantAPI.PlantType plant) {
        byte radius;
        switch (plant) {
            case FLOWER: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerSpreadRadius, world, pos, 3);
                break;
            }
            case GRASS: {
                radius = PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassSpreadRadius, world, pos, 3);
                break;
            }
            default: {
                radius = 0;
            }
        }
        byte[] spreadRadius = new byte[]{radius > 0 ? radius : (byte)1, (byte)(radius / 3 * 2) > 0 ? (byte)(radius / 3 * 2) : (byte)1};
        return spreadRadius;
    }

    public static boolean canSaplingGrow(IBlockReader world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingGrow, tree, world, pos, saplingGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruitFlower(IBlockReader world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFlower, tree, world, pos, fruitFlower[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruit(IBlockReader world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitGrow, tree, world, pos, fruitGrow[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropFruit(IBlockReader world, BlockPos pos, PlantAPI.TreeType tree) {
        int eventChance = (Boolean)Configuration.TREES.fruitStaysOnTrees.get() != false ? 0 : PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFall, tree, world, pos, fruitFall[tree.getID()]);
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }
}

