/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesBanana;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniBananaTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class FeatureBananaTree
extends FeatureTreeBase {
    private int flowerChance = 20;
    private static final byte[] mapFoliage = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 9, 5, 1, 5, 9, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 5, 0, 5, 0, 0, 0, 0, 5, 5, 4, 5, 5, 0, 0, 0, 0, 5, 0, 5, 5, 0, 0, 5, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public FeatureBananaTree() {
        this(false);
    }

    public FeatureBananaTree(boolean doBlockNotifyOnPlace) {
        super(doBlockNotifyOnPlace, PlantAPI.TreeType.BANANA);
        this.MINI_TREE = new FeatureMiniBananaTree(doBlockNotifyOnPlace);
    }

    @Override
    protected int getTreeWidth() {
        return 7;
    }

    @Override
    protected int getFoliageHeight() {
        return 4;
    }

    @Override
    protected int getTrunkHeight(Random random) {
        return random.nextInt(3) + 5;
    }

    @Override
    protected byte getMapValue(int index) {
        return mapFoliage[index];
    }

    @Override
    protected BlockState getBlockState(int mapValue, Random random) {
        if (mapValue == 9) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.getBlockState(mapValue, random);
    }

    @Override
    protected void postPlacement(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random random, BlockPos position, MutableBoundingBox boundingBox, int yOffset) {
        super.postPlacement(changedBlocks, world, random, position, boundingBox, yOffset);
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        int treeWidth = this.getTreeWidth();
        int foliageHeight = this.getFoliageHeight();
        int chY = position.func_177956_o() + yOffset;
        for (int sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            int chX = position.func_177958_n() - (treeWidth - 1) / 2;
            for (int sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                int chZ = position.func_177952_p() - (treeWidth - 1) / 2;
                for (int sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.func_181079_c(chX, chY, chZ);
                    int index = sY * treeWidth * treeWidth + sX + sZ * treeWidth;
                    byte mapValue = this.getMapValue(index);
                    if (mapValue == 9 && FeatureBananaTree.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)mPos)) {
                        if (random.nextInt(100) < this.flowerChance) {
                            this.flowerChance = 0;
                            this.setState(changedBlocks, (IWorldWriter)world, (BlockPos)mPos, BlockLeavesBanana.getFlowerVariant(this.LEAVES), boundingBox);
                        }
                        this.flowerChance += 15;
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
    }
}

