/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public abstract class FeatureDoodad
extends Feature<NoFeatureConfig> {
    public FeatureDoodad() {
        super(NoFeatureConfig::func_214639_a);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
        if (WorldGenerator.isBlacklisted((IWorldGenerationReader)world, (List)Configuration.GENERATOR.DIM_BLACKLIST.doodads.get())) {
            return false;
        }
        if (position.func_177956_o() < 1 || position.func_177956_o() > world.getMaxHeight()) {
            return false;
        }
        return this.generate(world, generator, random, position, config);
    }

    protected abstract boolean generate(IWorld var1, ChunkGenerator<? extends GenerationSettings> var2, Random var3, BlockPos var4, NoFeatureConfig var5);

    protected boolean isTopSolid(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_185904_a().func_76230_c() && Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
    }

    protected boolean isReplaceable(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    protected void setBlockState(IWorld world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (block instanceof BlockDoodad && world.func_204610_c(pos).func_206886_c() == ((BlockDoodad)block).getFluid()) {
            state = (BlockState)state.func_206870_a((IProperty)BlockDoodad.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        super.func_202278_a((IWorldWriter)world, pos, state);
    }

    public static abstract class Crystal
    extends FeatureDoodad {
        protected void placeCrystal(IWorld world, BlockPos pos, BlockState crystal, BlockState ore, boolean isExtra, Random random, Tag<Block> blockTag) {
            if (isExtra) {
                if (!this.isReplaceable(world, pos) || !this.isTopSolid(world, pos.func_177977_b())) {
                    return;
                }
                if (!blockTag.func_199685_a_((Object)world.func_180495_p(pos.func_177977_b()).func_177230_c()) || !random.nextBoolean()) {
                    return;
                }
            }
            this.setBlockState(world, pos, crystal);
            if (ore != null) {
                this.setBlockState(world, pos.func_177977_b(), ore);
            }
        }

        protected void generateOre(IWorld world, BlockPos pos, BlockState ore, Random random, Tag<Block> blockTag) {
            pos = pos.func_177977_b();
            int yMin = pos.func_177956_o() - (random.nextInt(4) + 1);
            int yMax = pos.func_177956_o() + (random.nextInt(4) + 1);
            for (int yCurrent = yMin; yCurrent <= yMax; ++yCurrent) {
                int parts = random.nextInt(6) + 1;
                for (int part = 0; part < parts; ++part) {
                    int xOffset = random.nextInt(5) - 3;
                    int zOffset = random.nextInt(5) - 3;
                    int xMin = pos.func_177958_n() - (random.nextInt(1) + 1) + xOffset;
                    int xMax = pos.func_177958_n() + (random.nextInt(1) + 1) + xOffset;
                    int zMin = pos.func_177952_p() - (random.nextInt(1) + 1) + zOffset;
                    int zMax = pos.func_177952_p() + (random.nextInt(1) + 1) + zOffset;
                    for (int xCurrent = xMin; xCurrent <= xMax; ++xCurrent) {
                        for (int zCurrent = zMin; zCurrent <= zMax; ++zCurrent) {
                            BlockPos place = new BlockPos(xCurrent, yCurrent, zCurrent);
                            if (!blockTag.func_199685_a_((Object)world.func_180495_p(place).func_177230_c())) continue;
                            this.setBlockState(world, place, ore);
                        }
                    }
                }
            }
        }

        public static class Endimium
        extends Crystal {
            @Override
            protected boolean generate(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
                if (!this.isTopSolid(world, position.func_177977_b())) {
                    return false;
                }
                if (random.nextBoolean()) {
                    return false;
                }
                BlockState crystalEndimium = Values.blockDoodadEndimium.func_176223_P();
                BlockState oreEndimium = Values.blockEndimiumOre.func_176223_P();
                if (Tags.Blocks.END_STONES.func_199685_a_((Object)world.func_180495_p(position.func_177977_b()).func_177230_c())) {
                    this.placeCrystal(world, position, crystalEndimium, oreEndimium, false, random, (Tag<Block>)Tags.Blocks.END_STONES);
                    this.generateOre(world, position, oreEndimium, random, (Tag<Block>)Tags.Blocks.END_STONES);
                }
                return true;
            }
        }

        public static class Burnium
        extends Crystal {
            @Override
            protected boolean generate(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
                boolean placed = false;
                BlockPos sPos = new BlockPos(position.func_177958_n(), 1, position.func_177952_p());
                while (sPos.func_177956_o() < world.func_217301_I()) {
                    if (random.nextBoolean() && random.nextBoolean() && this.isReplaceable(world, sPos) && this.isTopSolid(world, sPos.func_177977_b())) {
                        BlockState crystalBurnium = Values.blockDoodadBurnium.func_176223_P();
                        BlockState oreBurnium = Values.blockBurniumOre.func_176223_P();
                        if (Tags.Blocks.NETHERRACK.func_199685_a_((Object)world.func_180495_p(sPos.func_177977_b()).func_177230_c())) {
                            this.placeCrystal(world, sPos, crystalBurnium, oreBurnium, false, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            this.placeCrystal(world, sPos.func_177976_e(), crystalBurnium, oreBurnium, true, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            this.placeCrystal(world, sPos.func_177974_f(), crystalBurnium, oreBurnium, true, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            this.placeCrystal(world, sPos.func_177978_c(), crystalBurnium, oreBurnium, true, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            this.placeCrystal(world, sPos.func_177968_d(), crystalBurnium, oreBurnium, true, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            this.generateOre(world, sPos, oreBurnium, random, (Tag<Block>)Tags.Blocks.NETHERRACK);
                            placed = true;
                        }
                    }
                    sPos = sPos.func_177984_a();
                }
                return placed;
            }
        }
    }

    public static class Bone
    extends FeatureDoodad {
        @Override
        protected boolean generate(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
            if (!this.isTopSolid(world, position.func_177977_b())) {
                return false;
            }
            this.setBlockState(world, position, Values.blockDoodadBone.func_176223_P());
            return false;
        }
    }

    public static class Stone
    extends FeatureDoodad {
        private static final Tag<Block> SANDSTONE_RED = new BlockTags.Wrapper(new ResourceLocation("forge", "sandstone/red"));
        private static final Tag<Block> SANDSTONE_COLORLESS = new BlockTags.Wrapper(new ResourceLocation("forge", "sandstone/colorless"));

        @Override
        protected boolean generate(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
            boolean placed = false;
            BlockPos sPos = new BlockPos(position.func_177958_n(), 1, position.func_177952_p());
            while (sPos.func_177956_o() < world.func_217301_I()) {
                if (sPos.func_177956_o() < position.func_177956_o() - 8) {
                    for (int attempt = 0; attempt < 3; ++attempt) {
                        placed = this.placeStone(world, sPos.func_177982_a(random.nextInt(8) - random.nextInt(8), 0, random.nextInt(8) - random.nextInt(8)), random);
                    }
                } else {
                    placed = this.placeStone(world, sPos, random);
                }
                sPos = sPos.func_177984_a();
            }
            return placed;
        }

        private boolean placeStone(IWorld world, BlockPos pos, Random random) {
            if (random.nextBoolean() && this.isReplaceable(world, pos) && this.isTopSolid(world, pos.func_177977_b())) {
                BlockState state = world.func_180495_p(pos.func_177977_b());
                if (Tags.Blocks.SAND_RED.func_199685_a_((Object)state.func_177230_c()) || SANDSTONE_RED.func_199685_a_((Object)state.func_177230_c())) {
                    this.setBlockState(world, pos, Values.blockDoodadRedSandStone.func_176223_P());
                    return true;
                }
                if (Tags.Blocks.SAND_COLORLESS.func_199685_a_((Object)state.func_177230_c()) || SANDSTONE_COLORLESS.func_199685_a_((Object)state.func_177230_c())) {
                    this.setBlockState(world, pos, Values.blockDoodadSandStone.func_176223_P());
                    return true;
                }
                this.setBlockState(world, pos, Values.blockDoodadStone.func_176223_P());
                return true;
            }
            return false;
        }
    }

    public static class Stick
    extends FeatureDoodad {
        @Override
        protected boolean generate(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
            if (!this.isTopSolid(world, position.func_177977_b())) {
                return false;
            }
            this.setBlockState(world, position, Values.blockDoodadBranch.func_176223_P());
            return false;
        }
    }
}

