/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.DefaultFlowersFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.ForestFlowersFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.PlainsFlowersFeature;
import net.minecraft.world.gen.feature.SwampFlowersFeature;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;

public abstract class FeatureFlowers
extends FlowersFeature {
    private final List<Block> FLOWERS = new ArrayList<Block>();
    protected FlowersFeature FALLBACK = new DefaultFlowersFeature(NoFeatureConfig::func_214639_a);

    public FeatureFlowers(String ... ids) {
        super(NoFeatureConfig::func_214639_a);
        for (String id : ids) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("terraqueous", id));
            if (block == null) continue;
            this.FLOWERS.add(block);
        }
    }

    public boolean func_212245_a(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
        if (!world.func_217375_a(position, state -> state.func_177230_c() instanceof SaplingBlock) && WorldGenerator.isBlacklisted((IWorldGenerationReader)world, (List)Configuration.GENERATOR.DIM_BLACKLIST.flowers.get())) {
            return false;
        }
        return super.func_212245_a(world, generator, random, position, config);
    }

    public BlockState func_202355_a(Random random, BlockPos pos) {
        if (this.FLOWERS.isEmpty()) {
            return this.FALLBACK.func_202355_a(random, pos);
        }
        double d0 = MathHelper.func_151237_a((double)((1.0 + Biome.field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        return this.FLOWERS.get((int)(d0 * (double)this.FLOWERS.size())).func_176223_P();
    }

    public static class Magic
    extends FeatureFlowers {
        public Magic() {
            super("trickster_bloom");
        }
    }

    public static class Jungle
    extends FeatureFlowers {
        public Jungle() {
            super("fern", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "primrose");
        }
    }

    public static class Water
    extends FeatureFlowers {
        public Water() {
            super("burdock", "leichtlinii", "deirdre", "blue_bell");
            this.FALLBACK = new SwampFlowersFeature(NoFeatureConfig::func_214639_a);
        }
    }

    public static class Mountain
    extends FeatureFlowers {
        public Mountain() {
            super("burdock", "lavender", "rose");
        }
    }

    public static class Plains
    extends FeatureFlowers {
        public Plains() {
            super("black_rose", "carnation", "lavender", "rose", "daffodil", "primrose", "marigold", "tulip");
            this.FALLBACK = new PlainsFlowersFeature(NoFeatureConfig::func_214639_a);
        }
    }

    public static class Forest
    extends FeatureFlowers {
        public Forest() {
            super("fern", "trickster_bloom", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "primrose");
            this.FALLBACK = new ForestFlowersFeature(NoFeatureConfig::func_214639_a);
        }
    }

    public static class All
    extends FeatureFlowers {
        public All() {
            super("black_rose", "carnation", "fern", "burdock", "trickster_bloom", "lavender", "leichtlinii", "ghost_plant", "gray_ghost_plant", "rose", "deirdre", "daffodil", "blue_bell", "primrose", "marigold", "tulip");
        }
    }
}

